/*
 * Decompiled with CFR 0.152.
 */
package v0id.vsb.net.message;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import v0id.api.vsb.capability.IBackpack;
import v0id.api.vsb.item.IUpgradeWrapper;
import v0id.vsb.item.upgrade.UpgradeHotbarSwapper;
import v0id.vsb.util.VSBUtils;

public class ScrollHotbar
implements IMessage {
    private int slotID;
    private int direction;

    public ScrollHotbar(int slotID, int direction) {
        this.slotID = slotID;
        this.direction = direction;
    }

    public ScrollHotbar() {
    }

    public void fromBytes(ByteBuf buf) {
        this.slotID = buf.readInt();
        this.direction = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slotID);
        buf.writeInt(this.direction);
    }

    public static class Handler
    implements IMessageHandler<ScrollHotbar, IMessage> {
        public IMessage onMessage(ScrollHotbar message, MessageContext ctx) {
            EntityPlayerMP sender = ctx.getServerHandler().field_147369_b;
            if (message.slotID < sender.field_71071_by.func_70302_i_()) {
                sender.func_71121_q().func_152344_a(() -> {
                    ItemStack backpack = VSBUtils.checkBackpackForHotbarUpgrade(VSBUtils.getBackpack((EntityPlayer)sender, message.slotID));
                    if (!backpack.func_190926_b()) {
                        IBackpack iBackpack = IBackpack.of(backpack);
                        ItemStack upgrade = ItemStack.field_190927_a;
                        for (IUpgradeWrapper wrapper : iBackpack.createWrapper().getReadonlyUpdatesArray()) {
                            if (wrapper == null || !(wrapper.getUpgrade() instanceof UpgradeHotbarSwapper)) continue;
                            upgrade = wrapper.getSelf();
                            break;
                        }
                        if (upgrade != ItemStack.field_190927_a) {
                            int i;
                            int index;
                            int n = index = upgrade.func_77942_o() ? upgrade.func_77978_p().func_74762_e("index") : 0;
                            index = index < 0 ? VSBUtils.getBackpackRows(iBackpack.createWrapper().getBackpackType()) - 1 : (index >= VSBUtils.getBackpackRows(iBackpack.createWrapper().getBackpackType()) ? 0 : index);
                            ItemStack[] playerHotbar = new ItemStack[9];
                            for (i = 0; i < 9; ++i) {
                                playerHotbar[i] = sender.field_71071_by.func_70301_a(i).func_77946_l();
                            }
                            for (i = 0; i < 9; ++i) {
                                int ai = index * 9 + i;
                                if (ai < 0 || ai >= iBackpack.getInventory().getSlots()) {
                                    return;
                                }
                                if (IBackpack.of(sender.field_71071_by.func_70301_a(i)) != null) continue;
                                sender.field_71071_by.func_70299_a(i, iBackpack.getInventory().getStackInSlot(ai).func_77946_l());
                                iBackpack.getInventory().extractItem(ai, Integer.MAX_VALUE, false);
                                iBackpack.getInventory().insertItem(ai, playerHotbar[i], false);
                            }
                            sender.func_130014_f_().func_184148_a(null, sender.field_70165_t, sender.field_70163_u, sender.field_70161_v, SoundEvents.field_187728_s, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            int n2 = (index += message.direction) < 0 ? VSBUtils.getBackpackRows(iBackpack.createWrapper().getBackpackType()) - 1 : (index = index >= VSBUtils.getBackpackRows(iBackpack.createWrapper().getBackpackType()) ? 0 : index);
                            if (!upgrade.func_77942_o()) {
                                upgrade.func_77982_d(new NBTTagCompound());
                            }
                            upgrade.func_77978_p().func_74768_a("index", index);
                        }
                    }
                });
            }
            return null;
        }
    }
}

