/*
 * Decompiled with CFR 0.152.
 */
package v0id.vsb.item.upgrade;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import v0id.api.vsb.capability.IFilter;
import v0id.api.vsb.item.IBackpackWrapper;
import v0id.api.vsb.item.IUpgradeWrapper;
import v0id.vsb.config.VSBCfg;
import v0id.vsb.item.upgrade.UpgradeFiltered;
import v0id.vsb.item.upgrade.UpgradeInductionCoil;
import v0id.vsb.util.VSBUtils;

public class UpgradeGrinding
extends UpgradeFiltered {
    private Map<String, ItemStack> oreToDustCache = Maps.newHashMap();

    public UpgradeGrinding() {
        super("upgrade_grinding");
    }

    private int getProgress(ItemStack stack) {
        return stack.func_77978_p().func_74762_e("progress");
    }

    private void setProgress(ItemStack is, int i) {
        is.func_77978_p().func_74768_a("progress", i);
    }

    private int getFuel(ItemStack is) {
        return is.func_77978_p().func_74762_e("fuel");
    }

    private void setFuel(ItemStack is, int i) {
        is.func_77978_p().func_74768_a("fuel", i);
    }

    private int getSlot(ItemStack is) {
        return is.func_77978_p().func_74762_e("index");
    }

    private void setSlot(ItemStack is, int i) {
        is.func_77978_p().func_74768_a("index", i);
    }

    private boolean isProcessing(ItemStack is) {
        return is.func_77978_p().func_74767_n("processing");
    }

    private void setProcessing(ItemStack is, boolean b) {
        is.func_77978_p().func_74757_a("processing", b);
    }

    private ItemStack getDust(ItemStack is) {
        String[] oreNames = VSBUtils.getOreNames(is);
        ItemStack dust = ItemStack.field_190927_a;
        int dustAmt = 1;
        for (String name : oreNames) {
            ItemStack stack;
            if (this.oreToDustCache.containsKey(name)) {
                return this.oreToDustCache.get(name).func_77946_l();
            }
            StringBuilder dustName = new StringBuilder("dust");
            if (name.startsWith("ore") || name.startsWith("gem")) {
                dustName.append(name.substring(3));
                dustAmt = name.startsWith("ore") ? 2 : 1;
            } else if (name.startsWith("ingot")) {
                dustName.append(name.substring(5));
            } else {
                dustName.append(name);
            }
            NonNullList dusts = OreDictionary.getOres((String)dustName.toString(), (boolean)false);
            if (dusts == null || dusts.isEmpty() || (stack = VSBUtils.firstMatch(i -> !i.func_190926_b(), dusts)) == null) continue;
            stack = stack.func_77946_l();
            stack.func_190920_e(dustAmt);
            this.oreToDustCache.put(name, stack);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.addAll(Arrays.asList(I18n.func_135052_a((String)"vsb.txt.upgrade.grinding.desc", (Object[])new Object[0]).split("\\|")));
    }

    @Override
    public void onTick(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, Entity ticker) {
        int index;
        if (!self.getSelf().func_77942_o()) {
            self.getSelf().func_77982_d(new NBTTagCompound());
        }
        int fuel = this.getFuel(self.getSelf());
        IFilter filter = IFilter.of(((IItemHandler)self.getSelf().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(0));
        if (fuel <= 0) {
            boolean hasCoil = false;
            for (IUpgradeWrapper upgradeWrapper : backpack.getReadonlyUpdatesArray()) {
                if (upgradeWrapper == null || !(upgradeWrapper.getSelf().func_77973_b() instanceof UpgradeInductionCoil)) continue;
                hasCoil = true;
                break;
            }
            if (!hasCoil) {
                for (int i = 0; i < backpack.getInventory().getSlots(); ++i) {
                    ItemStack is = backpack.getInventory().getStackInSlot(i);
                    if (!TileEntityFurnace.func_145954_b((ItemStack)is)) continue;
                    this.setFuel(self.getSelf(), TileEntityFurnace.func_145952_a((ItemStack)is));
                    fuel = this.getFuel(self.getSelf());
                    backpack.getInventory().extractItem(i, 1, false);
                    break;
                }
            } else {
                int energy = backpack.getSelfAsCapability().getEnergyStorage().getEnergyStored();
                if (energy >= VSBCfg.inductionCoilUpgradeEnergyPerFuel * 20) {
                    backpack.getSelfAsCapability().getEnergyStorage().extractEnergy(VSBCfg.inductionCoilUpgradeEnergyPerFuel * 20, false);
                    this.setFuel(self.getSelf(), 20);
                    fuel = 20;
                }
            }
        }
        if (fuel <= 0 && this.isProcessing(self.getSelf())) {
            this.setProcessing(self.getSelf(), false);
            this.setProgress(self.getSelf(), 0);
            return;
        }
        if (!this.isProcessing(self.getSelf())) {
            ItemStack result;
            index = this.getSlot(self.getSelf());
            if (index >= backpack.getInventory().getSlots()) {
                index = 0;
            }
            boolean allowGo = true;
            ItemStack is = backpack.getInventory().getStackInSlot(index);
            ItemStack itemStack = result = is.func_190926_b() ? ItemStack.field_190927_a : this.getDust(is);
            if (!result.func_190926_b() && (filter == null || filter.accepts(is)) && ItemHandlerHelper.insertItemStacked((IItemHandler)backpack.getInventory(), (ItemStack)result, (boolean)true).func_190926_b()) {
                allowGo = false;
                this.setProgress(self.getSelf(), 0);
                this.setProcessing(self.getSelf(), true);
            }
            if (allowGo) {
                this.setSlot(self.getSelf(), ++index);
            }
        } else {
            ItemStack is;
            ItemStack result;
            index = this.getSlot(self.getSelf());
            if (index >= backpack.getInventory().getSlots()) {
                index = 0;
            }
            ItemStack itemStack = result = (is = backpack.getInventory().getStackInSlot(index)).func_190926_b() ? ItemStack.field_190927_a : this.getDust(is);
            if (!result.func_190926_b() && (filter == null || filter.accepts(is))) {
                if (ItemHandlerHelper.insertItemStacked((IItemHandler)backpack.getInventory(), (ItemStack)result, (boolean)true).func_190926_b()) {
                    this.setProgress(self.getSelf(), this.getProgress(self.getSelf()) + 1);
                    this.setFuel(self.getSelf(), this.getFuel(self.getSelf()) - 1);
                    if (this.getProgress(self.getSelf()) >= 400) {
                        this.setProgress(self.getSelf(), 0);
                        this.setProcessing(self.getSelf(), false);
                        backpack.getInventory().extractItem(index, 1, false);
                        ItemHandlerHelper.insertItemStacked((IItemHandler)backpack.getInventory(), (ItemStack)result.func_77946_l(), (boolean)false);
                    }
                } else {
                    this.setProgress(self.getSelf(), 0);
                    this.setProcessing(self.getSelf(), false);
                }
            } else {
                this.setProgress(self.getSelf(), 0);
                this.setProcessing(self.getSelf(), false);
            }
        }
    }

    @Override
    public void onPulse(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, Entity pulsar) {
    }

    @Override
    public boolean onItemPickup(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, EntityItem item, Entity picker) {
        return false;
    }

    @Override
    public void onInstalled(IBackpackWrapper backpack, IUpgradeWrapper self) {
    }

    @Override
    public void onUninstalled(IBackpackWrapper backpack, IUpgradeWrapper self) {
    }

    @Override
    public boolean canInstall(IBackpackWrapper backpack, IUpgradeWrapper self) {
        return !Arrays.stream(backpack.getReadonlyUpdatesArray()).filter(Objects::nonNull).map(IUpgradeWrapper::getSelf).anyMatch(i -> i.func_77973_b() == self.getSelf().func_77973_b());
    }

    @Override
    public boolean hasSyncTag() {
        return false;
    }
}

