/*
 * Decompiled with CFR 0.152.
 */
package v0id.vsb.item.upgrade;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import v0id.api.vsb.capability.IFilter;
import v0id.api.vsb.item.IBackpackWrapper;
import v0id.api.vsb.item.IUpgradeWrapper;
import v0id.vsb.config.VSBCfg;
import v0id.vsb.item.upgrade.UpgradeFiltered;

public class UpgradeFurnaceGenerator
extends UpgradeFiltered {
    public UpgradeFurnaceGenerator() {
        super("upgrade_generator_furnace");
    }

    private int getFuel(ItemStack is) {
        return is.func_77978_p().func_74762_e("fuel");
    }

    private void setFuel(ItemStack is, int i) {
        is.func_77978_p().func_74768_a("fuel", i);
    }

    private int getSlot(ItemStack is) {
        return is.func_77978_p().func_74762_e("index");
    }

    private void setSlot(ItemStack is, int i) {
        is.func_77978_p().func_74768_a("index", i);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.addAll(Arrays.asList(I18n.func_135052_a((String)"vsb.txt.upgrade.generator_furnace.desc", (Object[])new Object[0]).split("\\|")));
    }

    @Override
    public void onTick(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, Entity ticker) {
        int fuel;
        if (!self.getSelf().func_77942_o()) {
            self.getSelf().func_77982_d(new NBTTagCompound());
        }
        if ((fuel = this.getFuel(self.getSelf())) <= 0) {
            int index = this.getSlot(self.getSelf());
            if (index >= backpack.getInventory().getSlots()) {
                index = 0;
            }
            ItemStack is = backpack.getInventory().getStackInSlot(index);
            IFilter filter = IFilter.of(((IItemHandler)self.getSelf().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(0));
            if (TileEntityFurnace.func_145954_b((ItemStack)is) && (filter == null || filter.accepts(is))) {
                this.setFuel(self.getSelf(), TileEntityFurnace.func_145952_a((ItemStack)is));
                fuel = this.getFuel(self.getSelf());
                backpack.getInventory().extractItem(index, 1, false);
            }
            this.setSlot(self.getSelf(), ++index);
        }
        if (fuel > 0) {
            this.setFuel(self.getSelf(), --fuel);
            backpack.getSelfAsCapability().getEnergyStorage().receiveEnergy(VSBCfg.furnaceUpgradeFEPerTick, false);
        }
    }

    @Override
    public void onPulse(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, Entity pulsar) {
    }

    @Override
    public boolean onItemPickup(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, EntityItem item, Entity picker) {
        return false;
    }

    @Override
    public void onInstalled(IBackpackWrapper backpack, IUpgradeWrapper self) {
    }

    @Override
    public void onUninstalled(IBackpackWrapper backpack, IUpgradeWrapper self) {
    }

    @Override
    public boolean canInstall(IBackpackWrapper backpack, IUpgradeWrapper self) {
        return backpack.getMaxEnergy() > 0;
    }

    @Override
    public boolean hasSyncTag() {
        return false;
    }
}

