/*
 * Decompiled with CFR 0.152.
 */
package v0id.vsb.item.upgrade;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.FoodStats;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import v0id.api.vsb.capability.IFilter;
import v0id.api.vsb.item.IBackpackWrapper;
import v0id.api.vsb.item.IUpgradeWrapper;
import v0id.vsb.item.upgrade.UpgradeFiltered;
import v0id.vsb.util.Lazy;
import v0id.vsb.util.VSBUtils;

public class UpgradeFeeding
extends UpgradeFiltered {
    private final Field fieldItemFood_healAmount = VSBUtils.getFieldSafe(ItemFood.class, "healAmount", "field_77853_b");
    private final Lazy<Class<?>> class_NutrientUtils = new Lazy<Class>(() -> VSBUtils.getOptionalClass("ca.wescook.nutrition.nutrients.NutrientUtils", () -> Loader.isModLoaded((String)"nutrition")));
    private final Lazy<Class<?>> class_CapabilityManager = new Lazy<Class>(() -> VSBUtils.getOptionalClass("ca.wescook.nutrition.capabilities.CapabilityManager", () -> Loader.isModLoaded((String)"nutrition")));
    private final Lazy<Class<?>> class_INutrientManager = new Lazy<Class>(() -> VSBUtils.getOptionalClass("ca.wescook.nutrition.capabilities.INutrientManager", () -> Loader.isModLoaded((String)"nutrition")));
    private final Lazy<Field> capabilityManager_NutritionCapability = new Lazy<Field>(() -> VSBUtils.getFieldSafe(this.class_CapabilityManager.get(), "NUTRITION_CAPABILITY"));
    private final Lazy<Method> nutrientUtils_getFoodNutrients = new Lazy<Method>(() -> VSBUtils.getMethodSafe(this.class_NutrientUtils.get(), new Class[]{ItemStack.class}, "getFoodNutrients"));
    private final Lazy<Method> nutrientUtils_calculateNutrition = new Lazy<Method>(() -> VSBUtils.getMethodSafe(this.class_NutrientUtils.get(), new Class[]{ItemStack.class, List.class}, "calculateNutrition"));
    private final Lazy<Method> iNutrientManager_add = new Lazy<Method>(() -> VSBUtils.getMethodSafe(this.class_INutrientManager.get(), new Class[]{List.class, Float.TYPE}, "add"));
    private final Lazy<Capability> nutritionCapability = new Lazy<Capability>(() -> (Capability)VSBUtils.getFieldValue(this.capabilityManager_NutritionCapability.get(), null));

    public UpgradeFeeding() {
        super("upgrade_feeding");
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.addAll(Arrays.asList(I18n.func_135052_a((String)"vsb.txt.upgrade.feeding.desc", (Object[])new Object[0]).split("\\|")));
    }

    @Override
    public void onTick(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, Entity ticker) {
    }

    @Override
    public void onPulse(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, Entity pulsar) {
        FoodStats foodStats;
        int needed;
        if (pulsar instanceof EntityPlayer && (needed = 20 - (foodStats = ((EntityPlayer)pulsar).func_71024_bL()).func_75116_a()) > 0) {
            int highestSlot = -1;
            int maxHealAmount = -1;
            for (int i = 0; i < backpack.getInventory().getSlots(); ++i) {
                IFilter filter;
                ItemStack is = backpack.getInventory().getStackInSlot(i);
                if (is.func_190926_b() || !(is.func_77973_b() instanceof ItemFood) || (filter = IFilter.of(((IItemHandler)self.getSelf().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(0))) != null && !filter.accepts(is)) continue;
                int healAmount = 0;
                try {
                    healAmount = this.fieldItemFood_healAmount.getInt(is.func_77973_b());
                }
                catch (IllegalAccessException e) {
                    this.fieldItemFood_healAmount.setAccessible(true);
                    try {
                        healAmount = this.fieldItemFood_healAmount.getInt(is.func_77973_b());
                    }
                    catch (IllegalAccessException e1) {
                        FMLCommonHandler.instance().raiseException((Throwable)e1, "An impossible reflection exception has occurred.", true);
                    }
                }
                if (healAmount <= maxHealAmount || healAmount > needed) continue;
                maxHealAmount = healAmount;
                highestSlot = i;
                if (healAmount == needed) break;
            }
            if (highestSlot != -1) {
                ItemStack food = backpack.getInventory().getStackInSlot(highestSlot);
                ItemFood foodItem = (ItemFood)food.func_77973_b();
                ItemStack stack = food.func_77946_l();
                stack.func_190920_e(1);
                foodItem.func_77654_b(food, pulsar.field_70170_p, (EntityLivingBase)pulsar);
                backpack.markInventoryDirty();
                if (Loader.isModLoaded((String)"nutrition")) {
                    try {
                        List nutrients = (List)VSBUtils.invokeMethod(this.nutrientUtils_getFoodNutrients.get(), null, stack);
                        float nutValue = ((Float)VSBUtils.invokeMethod(this.nutrientUtils_calculateNutrition.get(), null, stack, nutrients)).floatValue();
                        Object cap = pulsar.getCapability(this.nutritionCapability.get(), null);
                        VSBUtils.invokeMethod(this.iNutrientManager_add.get(), cap, nutrients, Float.valueOf(nutValue));
                    }
                    catch (Exception ex) {
                        FMLCommonHandler.instance().raiseException((Throwable)ex, "VSB caught an error trying to reflect Nutrition", false);
                    }
                }
            }
        }
    }

    @Override
    public boolean onItemPickup(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, EntityItem item, Entity picker) {
        return false;
    }

    @Override
    public void onInstalled(IBackpackWrapper backpack, IUpgradeWrapper self) {
    }

    @Override
    public void onUninstalled(IBackpackWrapper backpack, IUpgradeWrapper self) {
    }

    @Override
    public boolean canInstall(IBackpackWrapper backpack, IUpgradeWrapper self) {
        return !Arrays.stream(backpack.getReadonlyUpdatesArray()).filter(Objects::nonNull).map(IUpgradeWrapper::getSelf).anyMatch(i -> i.func_77973_b() == self.getSelf().func_77973_b());
    }

    @Override
    public boolean hasSyncTag() {
        return false;
    }
}

