/*
 * Decompiled with CFR 0.152.
 */
package v0id.vsb.item.upgrade;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.ArrayUtils;
import v0id.api.vsb.capability.ICraftingUpgrade;
import v0id.api.vsb.capability.VSBCaps;
import v0id.api.vsb.item.IBackpackWrapper;
import v0id.api.vsb.item.IGUIOpenable;
import v0id.api.vsb.item.IUpgrade;
import v0id.api.vsb.item.IUpgradeWrapper;
import v0id.vsb.capability.CraftingUpgrade;
import v0id.vsb.container.ContainerCraftingUpgrade;
import v0id.vsb.item.ItemSimple;
import v0id.vsb.net.VSBNet;
import v0id.vsb.util.EnumGuiType;
import v0id.vsb.util.VSBUtils;

public class UpgradeCrafting
extends ItemSimple
implements IUpgrade,
IGUIOpenable {
    private InventoryCrafting crafting;

    public UpgradeCrafting() {
        super("upgrade_crafting", 1);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.addAll(Arrays.asList(I18n.func_135052_a((String)"vsb.txt.upgrade.crafting.desc", (Object[])new Object[0]).split("\\|")));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (playerIn instanceof EntityPlayerMP) {
            ItemStack is = playerIn.func_184586_b(handIn);
            int slot = handIn == EnumHand.MAIN_HAND ? playerIn.field_71071_by.field_70461_c : -1;
            VSBUtils.openContainer((EntityPlayerMP)playerIn, new ContainerCraftingUpgrade(playerIn.field_71071_by, is, slot));
            VSBNet.sendOpenGUI(playerIn, handIn == EnumHand.MAIN_HAND ? playerIn.field_71071_by.field_70461_c : 40, true, slot, EnumGuiType.UPGRADE_CRAFTING);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)is);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ICapabilitySerializable<NBTTagCompound>(){
            private final CraftingUpgrade cap = new CraftingUpgrade();

            public NBTTagCompound serializeNBT() {
                return this.cap.serializeNBT();
            }

            public void deserializeNBT(NBTTagCompound nbt) {
                this.cap.deserializeNBT(nbt);
            }

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == VSBCaps.CRAFTING_UPGRADE_CAPABILITY;
            }

            @Nullable
            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                return (T)(capability == VSBCaps.CRAFTING_UPGRADE_CAPABILITY ? VSBCaps.CRAFTING_UPGRADE_CAPABILITY.cast((Object)this.cap) : null);
            }
        };
    }

    @Override
    public void onTick(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, Entity ticker) {
    }

    @Override
    public void onPulse(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, Entity pulsar) {
        ICraftingUpgrade craftingUpgrade;
        if (pulsar instanceof EntityPlayerMP && (craftingUpgrade = ICraftingUpgrade.of(self.getSelf())) != null) {
            InventoryCrafting inventoryCrafting = new InventoryCrafting((Container)new ContainerWorkbench(((EntityPlayerMP)pulsar).field_71071_by, pulsar.field_70170_p, pulsar.func_180425_c()), 3, 3);
            for (int i = 0; i < craftingUpgrade.getInventory().getSlots(); ++i) {
                inventoryCrafting.func_70299_a(i, craftingUpgrade.getInventory().getStackInSlot(i));
            }
            IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)inventoryCrafting, (World)pulsar.field_70170_p);
            if (recipe != null) {
                ItemStack result;
                int i;
                int[] slotIndices = VSBUtils.createDefaultArray(9, -2);
                block1: for (i = 0; i < craftingUpgrade.getInventory().getSlots(); ++i) {
                    ItemStack compareTo = craftingUpgrade.getInventory().getStackInSlot(i);
                    if (compareTo.func_190926_b()) {
                        slotIndices[i] = -1;
                        continue;
                    }
                    boolean oreDict = craftingUpgrade.getOreDictFlags()[i];
                    for (int j = 0; j < backpack.getInventory().getSlots(); ++j) {
                        ItemStack is = backpack.getInventory().getStackInSlot(j);
                        if (is.func_190926_b()) continue;
                        if (oreDict) {
                            if (!VSBUtils.isOreDictionaryMatch(compareTo, is)) continue;
                            slotIndices[i] = j;
                            continue block1;
                        }
                        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)is, (ItemStack)compareTo)) continue;
                        slotIndices[i] = j;
                        continue block1;
                    }
                }
                if (ArrayUtils.contains((int[])slotIndices, (int)-2)) {
                    return;
                }
                for (i = 0; i < 9; ++i) {
                    ItemStack stack = slotIndices[i] == -1 ? ItemStack.field_190927_a : backpack.getInventory().getStackInSlot(slotIndices[i]);
                    inventoryCrafting.func_70299_a(i, stack);
                }
                recipe = CraftingManager.func_192413_b((InventoryCrafting)inventoryCrafting, (World)pulsar.field_70170_p);
                if (recipe != null && !(result = recipe.func_77572_b(inventoryCrafting)).func_190926_b()) {
                    while (true) {
                        if (ItemHandlerHelper.insertItemStacked((IItemHandler)backpack.getInventory(), (ItemStack)result, (boolean)true) != ItemStack.field_190927_a) {
                            return;
                        }
                        for (int i2 = 0; i2 < 9; ++i2) {
                            int id = slotIndices[i2];
                            if (id == -1) continue;
                            inventoryCrafting.func_70299_a(i2, backpack.getInventory().getStackInSlot(id));
                            if (!backpack.getInventory().getStackInSlot(id).func_190926_b()) continue;
                            return;
                        }
                        if (!recipe.func_77569_a(inventoryCrafting, pulsar.field_70170_p)) {
                            return;
                        }
                        for (int id : slotIndices) {
                            if (id == -1) continue;
                            backpack.getInventory().extractItem(id, 1, false);
                        }
                        ItemHandlerHelper.insertItemStacked((IItemHandler)backpack.getInventory(), (ItemStack)result.func_77946_l(), (boolean)false);
                    }
                }
            }
        }
    }

    @Override
    public boolean onItemPickup(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, EntityItem item, Entity picker) {
        return false;
    }

    @Override
    public void onInstalled(IBackpackWrapper backpack, IUpgradeWrapper self) {
    }

    @Override
    public void onUninstalled(IBackpackWrapper backpack, IUpgradeWrapper self) {
    }

    @Override
    public boolean canInstall(IBackpackWrapper backpack, IUpgradeWrapper self) {
        return true;
    }

    @Override
    public boolean hasSyncTag() {
        return false;
    }

    @Override
    public void openContainer(EntityPlayerMP player, ItemStack stack, int slot, int slotID) {
        VSBUtils.openContainer(player, new ContainerCraftingUpgrade(player.field_71071_by, stack, slot));
        VSBNet.sendOpenGUI((EntityPlayer)player, slotID, true, slot, EnumGuiType.UPGRADE_CRAFTING);
    }
}

