/*
 * Decompiled with CFR 0.152.
 */
package v0id.vsb.item.upgrade;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import v0id.api.vsb.capability.IFilter;
import v0id.api.vsb.item.IBackpackWrapper;
import v0id.api.vsb.item.IUpgradeWrapper;
import v0id.vsb.item.upgrade.UpgradeFiltered;

public class UpgradeCompressor
extends UpgradeFiltered {
    private InventoryCrafting crafting_3x3;
    private InventoryCrafting crafting_2x2;

    public UpgradeCompressor() {
        super("upgrade_compressor");
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.addAll(Arrays.asList(I18n.func_135052_a((String)"vsb.txt.upgrade.compressor.desc", (Object[])new Object[0]).split("\\|")));
    }

    @Override
    public void onTick(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, Entity ticker) {
    }

    @Override
    public void onPulse(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, Entity pulsar) {
        int index;
        this.crafting_3x3 = new InventoryCrafting((Container)new ContainerWorkbench(((EntityPlayer)pulsar).field_71071_by, pulsar.field_70170_p, pulsar.func_180425_c()), 3, 3);
        this.crafting_2x2 = new InventoryCrafting((Container)new ContainerWorkbench(((EntityPlayer)pulsar).field_71071_by, pulsar.field_70170_p, pulsar.func_180425_c()), 3, 3);
        int n = index = self.getSelf().func_77942_o() ? self.getSelf().func_77978_p().func_74762_e("index") : 0;
        if (index >= backpack.getInventory().getSlots()) {
            index = 0;
        }
        if (!self.getSelf().func_77942_o()) {
            self.getSelf().func_77982_d(new NBTTagCompound());
        }
        ItemStack is = backpack.getInventory().getStackInSlot(index);
        boolean accepts = true;
        IFilter filter = IFilter.of(((IItemHandler)self.getSelf().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(0));
        if (filter != null) {
            accepts = filter.accepts(is);
        }
        if (accepts) {
            int amt;
            int n2 = amt = is.func_190916_E() >= 9 ? 9 : 4;
            if (amt == 9) {
                for (int i = 0; i < 9; ++i) {
                    this.crafting_3x3.func_70299_a(i, is.func_77946_l());
                }
                IRecipe recipe9x9 = CraftingManager.func_192413_b((InventoryCrafting)this.crafting_3x3, (World)pulsar.field_70170_p);
                if (recipe9x9 != null) {
                    this.compress(recipe9x9, backpack.getInventory(), is, 9);
                } else {
                    amt = 4;
                }
            }
            if (amt == 4) {
                for (int i = 0; i < 4; ++i) {
                    this.crafting_2x2.func_70299_a(i, is.func_77946_l());
                }
                IRecipe recipe2x2 = CraftingManager.func_192413_b((InventoryCrafting)this.crafting_2x2, (World)pulsar.field_70170_p);
                if (recipe2x2 != null) {
                    this.compress(recipe2x2, backpack.getInventory(), is, 4);
                }
            }
        }
        if (++index >= backpack.getReadonlyInventory().length) {
            index = 0;
        }
        self.getSelf().func_77978_p().func_74768_a("index", index);
    }

    private void compress(IRecipe recipe, IItemHandler to, ItemStack from, int amt) {
        int craftsNum = from.func_190916_E() / amt;
        ItemStack result = recipe.func_77572_b(amt == 4 ? this.crafting_2x2 : this.crafting_3x3).func_77946_l();
        result.func_190920_e(result.func_190916_E() * craftsNum);
        if (!result.func_190926_b() && ItemHandlerHelper.insertItemStacked((IItemHandler)to, (ItemStack)result, (boolean)true).func_190926_b()) {
            from.func_190920_e(from.func_190916_E() - craftsNum * amt);
            ItemHandlerHelper.insertItemStacked((IItemHandler)to, (ItemStack)result, (boolean)false);
        }
    }

    @Override
    public boolean onItemPickup(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, EntityItem item, Entity picker) {
        return false;
    }

    @Override
    public void onInstalled(IBackpackWrapper backpack, IUpgradeWrapper self) {
    }

    @Override
    public void onUninstalled(IBackpackWrapper backpack, IUpgradeWrapper self) {
    }

    @Override
    public boolean canInstall(IBackpackWrapper backpack, IUpgradeWrapper self) {
        return !Arrays.stream(backpack.getReadonlyUpdatesArray()).filter(Objects::nonNull).map(IUpgradeWrapper::getSelf).anyMatch(i -> i.func_77973_b() == self.getSelf().func_77973_b());
    }

    @Override
    public boolean hasSyncTag() {
        return false;
    }
}

