/*
 * Decompiled with CFR 0.152.
 */
package v0id.vsb.item;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.energy.CapabilityEnergy;
import org.apache.commons.lang3.ObjectUtils;
import v0id.api.vsb.capability.IBackpack;
import v0id.api.vsb.capability.VSBCaps;
import v0id.api.vsb.data.VSBCreativeTabs;
import v0id.api.vsb.data.VSBRegistryNames;
import v0id.api.vsb.item.EnumBackpackType;
import v0id.api.vsb.item.IGUIOpenable;
import v0id.api.vsb.item.IUpgradeWrapper;
import v0id.vsb.capability.Backpack;
import v0id.vsb.container.ContainerBackpack;
import v0id.vsb.item.upgrade.UpgradeEnderChest;
import v0id.vsb.net.VSBNet;
import v0id.vsb.util.EnumGuiType;
import v0id.vsb.util.VSBUtils;

public class ItemBackpack
extends Item
implements IGUIOpenable {
    public final EnumBackpackType backpackType;

    public ItemBackpack(EnumBackpackType type, String name) {
        this.backpackType = type;
        this.setRegistryName(VSBRegistryNames.asLocation(name));
        this.func_77655_b(this.getRegistryName().toString().replace(':', '.'));
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(VSBCreativeTabs.TAB_VSB);
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound tag = (NBTTagCompound)ObjectUtils.firstNonNull((Object[])new NBTTagCompound[]{super.getNBTShareTag(stack), new NBTTagCompound()});
        IBackpack cap = IBackpack.of(stack);
        tag.func_74782_a("backpack_tag", (NBTBase)cap.serializeSync());
        return tag;
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        super.readNBTShareTag(stack, nbt);
        if (nbt != null) {
            IBackpack cap = IBackpack.of(stack);
            cap.deserializeSync(nbt.func_74775_l("backpack_tag"));
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab != this.func_77640_w()) {
            return;
        }
        for (EnumDyeColor dyeColor : EnumDyeColor.values()) {
            ItemStack is = new ItemStack((Item)this, 1, 0);
            IBackpack.of(is).createWrapper().setColor(dyeColor.func_193350_e());
            items.add((Object)is);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (playerIn instanceof EntityPlayerMP) {
            ItemStack backpack = playerIn.func_184586_b(handIn);
            if (!playerIn.func_70093_af() && Arrays.stream(IBackpack.of(backpack).createWrapper().getReadonlyUpdatesArray()).anyMatch(u -> u != null && u.getUpgrade() instanceof UpgradeEnderChest)) {
                playerIn.func_71007_a((IInventory)playerIn.func_71005_bN());
            } else {
                int slot = handIn == EnumHand.MAIN_HAND ? playerIn.field_71071_by.field_70461_c : -1;
                VSBUtils.openContainer((EntityPlayerMP)playerIn, new ContainerBackpack.ContainerBackpackInventory(backpack, playerIn.field_71071_by, slot, handIn == EnumHand.MAIN_HAND ? playerIn.field_71071_by.field_70461_c : 40));
                VSBNet.sendOpenGUI(playerIn, handIn == EnumHand.MAIN_HAND ? playerIn.field_71071_by.field_70461_c : 40, true, slot, EnumGuiType.BACKPACK);
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack is = player.func_184586_b(EnumHand.MAIN_HAND);
        IBackpack backpack = IBackpack.of(is);
        if (backpack == null) {
            backpack = IBackpack.of(player.func_184586_b(EnumHand.OFF_HAND));
        }
        for (IUpgradeWrapper upgradeWrapper : backpack.createWrapper().getReadonlyUpdatesArray()) {
            EnumActionResult result;
            if (upgradeWrapper == null || (result = upgradeWrapper.getUpgrade().onBlockClick(null, backpack.createWrapper(), upgradeWrapper, player, pos, side, hitX, hitY, hitZ)) == null) continue;
            return result;
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("vsb:upgrade_damage_bar");
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("vsb:upgrade_damage_bar") ? (double)stack.func_77978_p().func_74760_g("vsb:upgrade_damage_bar") : super.getDurabilityForDisplay(stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K) {
            IBackpack.of(stack).onTick(null, entityIn);
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int maxEnergy;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        IBackpack backpack = IBackpack.of(stack);
        if (backpack != null && (maxEnergy = backpack.createWrapper().getMaxEnergy()) > 0) {
            tooltip.add(I18n.func_135052_a((String)"vsb.txt.backpack.desc.rf", (Object[])new Object[]{backpack.getEnergyStorage().getEnergyStored(), maxEnergy}));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ICapabilitySerializable<NBTTagCompound>(){
            private final Backpack cap;
            {
                this.cap = new Backpack(stack, ItemBackpack.this.backpackType);
            }

            public NBTTagCompound serializeNBT() {
                return this.cap.serializeNBT();
            }

            public void deserializeNBT(NBTTagCompound nbt) {
                this.cap.deserializeNBT(nbt);
            }

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == VSBCaps.BACKPACK_CAPABILITY || capability == CapabilityEnergy.ENERGY;
            }

            @Nullable
            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                return (T)(capability == VSBCaps.BACKPACK_CAPABILITY ? VSBCaps.BACKPACK_CAPABILITY.cast((Object)this.cap) : (capability == CapabilityEnergy.ENERGY ? CapabilityEnergy.ENERGY.cast((Object)this.cap.getEnergyStorage()) : null));
            }
        };
    }

    @Override
    public void openContainer(EntityPlayerMP player, ItemStack stack, int slot, int slotID) {
        if (!player.func_70093_af() && Arrays.stream(IBackpack.of(stack).createWrapper().getReadonlyUpdatesArray()).anyMatch(u -> u != null && u.getUpgrade() instanceof UpgradeEnderChest)) {
            player.func_71007_a((IInventory)player.func_71005_bN());
        } else {
            VSBUtils.openContainer(player, new ContainerBackpack.ContainerBackpackInventory(stack, player.field_71071_by, slot, slotID));
            VSBNet.sendOpenGUI((EntityPlayer)player, slotID, false, slot, EnumGuiType.BACKPACK_NESTED);
        }
    }
}

