/*
 * Decompiled with CFR 0.152.
 */
package v0id.vsb.container;

import invtweaks.api.container.ChestContainer;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.SlotItemHandler;
import v0id.api.vsb.capability.IBackpack;
import v0id.api.vsb.item.EnumBackpackType;
import v0id.api.vsb.item.IUpgrade;
import v0id.api.vsb.item.IUpgradeWrapper;
import v0id.vsb.config.VSBCfg;
import v0id.vsb.item.upgrade.UpgradeNesting;

public abstract class ContainerBackpack
extends Container {
    public final ItemStack backpack;
    public final int backpackSlot;
    public ContainerBackpack contextContainer;
    public Container parentContainer;
    public int backpackSlotID;

    public ContainerBackpack(ItemStack backpack, int backpackSlot, int backpackSlotID, Container parentContainer, ContainerBackpack contextContainer) {
        this.backpack = backpack;
        this.backpackSlot = backpackSlot;
        this.contextContainer = contextContainer;
        this.parentContainer = parentContainer;
        this.backpackSlotID = backpackSlotID;
    }

    public void func_75132_a(IContainerListener listener) {
        if (!this.field_75149_d.contains(listener)) {
            super.func_75132_a(listener);
        }
    }

    public void addPlayerInventory(InventoryPlayer playerInventory, int offsetX, int offsetY) {
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.func_75146_a(new Slot((IInventory)playerInventory, 9 + j1 + l * 9, offsetX + j1 * 18, offsetY + l * 18){

                    public boolean func_82869_a(EntityPlayer playerIn) {
                        return super.func_82869_a(playerIn) && this.getSlotIndex() != ContainerBackpack.this.backpackSlot;
                    }
                });
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.func_75146_a(new Slot((IInventory)playerInventory, i1, offsetX + i1 * 18, offsetY + 58){

                public boolean func_82869_a(EntityPlayer playerIn) {
                    return super.func_82869_a(playerIn) && this.getSlotIndex() != ContainerBackpack.this.backpackSlot;
                }
            });
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < this.field_75151_b.size() - 36 ? !this.func_75135_a(itemstack1, this.field_75151_b.size() - 36, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, this.field_75151_b.size() - 36, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)itemstack1, (ItemStack)itemstack)) {
                slot.func_190901_a(playerIn, itemstack);
            }
        }
        return itemstack;
    }

    public static class ContainerBackpackUpgrades
    extends ContainerBackpack {
        public ContainerBackpackUpgrades(ItemStack backpack, InventoryPlayer inventoryPlayer, int backpackSlot, ContainerBackpack context, int slotID) {
            super(backpack, backpackSlot, slotID, context != null ? context.parentContainer : inventoryPlayer.field_70458_d.field_71070_bA, context);
            int offsetX = 8;
            int offsetY = 0;
            IBackpack iBackpack = IBackpack.of(backpack);
            switch (iBackpack.createWrapper().getBackpackType()) {
                case BASIC: {
                    for (int i = 0; i < VSBCfg.basicBackpackUpgradesSize; ++i) {
                        this.func_75146_a((Slot)new SlotUpgrade(iBackpack.getUpgrades(), i, 44 + i * 18, 8));
                    }
                    offsetY = 32;
                    break;
                }
                case REINFORCED: {
                    for (int i = 0; i < VSBCfg.reinforcedBackpackUpgradesSize; ++i) {
                        this.func_75146_a((Slot)new SlotUpgrade(iBackpack.getUpgrades(), i, 8 + i * 18, 8));
                    }
                    offsetY = 32;
                    break;
                }
                case ADVANCED: {
                    int i;
                    for (i = 0; i < Math.min(9, VSBCfg.advancedBackpackUpgradesSize); ++i) {
                        this.func_75146_a((Slot)new SlotUpgrade(iBackpack.getUpgrades(), i, 8 + i * 18, 8));
                    }
                    for (i = 0; i < VSBCfg.advancedBackpackUpgradesSize - 9; ++i) {
                        this.func_75146_a((Slot)new SlotUpgrade(iBackpack.getUpgrades(), 9 + i, 44 + i * 18, 26));
                    }
                    offsetY = 50;
                    break;
                }
                case ULTIMATE: {
                    for (int i = 0; i < VSBCfg.ultimateBackpackUpgradesSize; ++i) {
                        this.func_75146_a((Slot)new SlotUpgrade(iBackpack.getUpgrades(), i, 8 + i % 9 * 18, 8 + i / 9 * 18));
                    }
                    offsetY = 50;
                }
            }
            this.addPlayerInventory(inventoryPlayer, offsetX, offsetY);
        }

        private class SlotUpgrade
        extends SlotItemHandler {
            public SlotUpgrade(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
                super(itemHandler, index, xPosition, yPosition);
            }

            public boolean func_75214_a(@Nonnull ItemStack stack) {
                return super.func_75214_a(stack) && stack.func_77973_b() instanceof IUpgrade && ((IUpgrade)stack.func_77973_b()).canInstall(IBackpack.of(ContainerBackpackUpgrades.this.backpack).createWrapper(), IBackpack.of(ContainerBackpackUpgrades.this.backpack).createUpgradeWrapper(stack));
            }

            public void func_75215_d(@Nonnull ItemStack stack) {
                ItemStack oldStack = this.func_75211_c();
                super.func_75215_d(stack);
                if (stack.func_77973_b() instanceof IUpgrade) {
                    ((IUpgrade)stack.func_77973_b()).onInstalled(IBackpack.of(ContainerBackpackUpgrades.this.backpack).createWrapper(), IBackpack.of(ContainerBackpackUpgrades.this.backpack).createUpgradeWrapper(stack));
                }
                if (oldStack.func_77973_b() instanceof IUpgrade) {
                    ((IUpgrade)oldStack.func_77973_b()).onUninstalled(IBackpack.of(ContainerBackpackUpgrades.this.backpack).createWrapper(), IBackpack.of(ContainerBackpackUpgrades.this.backpack).createUpgradeWrapper(oldStack));
                }
            }

            public ItemStack func_190901_a(EntityPlayer thePlayer, ItemStack stack) {
                ItemStack ret = super.func_190901_a(thePlayer, stack);
                if (stack.func_77973_b() instanceof IUpgrade) {
                    ((IUpgrade)stack.func_77973_b()).onUninstalled(IBackpack.of(ContainerBackpackUpgrades.this.backpack).createWrapper(), IBackpack.of(ContainerBackpackUpgrades.this.backpack).createUpgradeWrapper(stack));
                }
                return ret;
            }
        }
    }

    @ChestContainer
    public static class ContainerBackpackInventory
    extends ContainerBackpack {
        private final EnumBackpackType backpackType;

        public ContainerBackpackInventory(ItemStack backpack, InventoryPlayer inventoryPlayer, int slotIndex, int slotID) {
            super(backpack, slotIndex, slotID, inventoryPlayer.field_70458_d.field_71070_bA instanceof ContainerBackpackUpgrades ? ((ContainerBackpackUpgrades)inventoryPlayer.field_70458_d.field_71070_bA).parentContainer : inventoryPlayer.field_70458_d.field_71070_bA, null);
            this.contextContainer = new ContainerBackpackUpgrades(backpack, inventoryPlayer, slotIndex, this, slotID);
            int offsetX = 8;
            int offsetY = 0;
            int slotsPerRow = 9;
            int rows = 2;
            int maxSlots = 0;
            IBackpack iBackpack = IBackpack.of(backpack);
            this.backpackType = iBackpack.createWrapper().getBackpackType();
            switch (iBackpack.createWrapper().getBackpackType()) {
                case BASIC: {
                    offsetY = 50;
                    maxSlots = VSBCfg.basicBackpackInventorySize;
                    break;
                }
                case REINFORCED: {
                    rows = 4;
                    offsetY = 84;
                    maxSlots = VSBCfg.reinforcedBackpackInventorySize;
                    break;
                }
                case ADVANCED: {
                    rows = 6;
                    offsetY = 120;
                    maxSlots = VSBCfg.advancedBackpackInventorySize;
                    break;
                }
                case ULTIMATE: {
                    slotsPerRow = 13;
                    rows = 9;
                    offsetX = 44;
                    offsetY = 174;
                    maxSlots = VSBCfg.ultimateBackpackInventorySize;
                }
            }
            for (int y = 0; y < rows; ++y) {
                for (int x = 0; x < slotsPerRow; ++x) {
                    if (x + y * slotsPerRow > maxSlots) continue;
                    this.func_75146_a((Slot)new SlotItemHandlerBackpack(iBackpack.getInventory(), x + y * slotsPerRow, 8 + x * 18, 8 + y * 18));
                }
            }
            this.addPlayerInventory(inventoryPlayer, offsetX, offsetY);
        }

        @ChestContainer.RowSizeCallback
        public int rowSizeCallback() {
            return this.backpackType == EnumBackpackType.ULTIMATE ? 13 : 9;
        }

        @ChestContainer.IsLargeCallback
        public boolean isLargeCallback() {
            return this.backpackType.ordinal() > 1;
        }

        private class SlotItemHandlerBackpack
        extends SlotItemHandler {
            public SlotItemHandlerBackpack(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
                super(itemHandler, index, xPosition, yPosition);
            }

            public boolean func_75214_a(@Nonnull ItemStack stack) {
                IBackpack backpack_test = IBackpack.of(stack);
                if (backpack_test != null) {
                    IBackpack backpack = IBackpack.of(ContainerBackpackInventory.this.backpack);
                    boolean allowNesting = false;
                    for (IUpgradeWrapper upgradeWrapper : backpack.createWrapper().getReadonlyUpdatesArray()) {
                        if (upgradeWrapper == null || !(upgradeWrapper.getSelf().func_77973_b() instanceof UpgradeNesting)) continue;
                        allowNesting = true;
                        break;
                    }
                    if (allowNesting && backpack_test.createWrapper().getBackpackType().ordinal() < backpack.createWrapper().getBackpackType().ordinal()) {
                        return super.func_75214_a(stack);
                    }
                    return false;
                }
                return super.func_75214_a(stack);
            }
        }
    }
}

