/*
 * Decompiled with CFR 0.152.
 */
package v0id.vsb.client.gui;

import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import v0id.api.vsb.capability.IFilter;
import v0id.api.vsb.data.VSBTextures;
import v0id.vsb.capability.FilterRegex;
import v0id.vsb.config.VSBCfg;
import v0id.vsb.container.ContainerFilterRegex;
import v0id.vsb.net.VSBNet;
import v0id.vsb.util.VSBUtils;

public class GuiFilterRegex
extends GuiContainer {
    private final ItemStack filter;
    private GuiTextField input;
    private String lastException;
    private boolean regexCorrect = true;

    public GuiFilterRegex(ItemStack filter, int slotIndex) {
        super((Container)new ContainerFilterRegex(Minecraft.func_71410_x().field_71439_g.field_71071_by, filter, slotIndex));
        this.filter = filter;
        this.field_146999_f = 176;
        this.field_147000_g = 140;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_189646_b(new FilterButton(0, i + 21, j + 30, 20, 20, ""));
        this.func_189646_b(new FilterButton(3, i + 135, j + 30, 20, 20, ""));
        this.input = new GuiTextField(4, Minecraft.func_71410_x().field_71466_p, i + 10, j + 8, 136, 20);
        FilterRegex filter = (FilterRegex)IFilter.of(this.filter);
        if (filter != null) {
            this.compilePattern(filter.getPattern());
            this.input.func_146180_a(filter.getPattern());
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        IFilter filter = IFilter.of(this.filter);
        switch (button.field_146127_k) {
            case 0: {
                filter.setOreDictionary(!filter.isOreDictionary());
                break;
            }
            case 3: {
                filter.setWhitelist(!filter.isWhitelist());
            }
        }
        if (button.field_146127_k < 4) {
            VSBNet.sendChangeFilterParam(button.field_146127_k);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.input.func_146192_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        }
        String current = this.input.func_146179_b();
        this.input.func_146201_a(typedChar, keyCode);
        if (!VSBUtils.areStringsEqual(current, this.input.func_146179_b())) {
            this.compilePattern(this.input.func_146179_b());
            FilterRegex filter = (FilterRegex)IFilter.of(this.filter);
            if (filter != null) {
                filter.setPattern(this.input.func_146179_b());
            }
            VSBNet.sendChangeFilterPattern(this.input.func_146179_b());
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(VSBCfg.useLightUI ? VSBTextures.FILTER_REGEX_LIGHT : VSBTextures.FILTER_REGEX);
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73729_b(i + 149, j + 9, 176, this.regexCorrect ? 0 : 18, 18, 18);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.input.func_146194_f();
        this.func_191948_b(mouseX, mouseY);
        for (GuiButton btn : this.field_146292_n) {
            if (!btn.func_146115_a()) continue;
            String postfix = "";
            switch (btn.field_146127_k) {
                case 0: {
                    postfix = Boolean.toString(IFilter.of(this.filter).isOreDictionary());
                    break;
                }
                case 3: {
                    postfix = Boolean.toString(IFilter.of(this.filter).isWhitelist());
                }
            }
            this.func_146279_a(I18n.func_135052_a((String)("vsb.filter.state." + btn.field_146127_k + "." + postfix), (Object[])new Object[0]), mouseX, mouseY);
        }
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        if (mouseX >= i + 149 && mouseX <= i + 167 && mouseY >= j + 9 && mouseY <= j + 27) {
            this.func_146279_a(this.regexCorrect ? I18n.func_135052_a((String)"vsb.filter.regex.ok", (Object[])new Object[0]) : this.lastException, mouseX, mouseY);
        }
    }

    private void compilePattern(String s) {
        try {
            Pattern.compile(s);
            this.regexCorrect = true;
        }
        catch (PatternSyntaxException ex) {
            this.regexCorrect = false;
            this.lastException = ex.getMessage();
        }
    }

    private class FilterButton
    extends GuiButton {
        public FilterButton(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText) {
            super(buttonId, x, y, widthIn, heightIn, buttonText);
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                mc.func_110434_K().func_110577_a(VSBTextures.WIDGETS);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                int i = this.func_146114_a(this.field_146123_n);
                int offsetX = i == 0 ? 60 : (i == 2 ? 40 : 20);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 0, 20, 20);
                int iconY = 20;
                switch (this.field_146127_k) {
                    case 0: {
                        iconY = IFilter.of(GuiFilterRegex.this.filter).isOreDictionary() ? 20 : 40;
                        break;
                    }
                    case 3: {
                        int n = iconY = IFilter.of(GuiFilterRegex.this.filter).isWhitelist() ? 20 : 40;
                    }
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, this.field_146127_k == 0 ? 0 : (this.field_146127_k == 1 ? 40 : (this.field_146127_k == 2 ? 20 : (this.field_146127_k == 3 ? 60 : 0))), iconY, 20, 20);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, offsetX, 0, 20, 20);
                this.func_146119_b(mc, mouseX, mouseY);
            }
        }
    }
}

