/*
 * Decompiled with CFR 0.152.
 */
package v0id.vsb.client.gui;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import v0id.api.vsb.capability.IBackpack;
import v0id.api.vsb.data.VSBItems;
import v0id.api.vsb.data.VSBTextures;
import v0id.api.vsb.item.IGUIOpenable;
import v0id.vsb.config.VSBCfg;
import v0id.vsb.container.ContainerBackpack;
import v0id.vsb.item.upgrade.UpgradeExperience;
import v0id.vsb.net.VSBNet;
import v0id.vsb.util.Lazy;
import v0id.vsb.util.VSBUtils;

public class GuiBackpack
extends GuiContainer {
    public static final Lazy<ItemStack> BACKPACK_ICON_PROVIDER = new Lazy<ItemStack>(() -> {
        ItemStack ret = new ItemStack(VSBItems.BASIC_BACKPACK);
        IBackpack iBackpack = IBackpack.of(ret);
        iBackpack.createWrapper().setColor(6498816);
        return ret;
    });
    public static final Lazy<ItemStack> UPGRADE_ICON_PROVIDER = new Lazy<ItemStack>(() -> new ItemStack(VSBItems.UPGRADE_BASE));
    public final ItemStack backpack;
    public final boolean hasExperienceUpgrade;
    public int experienceLVL;

    public GuiBackpack(Container inventorySlotsIn, ItemStack backpack) {
        super(inventorySlotsIn);
        this.backpack = backpack;
        IBackpack iBackpack = IBackpack.of(this.backpack);
        this.hasExperienceUpgrade = Arrays.stream(iBackpack.createWrapper().getReadonlyUpdatesArray()).anyMatch(u -> !Objects.isNull(u) && u.getUpgrade() instanceof UpgradeExperience);
        this.experienceLVL = this.hasExperienceUpgrade ? Arrays.stream(iBackpack.createWrapper().getReadonlyUpdatesArray()).filter(u -> !Objects.isNull(u) && u.getUpgrade() instanceof UpgradeExperience).mapToInt(u -> u.getSelf().func_77942_o() ? u.getSelf().func_77978_p().func_74762_e("experience") : 0).max().orElse(0) : -1;
        this.field_146999_f = 176;
        if (inventorySlotsIn instanceof ContainerBackpack.ContainerBackpackInventory) {
            switch (iBackpack.createWrapper().getBackpackType()) {
                case BASIC: {
                    this.field_147000_g = 132;
                    break;
                }
                case REINFORCED: {
                    this.field_147000_g = 166;
                    break;
                }
                case ADVANCED: {
                    this.field_147000_g = 202;
                    break;
                }
                case ULTIMATE: {
                    this.field_146999_f = 248;
                    this.field_147000_g = 256;
                }
            }
        } else {
            switch (iBackpack.createWrapper().getBackpackType()) {
                case BASIC: 
                case REINFORCED: {
                    this.field_147000_g = 144;
                    break;
                }
                case ADVANCED: 
                case ULTIMATE: {
                    this.field_147000_g = 132;
                }
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        if (((ContainerBackpack)this.field_147002_h).backpackSlot != -2) {
            this.func_189646_b(new BackpackButton(0, i - 20, j + 12, 20, 20, ""));
            this.func_189646_b(new BackpackButton(1, i - 20, j + 32, 20, 20, ""));
            if (this.field_147002_h instanceof ContainerBackpack.ContainerBackpackInventory) {
                ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = false;
            } else {
                ((GuiButton)this.field_146292_n.get((int)1)).field_146124_l = false;
            }
        }
        if (this.hasExperienceUpgrade) {
            for (int k = 0; k < 6; ++k) {
                this.func_189646_b(new WidgetButton(2 + k, i + this.field_146999_f + k % 3 * 20, j + (k >= 3 ? 34 : 0), k % 3 * 20, 60 + k / 3 * 20));
            }
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (((ContainerBackpack)this.field_147002_h).backpackSlot != -2) {
            if (button.field_146127_k == 0 || button.field_146127_k == 1) {
                VSBNet.requestContextContainerSwitch();
            }
            if (button.field_146127_k >= 2 && button.field_146127_k < 8) {
                VSBNet.sendPressExperienceButton(button.field_146127_k - 2);
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        ItemStack is;
        Slot s;
        if (mouseButton == 1 && (s = this.getSlotUnderMouse()) != null && !(is = s.func_75211_c()).func_190926_b() && is.func_77973_b() instanceof IGUIOpenable) {
            VSBNet.sendOpenContainer(s.getSlotIndex(), s.field_75222_d);
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        ResourceLocation backgroundTexture = null;
        IBackpack iBackpack = IBackpack.of(this.backpack);
        if (this.field_147002_h instanceof ContainerBackpack.ContainerBackpackInventory) {
            switch (iBackpack.createWrapper().getBackpackType()) {
                case BASIC: {
                    backgroundTexture = VSBCfg.useLightUI ? VSBTextures.BACKPACK_BASIC_LIGHT : VSBTextures.BACKPACK_BASIC;
                    break;
                }
                case REINFORCED: {
                    backgroundTexture = VSBCfg.useLightUI ? VSBTextures.BACKPACK_REINFORCED_LIGHT : VSBTextures.BACKPACK_REINFORCED;
                    break;
                }
                case ADVANCED: {
                    backgroundTexture = VSBCfg.useLightUI ? VSBTextures.BACKPACK_ADVANCED_LIGHT : VSBTextures.BACKPACK_ADVANCED;
                    break;
                }
                case ULTIMATE: {
                    backgroundTexture = VSBCfg.useLightUI ? VSBTextures.BACKPACK_ULTIMATE_LIGHT : VSBTextures.BACKPACK_ULTIMATE;
                }
            }
        } else {
            switch (iBackpack.createWrapper().getBackpackType()) {
                case BASIC: {
                    backgroundTexture = VSBCfg.useLightUI ? VSBTextures.BACKPACK_BASIC_UPGRADES_LIGHT : VSBTextures.BACKPACK_BASIC_UPGRADES;
                    break;
                }
                case REINFORCED: {
                    backgroundTexture = VSBCfg.useLightUI ? VSBTextures.BACKPACK_REINFORCED_UPGRADES_LIGHT : VSBTextures.BACKPACK_REINFORCED_UPGRADES;
                    break;
                }
                case ADVANCED: {
                    backgroundTexture = VSBCfg.useLightUI ? VSBTextures.BACKPACK_ADVANCED_UPGRADES_LIGHT : VSBTextures.BACKPACK_ADVANCED_UPGRADES;
                    break;
                }
                case ULTIMATE: {
                    backgroundTexture = VSBCfg.useLightUI ? VSBTextures.BACKPACK_ULTIMATE_UPGRADES_LIGHT : VSBTextures.BACKPACK_ULTIMATE_UPGRADES;
                }
            }
        }
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(backgroundTexture);
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.hasExperienceUpgrade) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("minecraft", "textures/gui/icons.png"));
            BufferBuilder bb = Tessellator.func_178181_a().func_178180_c();
            bb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bb.func_181662_b((double)(i + this.field_146999_f), (double)(j + 24), 0.0).func_187315_a(0.0, 0.25).func_181675_d();
            bb.func_181662_b((double)(i + this.field_146999_f), (double)(j + 29), 0.0).func_187315_a(0.0, 0.26953125).func_181675_d();
            bb.func_181662_b((double)(i + this.field_146999_f + 60), (double)(j + 29), 0.0).func_187315_a(0.7109375, 0.26953125).func_181675_d();
            bb.func_181662_b((double)(i + this.field_146999_f + 60), (double)(j + 24), 0.0).func_187315_a(0.7109375, 0.25).func_181675_d();
            int lvl = VSBUtils.getLevelForExperience(this.experienceLVL);
            int expLeft = this.experienceLVL - VSBUtils.getExperienceForLevel(lvl);
            int expNeeded = VSBUtils.getExperienceForLevel(lvl + 1) - VSBUtils.getExperienceForLevel(lvl);
            float expVal = (float)expLeft / (float)expNeeded;
            bb.func_181662_b((double)(i + this.field_146999_f), (double)(j + 24), 1.0).func_187315_a(0.0, 0.26953125).func_181675_d();
            bb.func_181662_b((double)(i + this.field_146999_f), (double)(j + 29), 1.0).func_187315_a(0.0, 0.2890625).func_181675_d();
            bb.func_181662_b((double)((float)(i + this.field_146999_f) + 60.0f * expVal), (double)(j + 29), 1.0).func_187315_a(0.7109375 * (double)expVal, 0.2890625).func_181675_d();
            bb.func_181662_b((double)((float)(i + this.field_146999_f) + 60.0f * expVal), (double)(j + 24), 1.0).func_187315_a(0.7109375 * (double)expVal, 0.26953125).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)2.0f);
            this.func_73732_a(Minecraft.func_71410_x().field_71466_p, Integer.toString(lvl), i + this.field_146999_f + 30, j + 22, 65280);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2.0f);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        for (GuiButton guiButton : this.field_146292_n) {
            if (guiButton.field_146127_k <= 1 || !guiButton.func_146115_a()) continue;
            this.func_146279_a(I18n.func_135052_a((String)("vsb.txt.gui.backpack_button." + guiButton.field_146127_k), (Object[])new Object[0]), mouseX, mouseY);
        }
    }

    private class BackpackButton
    extends GuiButton {
        public BackpackButton(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText) {
            super(buttonId, x, y, widthIn, heightIn, buttonText);
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                mc.func_110434_K().func_110577_a(VSBCfg.useLightUI ? VSBTextures.WIDGETS_LIGHT : VSBTextures.WIDGETS);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                int i = this.func_146114_a(this.field_146123_n);
                int offsetX = i == 0 ? 80 : (i == 2 ? 40 : 20);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 0, 20, 20);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, offsetX, 0, 20, 20);
                if (this.field_146127_k == 0) {
                    Minecraft.func_71410_x().func_175599_af().func_180450_b(BACKPACK_ICON_PROVIDER.get(), this.field_146128_h + 2, this.field_146129_i + 2);
                } else {
                    Minecraft.func_71410_x().func_175599_af().func_180450_b(UPGRADE_ICON_PROVIDER.get(), this.field_146128_h + 2, this.field_146129_i + 2);
                }
                this.func_146119_b(mc, mouseX, mouseY);
            }
        }
    }

    private class WidgetButton
    extends GuiButton {
        private final int textureX;
        private final int textureY;

        public WidgetButton(int buttonId, int x, int y, int textureX, int textureY) {
            super(buttonId, x, y, 20, 20, "");
            this.textureX = textureX;
            this.textureY = textureY;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                mc.func_110434_K().func_110577_a(VSBCfg.useLightUI ? VSBTextures.WIDGETS_LIGHT : VSBTextures.WIDGETS);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                int i = this.func_146114_a(this.field_146123_n);
                int offsetX = i == 0 ? 80 : (i == 2 ? 40 : 20);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 0, 20, 20);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, offsetX, 0, 20, 20);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, this.textureX, this.textureY, 20, 20);
                this.func_146119_b(mc, mouseX, mouseY);
            }
        }
    }
}

