/*
 * Decompiled with CFR 0.152.
 */
package valoeghese.valoeghesesbe.world.trees;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import valoeghese.valoeghesesbe.init.ModBlocks;

public class WorldGenOceanPalm
extends WorldGenAbstractTree {
    public final IBlockState TRUNK = ModBlocks.WOOD_LOOKUP.get("LOG_PALM_DARK").func_176223_P();
    public static final IBlockState LEAF = ModBlocks.LEAVES_OCEAN_PALM.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true));
    private final int minheight;

    public WorldGenOceanPalm() {
        this(false, 6);
    }

    public WorldGenOceanPalm(boolean notify, int minHeight) {
        super(notify);
        this.minheight = minHeight;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
        boolean isSoil;
        int height = this.minheight + rand.nextInt(5);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        boolean flag = true;
        for (int yPos = 0; yPos <= height + 2; ++yPos) {
            if (yPos >= 0 && yPos < worldIn.func_72800_K()) {
                BlockPos pos21 = pos.func_177981_b(yPos);
                if (this.isReplaceable(worldIn, pos21)) continue;
                flag = false;
                continue;
            }
            flag = false;
        }
        if (!flag) {
            return false;
        }
        BlockPos down = pos.func_177977_b();
        IBlockState state = worldIn.func_180495_p(down);
        boolean bl = isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)ModBlocks.SAPLING_PALM) || state.func_177230_c() == Blocks.field_150354_m;
        if (isSoil && y < worldIn.func_72800_K() - height - 1) {
            state.func_177230_c().onPlantGrow(state, worldIn, down, pos);
            this.generateLeaves(worldIn, pos.func_177981_b(height));
            for (int lHeight = 0; lHeight < height; ++lHeight) {
                this.func_175903_a(worldIn, pos.func_177981_b(lHeight), this.TRUNK);
            }
            return true;
        }
        return false;
    }

    private void generateLeaves(World worldIn, BlockPos pos) {
        this.setLeafSpread(worldIn, pos.func_177979_c(2), 2);
        this.setLeafSpread(worldIn, pos.func_177977_b(), 1);
        this.setLeafPoints(worldIn, pos.func_177977_b(), 1);
        this.setLeafPoints(worldIn, pos.func_177977_b(), 2);
        this.setLeafPoints(worldIn, pos, 1);
        this.func_175903_a(worldIn, pos.func_177984_a(), LEAF);
        this.setLeafPoints(worldIn, pos.func_177984_a(), 1);
        this.setLeafSpread(worldIn, pos.func_177984_a(), 1);
        this.setLeafPoints(worldIn, pos.func_177981_b(2), 1);
        this.setLeafPoints(worldIn, pos.func_177981_b(2), 2);
    }

    private void setLeaves(World worldIn, BlockPos pos) {
        if (this.func_150523_a(worldIn.func_180495_p(pos).func_177230_c())) {
            this.func_175903_a(worldIn, pos, LEAF);
        }
    }

    private void setLeafPoints(World worldIn, BlockPos pos, int range) {
        this.setLeaves(worldIn, pos.func_177982_a(range, 0, 0));
        this.setLeaves(worldIn, pos.func_177982_a(-range, 0, 0));
        this.setLeaves(worldIn, pos.func_177982_a(0, 0, range));
        this.setLeaves(worldIn, pos.func_177982_a(0, 0, -range));
    }

    private void setLeafSpread(World worldIn, BlockPos pos, int range) {
        this.setLeaves(worldIn, pos.func_177982_a(range, 0, range));
        this.setLeaves(worldIn, pos.func_177982_a(-range, 0, range));
        this.setLeaves(worldIn, pos.func_177982_a(range, 0, -range));
        this.setLeaves(worldIn, pos.func_177982_a(-range, 0, -range));
    }
}

