/*
 * Decompiled with CFR 0.152.
 */
package valoeghese.valoeghesesbe.world.trees;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import valoeghese.valoeghesesbe.world.trees.enumTypes.EnumDirection;

public class WorldGenLargeTree
extends WorldGenAbstractTree {
    private static final IBlockState TRUNK = Blocks.field_150364_r.func_176223_P();
    private static final IBlockState LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    private static final int minBasicHeight = 4;

    public WorldGenLargeTree() {
        super(false);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
        int theight = rand.nextInt(4) + 4 + 1;
        int trunk = 3 + rand.nextInt(2);
        int height = theight + trunk;
        boolean flag = true;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (y >= 1 && y + height + 2 <= worldIn.func_72800_K()) {
            for (int j = y; j < y + 2 + height; ++j) {
                int k = 1;
                if (j == y) {
                    k = 0;
                }
                if (j >= y + 2 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos b1 = new BlockPos.MutableBlockPos();
                for (int l = x - k; l <= x + k && flag; ++l) {
                    for (int i1 = z - k; i1 <= z + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_72800_K()) {
                            if (this.isReplaceable(worldIn, (BlockPos)b1.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
            if (state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g)) && y < worldIn.func_72800_K() - height - 1) {
                int lHeight;
                for (lHeight = 0; lHeight <= height; ++lHeight) {
                    if (lHeight > trunk && lHeight < height - 1) {
                        if (rand.nextInt(2) > 0) {
                            this.generateBranch(worldIn, pos.func_177981_b(lHeight), rand);
                        }
                        if (rand.nextInt(3) != 0) continue;
                        this.generateBranch(worldIn, pos.func_177981_b(lHeight), rand);
                        continue;
                    }
                    if (lHeight != height) continue;
                    this.generateLeafNode(worldIn, pos.func_177981_b(lHeight), rand);
                }
                for (lHeight = 0; lHeight <= height; ++lHeight) {
                    this.func_175903_a(worldIn, pos.func_177981_b(lHeight), TRUNK);
                }
            }
            return true;
        }
        return true;
    }

    private void generateBranch(World worldIn, BlockPos origin, Random rand) {
        EnumDirection d1 = EnumDirection.getRandomEnumDirectional(rand);
        EnumDirection d2 = d1.getRandomOppAxisEnum(rand);
        EnumDirection d3 = EnumDirection.getRandomEnumVertical(rand);
        int d4 = 2 + rand.nextInt(2);
        int branchLength = 2 + rand.nextInt(3);
        for (int distance = 1; distance <= branchLength; ++distance) {
            int xOffset = d1.getXOffset() + Math.floorDiv(d2.getXOffset(), 2);
            int zOffset = d1.getZOffset() + Math.floorDiv(d2.getZOffset(), 2);
            int yOffset = Math.floorDiv(d3.getYOffset(), d4);
            this.func_175903_a(worldIn, origin.func_177982_a(xOffset * distance, yOffset * distance, zOffset * distance), TRUNK.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)d1.getLogAxisOf()));
        }
        int xOffset = d1.getXOffset() + Math.floorDiv(d2.getXOffset(), 2);
        int zOffset = d1.getZOffset() + Math.floorDiv(d2.getZOffset(), 2);
        int yOffset = Math.floorDiv(d3.getYOffset(), d4);
        this.generateLeafNode(worldIn, origin.func_177982_a(xOffset * branchLength, yOffset * branchLength, zOffset * branchLength), rand);
    }

    private void generateLeafNode(World worldIn, BlockPos pos, Random rand) {
        this.func_175903_a(worldIn, pos.func_177984_a(), LEAF);
        this.func_175903_a(worldIn, pos.func_177982_a(-1, 1, 0), LEAF);
        this.func_175903_a(worldIn, pos.func_177982_a(1, 1, 0), LEAF);
        this.func_175903_a(worldIn, pos.func_177982_a(0, 1, -1), LEAF);
        this.func_175903_a(worldIn, pos.func_177982_a(0, 1, 1), LEAF);
        for (int y = 0; y > -2; --y) {
            for (int x = -2; x < 3; ++x) {
                for (int z = -1; z < 2; ++z) {
                    if (x == 0 && z == 0) continue;
                    this.func_175903_a(worldIn, pos.func_177982_a(x, y, z), LEAF);
                }
                if (Math.abs(x) >= 2) continue;
                this.func_175903_a(worldIn, pos.func_177982_a(x, y, -2), LEAF);
                this.func_175903_a(worldIn, pos.func_177982_a(x, y, 2), LEAF);
            }
        }
    }
}

