/*
 * Decompiled with CFR 0.152.
 */
package valoeghese.valoeghesesbe.world.biomes.alpha3.macro;

import java.util.Random;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import valoeghese.valoeghesesbe.util.OpenSimplexNoise;

public class BiomeGrasslands
extends Biome {
    private final Variant type;
    protected static final WorldGenBlockBlob MOORLANDS_ROCK = new WorldGenBlockBlob(Blocks.field_150348_b, 1);

    public BiomeGrasslands(Biome.BiomeProperties properties, Variant plainsType) {
        super(properties);
        this.field_76752_A = Blocks.field_150349_c.func_176223_P();
        this.field_76753_B = Blocks.field_150346_d.func_176223_P();
        this.field_76760_I.field_76808_K = true;
        this.type = plainsType;
        this.field_76760_I.field_76832_z = this.type == Variant.CHAPPARAL ? 5 : 0;
        if (this.type == Variant.MOORLANDS) {
            this.field_76760_I.field_76802_A = 9;
            this.field_76760_I.field_76803_B = 30;
            this.field_76760_I.field_76799_E = 0;
            this.field_76760_I.field_189870_A = 0.001f;
            this.field_76760_I.field_76833_y = 1;
        } else {
            if (this.type == Variant.HIGHLANDS) {
                this.field_76762_K.add(new Biome.SpawnListEntry(EntityHorse.class, 9, 2, 3));
                this.field_76762_K.add(new Biome.SpawnListEntry(EntityDonkey.class, 2, 1, 1));
                this.field_76760_I.field_76803_B = 10;
                this.field_76760_I.field_76802_A = 0;
            } else if (this.type == Variant.CHAPPARAL) {
                this.field_76760_I.field_76802_A = 6;
                this.field_76760_I.field_76803_B = 8;
            } else {
                this.field_76760_I.field_76802_A = 2;
                this.field_76760_I.field_76803_B = 2;
            }
            this.field_76760_I.field_76799_E = 1;
            this.field_76760_I.field_189870_A = 0.0f;
        }
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer primerIn, int x, int z, double noiseVal) {
        if (!this.type.isLowland()) {
            // empty if block
        }
        super.func_180628_b(worldIn, rand, primerIn, x, z, noiseVal);
    }

    public void generateNewHighlandTerrain(World worldIn, Random rand, ChunkPrimer primerIn, int x, int z, double noiseVal) {
        OpenSimplexNoise noise = new OpenSimplexNoise(worldIn.func_72905_C());
        double scaleFactor = 20.0;
        int x1 = x & 0xF;
        int z1 = z & 0xF;
        double height = BiomeGrasslands.getPrimerHeight(primerIn, x1, z1);
        double x2 = x;
        double z2 = z;
        if (BiomeGrasslands.getPrimerHeight(primerIn, x1, z1) > 100) {
            height = 0.25 * (2.0 * height + (100.0 + 10.0 * noise.eval(x2 / 20.0, z2 / 20.0)));
        }
        for (int y = 255; y >= 0; --y) {
            if (rand.nextInt(5) >= y) {
                primerIn.func_177855_a(x1, y, z1, field_185367_c);
                continue;
            }
            if ((double)y > height) {
                primerIn.func_177855_a(x1, y, z1, field_185366_b);
                continue;
            }
            if ((double)y == height) {
                primerIn.func_177855_a(x1, y, z1, this.field_76752_A);
                continue;
            }
            if ((double)y > height - 5.0) {
                primerIn.func_177855_a(x1, y, z1, this.field_76753_B);
                continue;
            }
            primerIn.func_177855_a(x1, y, z1, rand.nextInt(500) == 0 ? field_185372_h : field_185365_a);
        }
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        int l1;
        int k1;
        int j1;
        int i1;
        if (this.type == Variant.MOORLANDS && TerrainGen.decorate((World)worldIn, (Random)rand, (ChunkPos)new ChunkPos(pos), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.ROCK)) {
            int i = rand.nextInt(3);
            for (int j = 0; j < i; ++j) {
                int k = rand.nextInt(16) + 8;
                int l = rand.nextInt(16) + 8;
                BlockPos blockpos = this.relativeHeight(worldIn, pos, -2);
                MOORLANDS_ROCK.func_180709_b(worldIn, rand, blockpos.func_177982_a(k, 0, l));
            }
        }
        if (!this.type.isLowland()) {
            field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.GRASS);
            if (TerrainGen.decorate((World)worldIn, (Random)rand, (ChunkPos)new ChunkPos(pos), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS) && rand.nextInt(3) == 0) {
                for (i1 = 0; i1 < 7; ++i1) {
                    j1 = rand.nextInt(16) + 8;
                    k1 = rand.nextInt(16) + 8;
                    l1 = rand.nextInt(worldIn.func_175645_m(pos.func_177982_a(j1, 0, k1)).func_177956_o() + 32);
                    field_180280_ag.func_180709_b(worldIn, rand, pos.func_177982_a(j1, l1, k1));
                }
            }
        }
        if (this.type == Variant.CHAPPARAL) {
            field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.ROSE);
            if (rand.nextBoolean()) {
                field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.SYRINGA);
            }
            if (TerrainGen.decorate((World)worldIn, (Random)rand, (ChunkPos)new ChunkPos(pos), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS) && rand.nextInt(3) == 0) {
                for (i1 = 0; i1 < 7; ++i1) {
                    j1 = rand.nextInt(16) + 8;
                    k1 = rand.nextInt(16) + 8;
                    l1 = rand.nextInt(worldIn.func_175645_m(pos.func_177982_a(j1, 0, k1)).func_177956_o() + 32);
                    field_180280_ag.func_180709_b(worldIn, rand, pos.func_177982_a(j1, l1, k1));
                }
            }
        }
        super.func_180624_a(worldIn, rand, pos);
    }

    public void addDefaultFlowers() {
        BlockFlower red = Blocks.field_150328_O;
        BlockFlower yel = Blocks.field_150327_N;
        if (this.type == Variant.MOORLANDS) {
            this.addFlower(red.func_176223_P().func_177226_a(red.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.ORANGE_TULIP), 3);
            this.addFlower(red.func_176223_P().func_177226_a(red.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.RED_TULIP), 3);
            this.addFlower(red.func_176223_P().func_177226_a(red.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.PINK_TULIP), 3);
            this.addFlower(red.func_176223_P().func_177226_a(red.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.WHITE_TULIP), 3);
            this.addFlower(red.func_176223_P().func_177226_a(red.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.BLUE_ORCHID), 10);
            this.addFlower(red.func_176223_P().func_177226_a(red.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.HOUSTONIA), 20);
        } else {
            this.addFlower(yel.func_176223_P().func_177226_a(yel.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.DANDELION), 30);
            this.addFlower(red.func_176223_P().func_177226_a(red.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.POPPY), 20);
            this.addFlower(red.func_176223_P().func_177226_a(red.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.HOUSTONIA), 20);
            this.addFlower(red.func_176223_P().func_177226_a(red.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.OXEYE_DAISY), 20);
        }
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        if (this.type == Variant.MOORLANDS || this.type == Variant.CHAPPARAL) {
            return new WorldGenShrub(Blocks.field_150364_r.func_176223_P(), Blocks.field_150362_t.func_176223_P());
        }
        return new WorldGenShrub(Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P());
    }

    private BlockPos relativeHeight(World world, BlockPos loc, int shift) {
        return new BlockPos(loc.func_177958_n(), world.func_189649_b(loc.func_177958_n(), loc.func_177952_p()) + shift, loc.func_177952_p());
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos pos) {
        if (this.type == Variant.MOORLANDS || this.type == Variant.CHAPPARAL) {
            return super.func_180625_c(pos);
        }
        return 6351458;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        if (this.type == Variant.MOORLANDS || this.type == Variant.CHAPPARAL) {
            return super.func_180627_b(pos);
        }
        return 7529844;
    }

    public static int getPrimerHeight(ChunkPrimer pIn, int xA15, int zA15) {
        for (int j2 = 255; j2 >= 0; --j2) {
            if (pIn.func_177856_a(xA15, j2, zA15) == Blocks.field_150350_a) continue;
            return j2;
        }
        return -1;
    }

    @Deprecated
    private static int sigmoidedHeight(double distanceToLowChunk, double bound1, double bound2) {
        double b;
        double a;
        if (bound1 > bound2) {
            a = bound2;
            b = bound1;
        } else {
            a = bound1;
            b = bound2;
        }
        return (int)(a + OpenSimplexNoise.SigmoidFunctions.sigmoidScale(distanceToLowChunk, 16.0, 10.0) * (b - a));
    }

    @Deprecated
    private static int lowChunk(double value) {
        return (int)(16.0 * Math.floor(value / 16.0));
    }

    @Deprecated
    private static int highChunk(double value) {
        return (int)(16.0 * Math.ceil(value / 16.0));
    }

    public static enum Variant {
        LOWLANDS,
        MOORLANDS,
        CHAPPARAL,
        HIGHLANDS;


        public boolean isLowland() {
            return this.equals((Object)LOWLANDS) || this.equals((Object)CHAPPARAL);
        }
    }
}

