/*
 * Decompiled with CFR 0.152.
 */
package valoeghese.valoeghesesbe.world.biomes;

import java.util.Random;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import valoeghese.valoeghesesbe.world.worldtype.ILakeRemover;

public class BiomeAlpsNorthern
extends Biome
implements ILakeRemover {
    private boolean alpsTrees;
    protected static final WorldGenAbstractTree SPRUCE_GENERATOR = new WorldGenTaiga2(false);
    protected static final WorldGenBlockBlob ALPS_ROCK = new WorldGenBlockBlob(Blocks.field_150348_b, 1);

    public BiomeAlpsNorthern(String name, float heightVariation, float BaseHeight, boolean hasTrees) {
        super(new Biome.BiomeProperties(name).func_185411_b().func_185400_d(heightVariation).func_185398_c(BaseHeight).func_185395_b(0.3f).func_185410_a(0.1f).func_185399_a("Northern Alps"));
        this.field_76760_I.field_76803_B = -999;
        this.field_76760_I.field_76802_A = -999;
        this.alpsTrees = hasTrees;
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySkeleton.class, 2, 1, 1));
        if (hasTrees) {
            this.field_76760_I.field_76832_z = 5;
            this.field_76760_I.field_189870_A = 0.1f;
            this.field_76760_I.field_76803_B = 1;
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityWolf.class, 14, 3, 7));
            this.field_76762_K.add(new Biome.SpawnListEntry(EntitySheep.class, 2, 3, 7));
        }
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        if (!this.alpsTrees) {
            this.field_76752_A = Blocks.field_150433_aE.func_176223_P();
            this.field_76753_B = Blocks.field_150433_aE.func_176223_P();
            if (noiseVal > 4.15 + 1.5 * rand.nextDouble() || noiseVal < -0.1 && noiseVal > -0.17) {
                this.field_76752_A = Blocks.field_150348_b.func_176223_P();
                this.field_76753_B = Blocks.field_150348_b.func_176223_P();
            }
        } else {
            this.field_76752_A = Blocks.field_150349_c.func_176223_P();
            this.field_76753_B = Blocks.field_150346_d.func_176223_P();
            if (noiseVal > 4.98) {
                this.field_76752_A = Blocks.field_150348_b.func_176223_P();
            }
        }
        this.func_180628_b(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return SPRUCE_GENERATOR;
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (ChunkPos)new ChunkPos(pos), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.ROCK)) {
            int i = rand.nextInt(3);
            for (int j = 0; j < i; ++j) {
                int k = rand.nextInt(16) + 8;
                int l = rand.nextInt(16) + 8;
                BlockPos blockpos = this.relativeHeight(worldIn, pos, -1);
                if (this.alpsTrees) {
                    ALPS_ROCK.func_180709_b(worldIn, rand, blockpos.func_177982_a(0, -1, 0));
                    continue;
                }
                ALPS_ROCK.func_180709_b(worldIn, rand, blockpos);
            }
        }
        super.func_180624_a(worldIn, rand, pos);
    }

    private BlockPos relativeHeight(World world, BlockPos loc, int shift) {
        return new BlockPos(loc.func_177958_n(), world.func_189649_b(loc.func_177958_n(), loc.func_177952_p()) + shift, loc.func_177952_p());
    }
}

