/*
 * Decompiled with CFR 0.152.
 */
package valoeghese.valoeghesesbe.init;

import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import valoeghese.valoeghesesbe.Main;
import valoeghese.valoeghesesbe.config.ConfigHandler;
import valoeghese.valoeghesesbe.config.ZfgHelper;
import valoeghese.valoeghesesbe.util.handlers.RegistryHandler;
import valoeghese.valoeghesesbe.world.biomes.BiomeAlpsNorthern;
import valoeghese.valoeghesesbe.world.biomes.BiomeAlpsSubalpine;
import valoeghese.valoeghesesbe.world.biomes.BiomeOakHighVillage;
import valoeghese.valoeghesesbe.world.biomes.BiomeOakWHills;
import valoeghese.valoeghesesbe.world.biomes.BiomeOakWoodsBase;
import valoeghese.valoeghesesbe.world.biomes.BiomeWoodsBase;
import valoeghese.valoeghesesbe.world.biomes.alpha2.BiomeFlowerField;
import valoeghese.valoeghesesbe.world.biomes.alpha2.BiomeWasteland;
import valoeghese.valoeghesesbe.world.biomes.alpha3.BiomeOakTallWoodlands;
import valoeghese.valoeghesesbe.world.biomes.alpha3.macro.BiomeGrasslands;
import valoeghese.valoeghesesbe.world.biomes.alpha3.macro.BiomeGrasslandsLakeless;
import valoeghese.valoeghesesbe.world.biomes.alpha3.macro.BiomeSouthernAlps;
import valoeghese.valoeghesesbe.world.biomes.alpha3.mini.BiomeAustralianOutback;
import valoeghese.valoeghesesbe.world.biomes.alpha3.mini.BiomeBluff;
import valoeghese.valoeghesesbe.world.biomes.alpha3.mini.BiomeMire;
import valoeghese.valoeghesesbe.world.biomes.alpha4.BiomeChristmasForest;
import valoeghese.valoeghesesbe.world.biomes.alpha4.BiomeGrassyFen;
import valoeghese.valoeghesesbe.world.biomes.alpha4.BiomeGrassyMarshland;
import valoeghese.valoeghesesbe.world.biomes.alpha4.BiomeReef;
import valoeghese.valoeghesesbe.world.biomes.alpha4.BiomeSandDunes;
import valoeghese.valoeghesesbe.world.biomes.alpha4.BiomeSnowRocks;
import valoeghese.valoeghesesbe.world.biomes.alpha5.BiomeBarelands;
import valoeghese.valoeghesesbe.world.biomes.alpha5.BiomeBrushlands;
import valoeghese.valoeghesesbe.world.biomes.alpha5.BiomeGhostForest;
import valoeghese.valoeghesesbe.world.biomes.alpha5.BiomeLushJungle;
import valoeghese.valoeghesesbe.world.biomes.alpha5.BiomeReefStony;
import valoeghese.valoeghesesbe.world.biomes.alpha5.bush.BiomeBush;
import valoeghese.valoeghesesbe.world.biomes.alpha5.bush.BiomeBushCanyon;

public class ModBiomes {
    public static final ArrayList<Biome> BIOMES = new ArrayList();
    public static Biome VBE_WOODLANDS = new BiomeWoodsBase("Low Spruce Woodlands", 0.06f, 0.43f, 8, 0.05f);
    public static Biome VBE_WOODLANDS_OAK = new BiomeOakWoodsBase("Low Woodlands", 0.07f, 0.5f, 9, 0.05f);
    public static Biome VBE_WOODLANDS_OAK_HIGH = new BiomeOakWoodsBase("High Woodlands", 0.03f, 0.5f, 7, 0.6f, 1.3f);
    public static Biome VBE_WOODLANDS_OAK_HILLY = new BiomeOakWHills("Woodlands Hills", 0.38f, 0.5f, 6, 0.07f, 0.45f);
    public static Biome VBE_WOODLANDS_OAK_HIGH_INHABITED = new BiomeOakHighVillage("High Inhabited Woodlands", 0.025f, 0.48f, 6, 0.04f, 1.28f);
    public static Biome VBE_WOODLANDS_TALL = new BiomeOakTallWoodlands("Low Tall Woodlands", 0.07f, 0.5f, 14, 0.05f);
    public static Biome VBE_ALPS_NORTHERN_SNOWLESS = new BiomeAlpsSubalpine("Northern Alps", 0.24f, 3.2f, false);
    public static Biome VBE_ALPS_NORTHERN = new BiomeAlpsNorthern("Northern Snow Alps", 0.34f, 3.2f, false);
    public static Biome VBE_NORTHERN_SUBALPINE = new BiomeAlpsNorthern("Northern Snow Subalpine Alps", 0.2f, 1.7f, true);
    public static Biome VBE_NORTHERN_SUBALPINE_ALPS = new BiomeAlpsSubalpine("Northern Subalpine Alps", 0.3f, 1.55f, true);
    public static Biome VBE_WASTELAND = new BiomeWasteland("Wasteland Flats", 0.01f, -0.02f, 1);
    public static Biome VBE_WASTELAND_LUSH = new BiomeWasteland("Wasteland Flats Trees", 0.03f, 0.08f, 1);
    public static Biome VBE_WASTELAND_OASIS = new BiomeWasteland("Wasteland Flats Oasis", 0.02f, -0.1f, 2);
    public static Biome VBE_WASTELAND_HILLS = new BiomeWasteland("Wasteland Flats Slopes", 0.24f, 0.23f, 1);
    public static Biome VBE_ORCHID_FIELD = new BiomeFlowerField();
    public static Biome VBE_AUSTRALIAN_OUTBACK = new BiomeAustralianOutback("Australian Outback");
    public static Biome VBE_GRASS_LOWLANDS = new BiomeGrasslands(new Biome.BiomeProperties("Lowlands").func_185399_a("GrasslandsBiome").func_185398_c(0.15f).func_185400_d(0.16f).func_185410_a(0.62f).func_185395_b(0.6f), BiomeGrasslands.Variant.LOWLANDS);
    public static Biome VBE_GRASS_MOORLANDS = new BiomeGrasslands(new Biome.BiomeProperties("Moorlands").func_185398_c(2.25f).func_185400_d(0.16f).func_185410_a(0.56f).func_185395_b(0.6f), BiomeGrasslands.Variant.MOORLANDS);
    public static Biome VBE_GRASS_HIGHLANDS = new BiomeGrasslandsLakeless(new Biome.BiomeProperties("Highlands").func_185399_a("GrasslandsBiome").func_185398_c(2.25f).func_185400_d(0.23f).func_185410_a(0.64f).func_185395_b(0.6f), BiomeGrasslands.Variant.HIGHLANDS);
    public static Biome VBE_GRASS_CHAPPARAL = new BiomeGrasslands(new Biome.BiomeProperties("Lowlands Chapparal").func_185399_a("GrasslandsBiome").func_185398_c(0.33f).func_185400_d(0.45f).func_185410_a(0.75f).func_185395_b(0.34f), BiomeGrasslands.Variant.CHAPPARAL);
    public static Biome VBE_BLUFF = new BiomeBluff();
    public static Biome VBE_ALPS_SOUTHERN = new BiomeSouthernAlps(new Biome.BiomeProperties("Southern Alps").func_185398_c(3.1f).func_185400_d(0.45f).func_185395_b(0.2f).func_185410_a(0.45f), BiomeSouthernAlps.Variant.DEFAULT);
    public static Biome VBE_ALPS_SOUTHERN_SUBALPINE = new BiomeSouthernAlps(new Biome.BiomeProperties("Southern Alps Subalpine").func_185398_c(1.6f).func_185400_d(0.15f).func_185395_b(0.1f).func_185410_a(0.5f).func_185399_a("Southern Alps"), BiomeSouthernAlps.Variant.SUBALPINE);
    public static Biome VBE_ALPS_SOUTHERN_EXTREME = new BiomeSouthernAlps(new Biome.BiomeProperties("Extreme Southern Alps").func_185398_c(3.0f).func_185400_d(0.69f).func_185395_b(0.1f).func_185410_a(0.5f).func_185399_a("Southern Alps"), BiomeSouthernAlps.Variant.EXTREME);
    public static Biome VBE_MIRE = new BiomeMire();
    public static Biome VBE_CHRISTMAS_WOODS = new BiomeChristmasForest(new Biome.BiomeProperties("White Woods").func_185400_d(0.17f).func_185398_c(0.25f).func_185411_b().func_185395_b(0.35f).func_185410_a(-0.3f), false);
    public static Biome VBE_CHRISTMAS_WOODS_OAK = new BiomeChristmasForest(new Biome.BiomeProperties("White Oaks").func_185399_a("White Woods").func_185400_d(0.17f).func_185398_c(0.25f).func_185411_b().func_185395_b(0.35f).func_185410_a(-0.1f), true);
    public static Biome VBE_CHRISTMAS_WOODS_HILLS = new BiomeChristmasForest(new Biome.BiomeProperties("White Woods Hills").func_185399_a("White Woods").func_185400_d(0.35f).func_185398_c(0.65f).func_185411_b().func_185395_b(0.5f).func_185410_a(-0.3f), false);
    public static Biome VBE_CHRISTMAS_WOODS_HILLS_OAK = new BiomeChristmasForest(new Biome.BiomeProperties("White Oaks Hills").func_185399_a("White Woods").func_185400_d(0.35f).func_185398_c(0.65f).func_185411_b().func_185395_b(0.5f).func_185410_a(-0.1f), true);
    public static Biome VBE_SNOW_ROCKS = new BiomeSnowRocks(new Biome.BiomeProperties("Snow Rocks").func_185411_b().func_185395_b(0.4f).func_185410_a(-0.05f).func_185398_c(0.135f).func_185400_d(0.08f));
    public static Biome VBE_SNOW_ROCKS_HILLY = new BiomeSnowRocks(new Biome.BiomeProperties("Snow Rocks Mountains").func_185411_b().func_185395_b(0.4f).func_185410_a(-0.05f).func_185398_c(0.35f).func_185400_d(0.3f).func_185399_a("Snow Rocks"));
    public static Biome VBE_SNOW_ROCKS_HIGH = new BiomeSnowRocks(new Biome.BiomeProperties("Snow Rocks Plateau").func_185411_b().func_185395_b(0.4f).func_185410_a(-0.05f).func_185398_c(1.4f).func_185400_d(0.04f).func_185399_a("Snow Rocks"));
    public static Biome VBE_DUNES = new BiomeSandDunes(new Biome.BiomeProperties("Sand Dunes").func_185396_a().func_185395_b(0.0f).func_185410_a(2.0f).func_185398_c(0.75f).func_185400_d(0.45f), false, false);
    public static Biome VBE_DUNES_RED = new BiomeSandDunes(new Biome.BiomeProperties("Red Sand Dunes").func_185396_a().func_185395_b(0.0f).func_185410_a(2.0f).func_185399_a("Sand Dunes").func_185398_c(0.75f).func_185400_d(0.4f), true, false);
    public static Biome VBE_DUNES_MUTATED = new BiomeSandDunes(new Biome.BiomeProperties("Sand Dunes M").func_185396_a().func_185395_b(0.0f).func_185410_a(2.0f).func_185399_a("Sand Dunes").func_185398_c(1.3f).func_185400_d(0.6f), false, false);
    public static Biome VBE_DUNES_OASIS = new BiomeSandDunes(new Biome.BiomeProperties("Sand Dunes Oasis").func_185395_b(0.4f).func_185410_a(2.0f).func_185399_a("Sand Dunes").func_185398_c(-0.06f).func_185400_d(0.09f), false, true);
    public static Biome VBE_FEN = new BiomeGrassyFen("Grassy Fen", -0.18f, 0.13f);
    public static Biome VBE_MARSH = new BiomeGrassyMarshland("Grassy Marshland", -0.37f, 3.0E-5f);
    public static Biome VBE_REEF = new BiomeReef();
    public static Biome VBE_REEF_STONY = new BiomeReefStony();
    public static Biome VBE_GHOST_FOREST = new BiomeGhostForest();
    public static Biome VBE_BARELANDS = new BiomeBarelands();
    public static Biome VBE_FORESTED_CANYON = new BiomeBushCanyon(new Biome.BiomeProperties("Forested Canyon Pillars").func_185399_a("Forested Canyon Plateau").func_185395_b(0.9f).func_185410_a(0.6f));
    public static Biome VBE_FORESTED_PLATEAU = new BiomeBush(new Biome.BiomeProperties("Forested Canyon Plateau").func_185395_b(0.9f).func_185410_a(0.6f).func_185398_c(2.0f).func_185400_d(0.005f));
    public static Biome VBE_FORESTED_PLATEAU_M = new BiomeBush(new Biome.BiomeProperties("Forested Canyon Plateau M").func_185395_b(0.9f).func_185410_a(0.6f).func_185398_c(2.3f).func_185400_d(0.25f));
    public static Biome VBE_FORESTED_BUSHLAND = new BiomeBush(new Biome.BiomeProperties("Bush").func_185395_b(0.9f).func_185410_a(0.6f).func_185398_c(0.4f).func_185400_d(0.005f));
    public static Biome VBE_FORESTED_BUSHLAND_HILLS = new BiomeBush(new Biome.BiomeProperties("Bushland Hills").func_185399_a("Bush").func_185395_b(0.9f).func_185410_a(0.6f).func_185398_c(0.55f).func_185400_d(0.35f));
    public static Biome VBE_BRUSHLANDS = new BiomeBrushlands(new Biome.BiomeProperties("Brushlands").func_185398_c(0.2f).func_185400_d(0.05f).func_185395_b(0.2f).func_185410_a(0.9f), 2);
    public static Biome VBE_BRUSHLANDS_DESERT = new BiomeBrushlands(new Biome.BiomeProperties("Hot Brushlands").func_185398_c(0.18f).func_185400_d(0.05f).func_185395_b(0.1f).func_185410_a(1.8f).func_185399_a("Brushlands"), 1, true);
    public static Biome VBE_BRUSHLANDS_DENSE = new BiomeBrushlands(new Biome.BiomeProperties("Dense Brushlands").func_185398_c(0.2f).func_185400_d(0.05f).func_185395_b(0.2f).func_185410_a(0.9f).func_185399_a("Brushlands"), 4);
    public static Biome VBE_BRUSHLANDS_HILLS = new BiomeBrushlands(new Biome.BiomeProperties("Brushlands Hills").func_185398_c(0.4f).func_185400_d(0.3f).func_185395_b(0.2f).func_185410_a(0.9f).func_185399_a("Brushlands"), 2);
    public static Biome VBE_LUSH_JUNGLE = new BiomeLushJungle();
    private static FileReader staticBiomesReader;
    private static FileReader staticGrasslandsReader;
    private static FileReader staticM1Reader;
    private static char[] readerBiomeChars;
    private static ConfigHandler biomeAllowConfig;
    private static char[] readerGrasslandsChars;
    private static ConfigHandler grasslandsAllowConfig;
    private static char[] readerM1Chars;
    private static ConfigHandler m1WeightConfig;
    private static Map<String, String> woodWeightsTrue;
    private static Map<String, String> alpsWeightsTrue;
    private static Map<String, String> flatsWeightsTrue;
    private static Map<String, String> xmasWeightsTrue;
    private static Map<String, String> biomesAllowTrue;
    private static Map<String, String> grasslandsWeightsTrue;
    private static Map<String, String> m1WeightsTrue;
    private static Map<String, String> m2WeightsTrue;
    private static Map<String, String> dunesWeightsTrue;
    private static Map<String, String> snowRocksWeightsTrue;
    private static Map<String, String> bushWeightsTrue;
    private static Map<String, String> brushWeightsTrue;
    private static boolean hasRegisteredWeights;

    public static void RegisterBiomes() {
        try {
            if (!hasRegisteredWeights) {
                hasRegisteredWeights = true;
                woodWeightsTrue = ZfgHelper.getMapOf(RegistryHandler.getWeightWoodlandFile(), "BiomeWeights");
                Main.announceLoadedModule("WOODLAND_CONFIG");
                alpsWeightsTrue = ZfgHelper.getMapOf(RegistryHandler.getWeightAlpsFile(), "BiomeWeights");
                Main.announceLoadedModule("ALPS_CONFIG");
                flatsWeightsTrue = ZfgHelper.getMapOf(RegistryHandler.getWeightFlatsFile(), "BiomeWeights");
                Main.announceLoadedModule("FLATS_WASTELAND_CONFIG");
                xmasWeightsTrue = ZfgHelper.getMapOf(RegistryHandler.getWeightChristmasFile(), "BiomeWeights");
                Main.announceLoadedModule("WHITE_FOREST_CONFIG");
                m2WeightsTrue = ZfgHelper.getMapOf(RegistryHandler.getWeightM2File(), "BiomeWeights");
                Main.announceLoadedModule("M2_CONFIG");
                dunesWeightsTrue = ZfgHelper.getMapOf(RegistryHandler.getWeightSandDunesFile(), "BiomeWeights");
                Main.announceLoadedModule("DUNES_CONFIG");
                snowRocksWeightsTrue = ZfgHelper.getMapOf(RegistryHandler.getWeightSnowRocksFile(), "BiomeWeights");
                Main.announceLoadedModule("SNOW_ROCKS_CONFIG");
                bushWeightsTrue = ZfgHelper.getMapOf(RegistryHandler.getWeightBushlandFile(), "BiomeWeights");
                Main.announceLoadedModule("BUSHLAND_CONFIG");
                brushWeightsTrue = ZfgHelper.getMapOf(RegistryHandler.getWeightBrushFile(), "BiomeWeights");
                Main.announceLoadedModule("BRUSH_CONFIG");
            }
            if (staticBiomesReader == null) {
                staticBiomesReader = new FileReader(RegistryHandler.getBiomeFile());
                staticBiomesReader.read(readerBiomeChars);
                biomeAllowConfig = new ConfigHandler(readerBiomeChars, false);
                biomesAllowTrue = biomeAllowConfig.getContainer("NewBiomes");
                System.out.println("Zoesteria has loaded Module NEW_BIOME_MASTER_CONFIG");
                staticBiomesReader.close();
            }
            if (staticGrasslandsReader == null) {
                staticGrasslandsReader = new FileReader(RegistryHandler.getWeightGrasslandsFile());
                staticGrasslandsReader.read(readerGrasslandsChars);
                grasslandsAllowConfig = new ConfigHandler(readerGrasslandsChars, false);
                grasslandsWeightsTrue = grasslandsAllowConfig.getContainer("BiomeWeights");
                System.out.println("Zoesteria has loaded Module GRASSLANDS_CONFIG");
                staticGrasslandsReader.close();
            }
            if (staticM1Reader == null) {
                staticM1Reader = new FileReader(RegistryHandler.getWeightM1File());
                staticM1Reader.read(readerM1Chars);
                m1WeightConfig = new ConfigHandler(readerM1Chars, false);
                m1WeightsTrue = m1WeightConfig.getContainer("BiomeWeights");
                System.out.println("Zoesteria has loaded Module M1_CONFIG");
                staticM1Reader.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ModBiomes.initBiome(VBE_WOODLANDS, "Low Spruce Woodlands", BiomeManager.BiomeType.WARM, Integer.parseInt(woodWeightsTrue.get("VBEWoodlandSpruce")), BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.CONIFEROUS);
        ModBiomes.initBiome(VBE_WOODLANDS_OAK, "Low Woodlands", BiomeManager.BiomeType.WARM, Integer.parseInt(woodWeightsTrue.get("VBEWoodlandOakLow")), BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH);
        ModBiomes.initBiome(VBE_WOODLANDS_OAK_HIGH, "High Woodlands", BiomeManager.BiomeType.WARM, Integer.parseInt(woodWeightsTrue.get("VBEWoodlandOakHigh")), BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.MOUNTAIN);
        ModBiomes.initBiome(VBE_WOODLANDS_OAK_HILLY, "Woodlands Hills", BiomeManager.BiomeType.WARM, Integer.parseInt(woodWeightsTrue.get("VBEWoodlandOakHilly")), BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.HILLS);
        ModBiomes.initBiome(VBE_WOODLANDS_OAK_HIGH_INHABITED, "High Inhabited Woodlands", BiomeManager.BiomeType.WARM, Integer.parseInt(woodWeightsTrue.get("VBEWoodlandOakHighInhabited")), true, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.MOUNTAIN);
        ModBiomes.initBiome(VBE_WOODLANDS_TALL, "Low Tall Woodlands", BiomeManager.BiomeType.WARM, Integer.parseInt(woodWeightsTrue.get("VBEWoodlandOakTall")), BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.SPOOKY);
        ModBiomes.initBiome(VBE_ALPS_NORTHERN, "Northern Snow Alps", BiomeManager.BiomeType.ICY, Integer.parseInt(alpsWeightsTrue.get("VBEAlpsNorthernSnow")), BiomeDictionary.Type.COLD, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.SPARSE);
        ModBiomes.initBiome(VBE_ALPS_NORTHERN_SNOWLESS, "Northern Alps", BiomeManager.BiomeType.ICY, Integer.parseInt(alpsWeightsTrue.get("VBEAlpsNorthern")), BiomeDictionary.Type.COLD, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.SPARSE);
        ModBiomes.initBiome(VBE_NORTHERN_SUBALPINE, "Northern Snow Subalpine Alps", BiomeManager.BiomeType.ICY, Integer.parseInt(alpsWeightsTrue.get("VBEAlpsNorthernSubalpineSnow")), BiomeDictionary.Type.COLD, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SNOWY);
        ModBiomes.initBiome(VBE_NORTHERN_SUBALPINE_ALPS, "Northern Subalpine Alps", BiomeManager.BiomeType.ICY, Integer.parseInt(alpsWeightsTrue.get("VBEAlpsNorthernSubalpine")), BiomeDictionary.Type.COLD, BiomeDictionary.Type.MOUNTAIN);
        ModBiomes.initBiome(VBE_ALPS_SOUTHERN, "Southern Alps", BiomeManager.BiomeType.COOL, Integer.parseInt(alpsWeightsTrue.get("VBEAlpsSouthern")), BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MAGICAL);
        ModBiomes.initBiome(VBE_ALPS_SOUTHERN_SUBALPINE, "Southern Alps Subalpine", BiomeManager.BiomeType.COOL, Integer.parseInt(alpsWeightsTrue.get("VBEAlpsSouthernSubalpine")), BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MAGICAL);
        ModBiomes.initBiome(VBE_ALPS_SOUTHERN_EXTREME, "Extreme Southern Alps", BiomeManager.BiomeType.COOL, Integer.parseInt(alpsWeightsTrue.get("VBEAlpsSouthernExtreme")), BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MAGICAL);
        ModBiomes.initBiome(VBE_WASTELAND, "Wasteland Flats", BiomeManager.BiomeType.DESERT, Integer.parseInt(flatsWeightsTrue.get("VBEWasteland")), BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.WASTELAND);
        ModBiomes.initBiome(VBE_WASTELAND_LUSH, "Wasteland Flats Trees", BiomeManager.BiomeType.WARM, Integer.parseInt(flatsWeightsTrue.get("VBEWastelandLush")), BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.WASTELAND);
        ModBiomes.initBiome(VBE_WASTELAND_OASIS, "Wasteland Flats Oasis", BiomeManager.BiomeType.DESERT, Integer.parseInt(flatsWeightsTrue.get("VBEWastelandOasis")), BiomeDictionary.Type.HOT, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.RARE, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY);
        ModBiomes.initBiome(VBE_WASTELAND_HILLS, "Wasteland Flats Slopes", BiomeManager.BiomeType.DESERT, Integer.parseInt(flatsWeightsTrue.get("VBEWastelandHills")), BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.WASTELAND);
        ModBiomes.initBiome(VBE_ORCHID_FIELD, "Orchid Fields", BiomeManager.BiomeType.WARM, Integer.parseInt(m1WeightsTrue.get("VBEOrchidField")), BiomeDictionary.Type.LUSH, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE);
        ModBiomes.initBiome(VBE_AUSTRALIAN_OUTBACK, "Australian Outback", BiomeManager.BiomeType.DESERT, Integer.parseInt(m1WeightsTrue.get("VBEAustralianOutback")), BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE);
        ModBiomes.initBiome(VBE_GRASS_LOWLANDS, "Lowlands", BiomeManager.BiomeType.WARM, Integer.parseInt(grasslandsWeightsTrue.get("VBEGrassLowlands")), BiomeDictionary.Type.LUSH, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE);
        if (Boolean.parseBoolean(biomesAllowTrue.get("MasterGenAlpha13"))) {
            ModBiomes.initBiome(VBE_GRASS_CHAPPARAL, "Lowlands Chapparal", BiomeManager.BiomeType.WARM, Integer.parseInt(grasslandsWeightsTrue.get("VBEGrassChapparal")), true, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE);
        } else {
            ModBiomes.registerImpossibleBiome(VBE_GRASS_CHAPPARAL, "Lowlands Chapparal", BiomeManager.BiomeType.WARM, Integer.parseInt(grasslandsWeightsTrue.get("VBEGrassChapparal")), true, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE);
        }
        ModBiomes.initBiome(VBE_GRASS_MOORLANDS, "Moorlands", BiomeManager.BiomeType.WARM, Integer.parseInt(grasslandsWeightsTrue.get("VBEGrassMoorlands")), BiomeDictionary.Type.LUSH, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SPOOKY);
        ModBiomes.initBiome(VBE_GRASS_HIGHLANDS, "Highlands", BiomeManager.BiomeType.WARM, Integer.parseInt(grasslandsWeightsTrue.get("VBEGrassHighlands")), true, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.MOUNTAIN);
        ModBiomes.initBiome(VBE_BLUFF, "Bluff", BiomeManager.BiomeType.COOL, Integer.parseInt(m1WeightsTrue.get("VBEBluff")), BiomeDictionary.Type.COLD, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN);
        ModBiomes.initBiome(VBE_MIRE, "Mire", BiomeManager.BiomeType.COOL, Integer.parseInt(m1WeightsTrue.get("VBEMire")), BiomeDictionary.Type.DEAD, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.SWAMP);
        if (Boolean.parseBoolean(biomesAllowTrue.get("MasterGenAlpha13"))) {
            ModBiomes.initBiome(VBE_CHRISTMAS_WOODS, "White Woods", BiomeManager.BiomeType.ICY, Integer.parseInt(xmasWeightsTrue.get("VBEChristmasWoods")), BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.SNOWY);
            ModBiomes.initBiome(VBE_CHRISTMAS_WOODS_OAK, "White Oaks", BiomeManager.BiomeType.ICY, Integer.parseInt(xmasWeightsTrue.get("VBEChristmasWoodsOak")), true, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.SNOWY);
            ModBiomes.initBiome(VBE_CHRISTMAS_WOODS_HILLS, "White Woods Hills", BiomeManager.BiomeType.ICY, Integer.parseInt(xmasWeightsTrue.get("VBEChristmasWoodsHills")), BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.SNOWY);
            ModBiomes.initBiome(VBE_CHRISTMAS_WOODS_HILLS_OAK, "White Oaks Hills", BiomeManager.BiomeType.ICY, Integer.parseInt(xmasWeightsTrue.get("VBEChristmasWoodsHillsOak")), BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.SNOWY);
            ModBiomes.initBiome(VBE_SNOW_ROCKS, "Snow Rocks", BiomeManager.BiomeType.ICY, Integer.parseInt(snowRocksWeightsTrue.get("VBESnowRocks")), BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.WASTELAND);
            ModBiomes.initBiome(VBE_SNOW_ROCKS_HILLY, "Snow Rocks Mountains", BiomeManager.BiomeType.ICY, Integer.parseInt(snowRocksWeightsTrue.get("VBESnowRocksHilly")), BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.HILLS);
            ModBiomes.initBiome(VBE_SNOW_ROCKS_HIGH, "Snow Rocks Plateau", BiomeManager.BiomeType.ICY, Integer.parseInt(snowRocksWeightsTrue.get("VBESnowRocksPlateau")), BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.HILLS);
            ModBiomes.initBiome(VBE_DUNES, "Sand Dunes", BiomeManager.BiomeType.DESERT, Integer.parseInt(dunesWeightsTrue.get("VBEDunes")), BiomeDictionary.Type.DRY, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE);
            ModBiomes.initBiome(VBE_DUNES_RED, "Red Sand Dunes", BiomeManager.BiomeType.DESERT, Integer.parseInt(dunesWeightsTrue.get("VBEDunesRed")), BiomeDictionary.Type.DRY, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE);
            ModBiomes.initBiome(VBE_DUNES_MUTATED, "Sand Dunes M", BiomeManager.BiomeType.DESERT, Integer.parseInt(dunesWeightsTrue.get("VBEDunesMutated")), BiomeDictionary.Type.DRY, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE);
            ModBiomes.initBiome(VBE_DUNES_OASIS, "Sand Dunes Oasis", BiomeManager.BiomeType.DESERT, Integer.parseInt(dunesWeightsTrue.get("VBEDunesOasis")), true, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE);
            ModBiomes.initBiome(VBE_FEN, "Grassy Fen", BiomeManager.BiomeType.WARM, 5, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET);
            ModBiomes.initBiome(VBE_MARSH, "Grassy Marshland", BiomeManager.BiomeType.WARM, 5, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET);
            ModBiomes.initBiome(VBE_REEF, "Archipelago", BiomeManager.BiomeType.WARM, Integer.parseInt(m2WeightsTrue.get("VBEArchipelago")), BiomeDictionary.Type.OCEAN);
        } else {
            ModBiomes.registerImpossibleBiome(VBE_CHRISTMAS_WOODS, "White Woods", BiomeManager.BiomeType.ICY, Integer.parseInt(xmasWeightsTrue.get("VBEChristmasWoods")), BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.SNOWY);
            ModBiomes.registerImpossibleBiome(VBE_CHRISTMAS_WOODS_OAK, "White Oaks", BiomeManager.BiomeType.ICY, Integer.parseInt(xmasWeightsTrue.get("VBEChristmasWoodsOak")), true, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.SNOWY);
            ModBiomes.registerImpossibleBiome(VBE_CHRISTMAS_WOODS_HILLS, "White Woods Hills", BiomeManager.BiomeType.ICY, Integer.parseInt(xmasWeightsTrue.get("VBEChristmasWoodsHills")), BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.SNOWY);
            ModBiomes.registerImpossibleBiome(VBE_CHRISTMAS_WOODS_HILLS_OAK, "White Oaks Hills", BiomeManager.BiomeType.ICY, Integer.parseInt(xmasWeightsTrue.get("VBEChristmasWoodsHillsOak")), BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.SNOWY);
            ModBiomes.registerImpossibleBiome(VBE_SNOW_ROCKS, "Snow Rocks", BiomeManager.BiomeType.ICY, Integer.parseInt(snowRocksWeightsTrue.get("VBESnowRocks")), BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.WASTELAND);
            ModBiomes.registerImpossibleBiome(VBE_SNOW_ROCKS_HILLY, "Snow Rocks Mountains", BiomeManager.BiomeType.ICY, Integer.parseInt(snowRocksWeightsTrue.get("VBESnowRocksHilly")), BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.HILLS);
            ModBiomes.registerImpossibleBiome(VBE_SNOW_ROCKS_HIGH, "Snow Rocks Plateau", BiomeManager.BiomeType.ICY, Integer.parseInt(snowRocksWeightsTrue.get("VBESnowRocksPlateau")), BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.HILLS);
            ModBiomes.registerImpossibleBiome(VBE_DUNES, "Sand Dunes", BiomeManager.BiomeType.DESERT, Integer.parseInt(dunesWeightsTrue.get("VBEDunes")), BiomeDictionary.Type.DRY, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE);
            ModBiomes.registerImpossibleBiome(VBE_DUNES_RED, "Red Sand Dunes", BiomeManager.BiomeType.DESERT, Integer.parseInt(dunesWeightsTrue.get("VBEDunesRed")), BiomeDictionary.Type.DRY, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE);
            ModBiomes.registerImpossibleBiome(VBE_DUNES_MUTATED, "Sand Dunes M", BiomeManager.BiomeType.DESERT, Integer.parseInt(dunesWeightsTrue.get("VBEDunesMutated")), BiomeDictionary.Type.DRY, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE);
            ModBiomes.registerImpossibleBiome(VBE_DUNES_OASIS, "Sand Dunes Oasis", BiomeManager.BiomeType.DESERT, Integer.parseInt(dunesWeightsTrue.get("VBEDunesOasis")), true, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE);
            ModBiomes.registerImpossibleBiome(VBE_FEN, "Grassy Fen", BiomeManager.BiomeType.WARM, 5, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET);
            ModBiomes.registerImpossibleBiome(VBE_MARSH, "Grassy Marshland", BiomeManager.BiomeType.WARM, 5, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET);
            ModBiomes.registerImpossibleBiome(VBE_REEF, "Archipelago", BiomeManager.BiomeType.WARM, Integer.parseInt(m2WeightsTrue.get("VBEArchipelago")), BiomeDictionary.Type.OCEAN);
            System.out.println("Impossible biomes registered and generation disabled (1.3)");
        }
        if (Boolean.parseBoolean(biomesAllowTrue.get("MasterGenAlpha14"))) {
            ModBiomes.initRemoteBiome(VBE_GHOST_FOREST, "Ghost Forest", BiomeManager.BiomeType.WARM, Integer.parseInt(m2WeightsTrue.get("VBEGhostForest")), BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.RARE);
            ModBiomes.initRemoteBiome(VBE_BARELANDS, "Barelands", BiomeManager.BiomeType.COOL, Integer.parseInt(m2WeightsTrue.get("VBEBarelands")), BiomeDictionary.Type.DEAD, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.RARE);
            ModBiomes.initRemoteBiome(VBE_FORESTED_CANYON, "Forested Canyon Pillars", BiomeManager.BiomeType.WARM, Integer.parseInt(bushWeightsTrue.get("VBEForestedPillars")), BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.MESA);
            ModBiomes.initRemoteBiome(VBE_FORESTED_PLATEAU, "Forested Canyon Plateau", BiomeManager.BiomeType.WARM, Integer.parseInt(bushWeightsTrue.get("VBEForestedPlateau")), BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.MESA);
            ModBiomes.initRemoteBiome(VBE_FORESTED_PLATEAU_M, "Forested Canyon Plateau M", BiomeManager.BiomeType.WARM, Integer.parseInt(bushWeightsTrue.get("VBEForestedPlateauM")), BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.MESA);
            ModBiomes.initBiome(VBE_FORESTED_BUSHLAND, "Bush", BiomeManager.BiomeType.WARM, Integer.parseInt(bushWeightsTrue.get("VBEForestedBushland")), BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.JUNGLE);
            ModBiomes.initBiome(VBE_FORESTED_BUSHLAND_HILLS, "Bushland Hills", BiomeManager.BiomeType.WARM, Integer.parseInt(bushWeightsTrue.get("VBEForestedBushlandHills")), BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.JUNGLE);
            ModBiomes.initBiome(VBE_BRUSHLANDS, "Brushlands", BiomeManager.BiomeType.WARM, Integer.parseInt(brushWeightsTrue.get("VBEBrushlands")), BiomeDictionary.Type.DRY, BiomeDictionary.Type.PLAINS);
            ModBiomes.initBiome(VBE_BRUSHLANDS_DENSE, "Dense Brushlands", BiomeManager.BiomeType.WARM, Integer.parseInt(brushWeightsTrue.get("VBEBrushlandsDense")), BiomeDictionary.Type.DRY, BiomeDictionary.Type.PLAINS);
            ModBiomes.initBiome(VBE_BRUSHLANDS_DESERT, "Hot Brushlands", BiomeManager.BiomeType.WARM, Integer.parseInt(brushWeightsTrue.get("VBEBrushlandsDesert")), BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.PLAINS);
            ModBiomes.initBiome(VBE_BRUSHLANDS_HILLS, "Brushlands Hills", BiomeManager.BiomeType.WARM, Integer.parseInt(brushWeightsTrue.get("VBEBrushlandsHills")), BiomeDictionary.Type.DRY, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.HILLS);
            ModBiomes.initBiome(VBE_REEF_STONY, "Stony Reef", BiomeManager.BiomeType.WARM, Integer.parseInt(m2WeightsTrue.get("VBEReefStony")), BiomeDictionary.Type.OCEAN);
            ModBiomes.initBiome(VBE_LUSH_JUNGLE, "Tropical Jungle", BiomeManager.BiomeType.WARM, Integer.parseInt(m2WeightsTrue.get("VBELushJungle")), BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        } else {
            ModBiomes.registerImpossibleBiome(VBE_GHOST_FOREST, "Ghost Forest", BiomeManager.BiomeType.WARM, Integer.parseInt(m2WeightsTrue.get("VBEGhostForest")), BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.RARE);
            ModBiomes.registerImpossibleBiome(VBE_BARELANDS, "Barelands", BiomeManager.BiomeType.COOL, Integer.parseInt(m2WeightsTrue.get("VBEBarelands")), BiomeDictionary.Type.DEAD, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.RARE);
            ModBiomes.registerImpossibleBiome(VBE_FORESTED_CANYON, "Forested Canyon Pillars", BiomeManager.BiomeType.WARM, Integer.parseInt(bushWeightsTrue.get("VBEForestedPillars")), BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.MESA);
            ModBiomes.registerImpossibleBiome(VBE_FORESTED_PLATEAU, "Forested Canyon Plateau", BiomeManager.BiomeType.WARM, Integer.parseInt(bushWeightsTrue.get("VBEForestedPlateau")), BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.MESA);
            ModBiomes.registerImpossibleBiome(VBE_FORESTED_PLATEAU_M, "Forested Canyon Plateau M", BiomeManager.BiomeType.WARM, Integer.parseInt(bushWeightsTrue.get("VBEForestedPlateauM")), BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.MESA);
            ModBiomes.registerImpossibleBiome(VBE_FORESTED_BUSHLAND, "Bush", BiomeManager.BiomeType.WARM, Integer.parseInt(bushWeightsTrue.get("VBEForestedBushland")), BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.JUNGLE);
            ModBiomes.registerImpossibleBiome(VBE_FORESTED_BUSHLAND_HILLS, "Bushland Hills", BiomeManager.BiomeType.WARM, Integer.parseInt(bushWeightsTrue.get("VBEForestedBushlandHills")), BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.JUNGLE);
            ModBiomes.registerImpossibleBiome(VBE_BRUSHLANDS, "Brushlands", BiomeManager.BiomeType.WARM, Integer.parseInt(brushWeightsTrue.get("VBEBrushlands")), BiomeDictionary.Type.DRY, BiomeDictionary.Type.PLAINS);
            ModBiomes.registerImpossibleBiome(VBE_BRUSHLANDS_DENSE, "Dense Brushlands", BiomeManager.BiomeType.WARM, Integer.parseInt(brushWeightsTrue.get("VBEBrushlandsDense")), BiomeDictionary.Type.DRY, BiomeDictionary.Type.PLAINS);
            ModBiomes.registerImpossibleBiome(VBE_BRUSHLANDS_DESERT, "Hot Brushlands", BiomeManager.BiomeType.WARM, Integer.parseInt(brushWeightsTrue.get("VBEBrushlandsDesert")), BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.PLAINS);
            ModBiomes.registerImpossibleBiome(VBE_BRUSHLANDS_HILLS, "Brushlands Hills", BiomeManager.BiomeType.WARM, Integer.parseInt(brushWeightsTrue.get("VBEBrushlandsHills")), BiomeDictionary.Type.DRY, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.HILLS);
            ModBiomes.registerImpossibleBiome(VBE_REEF_STONY, "Stony Reef", BiomeManager.BiomeType.WARM, Integer.parseInt(m2WeightsTrue.get("VBEReefStony")), BiomeDictionary.Type.OCEAN);
            ModBiomes.registerImpossibleBiome(VBE_LUSH_JUNGLE, "Tropical Jungle", BiomeManager.BiomeType.WARM, Integer.parseInt(m2WeightsTrue.get("VBELushJungle")), BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
            System.out.println("Impossible biomes registered and generation disabled (1.4)");
        }
        System.out.println("Zoesteria Biomes has loaded module \"BIOME_EXPANSIONS\"");
    }

    private static void initBiome(Biome biome, String name, BiomeManager.BiomeType biomeType, int weight, BiomeDictionary.Type ... types) {
        ModBiomes.initBiome(biome, name, biomeType, weight, false, types);
    }

    private static void initRemoteBiome(Biome biome, String name, BiomeManager.BiomeType biomeType, int weight, BiomeDictionary.Type ... types) {
        biome.setRegistryName(name);
        ForgeRegistries.BIOMES.register((IForgeRegistryEntry)biome);
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])types);
        BiomeManager.addBiome((BiomeManager.BiomeType)biomeType, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(biome, weight));
    }

    private static void initBiome(Biome biome, String name, BiomeManager.BiomeType biomeType, int weight, boolean includesVillages, BiomeDictionary.Type ... types) {
        biome.setRegistryName(name);
        ForgeRegistries.BIOMES.register((IForgeRegistryEntry)biome);
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])types);
        BiomeManager.addBiome((BiomeManager.BiomeType)biomeType, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(biome, weight));
        BiomeManager.addSpawnBiome((Biome)biome);
        if (includesVillages) {
            BiomeManager.addVillageBiome((Biome)biome, (boolean)true);
        }
    }

    private static void registerImpossibleBiome(Biome biome, String name, BiomeManager.BiomeType biomeType, int weight, BiomeDictionary.Type ... types) {
        ModBiomes.registerImpossibleBiome(biome, name, biomeType, weight, false, types);
    }

    private static void registerImpossibleBiome(Biome biome, String name, BiomeManager.BiomeType biomeType, int weight, boolean includesVillages, BiomeDictionary.Type ... types) {
        biome.setRegistryName(name);
        ForgeRegistries.BIOMES.register((IForgeRegistryEntry)biome);
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])types);
        BiomeManager.removeSpawnBiome((Biome)biome);
        if (includesVillages) {
            BiomeManager.addVillageBiome((Biome)biome, (boolean)true);
        }
    }

    static {
        readerBiomeChars = new char[Short.MAX_VALUE];
        readerGrasslandsChars = new char[Short.MAX_VALUE];
        readerM1Chars = new char[Short.MAX_VALUE];
        hasRegisteredWeights = false;
    }
}

