/*
 * Decompiled with CFR 0.152.
 */
package valoeghese.valoeghesesbe.functional.tree;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.terraingen.TerrainGen;
import valoeghese.valoeghesesbe.Main;
import valoeghese.valoeghesesbe.init.ModBlocks;
import valoeghese.valoeghesesbe.init.ModItems;
import valoeghese.valoeghesesbe.util.IHasModel;
import valoeghese.valoeghesesbe.world.trees.WorldGenBluffPine;
import valoeghese.valoeghesesbe.world.trees.WorldGenDatePalm;
import valoeghese.valoeghesesbe.world.trees.WorldGenIslandPalm;
import valoeghese.valoeghesesbe.world.trees.WorldGenManukaTree;
import valoeghese.valoeghesesbe.world.trees.WorldGenOceanPalm;
import valoeghese.valoeghesesbe.world.trees.evil.WorldGenEvilTreeSapling;
import valoeghese.valoeghesesbe.world.trees.fruittree.WorldGenPlum;
import valoeghese.valoeghesesbe.world.trees.newzealand.WorldGenPohutukawa1;
import valoeghese.valoeghesesbe.world.trees.queenpalm.WorldGenQueenPalm;

public class BlockSaplingBase
extends BlockBush
implements IGrowable,
IHasModel {
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)1);
    protected static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);
    private String type;

    public BlockSaplingBase(String name, String type) {
        this(name, type, true);
    }

    public BlockSaplingBase(String name, String type, boolean setDefaultState) {
        this.func_149663_c(name);
        this.setRegistryName(name);
        if (setDefaultState) {
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
        }
        this.func_149647_a(Main.tabWorld);
        this.type = type;
        this.func_149672_a(SoundType.field_185850_c);
        ModBlocks.BLOCKS.add((Block)this);
        ModItems.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            if (!worldIn.func_175697_a(pos, 1)) {
                return;
            }
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.func_176474_b(worldIn, rand, pos, state);
            }
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        if (this.type == "oasis_palm" || this.type == "pohutukawa" || this.type == "ocean_palm" || this.type == "island_palm" || this.type == "date_palm") {
            return super.func_176196_c(worldIn, pos) || soil.func_177230_c() == Blocks.field_150354_m;
        }
        return super.func_176196_c(worldIn, pos) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf((meta & 8) >> 3));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        return i |= (Integer)state.func_177229_b((IProperty)STAGE) << 3;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE});
    }

    @Override
    public void registerModels() {
        Main.proxy.registerModel(Item.func_150898_a((Block)this), 0);
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
            worldIn.func_180501_a(pos, state.func_177231_a((IProperty)STAGE), 4);
        } else {
            this.generateTree(worldIn, rand, pos, state);
        }
    }

    public void generateTree(World world, Random rand, BlockPos pos, IBlockState state) {
        if (!TerrainGen.saplingGrowTree((World)world, (Random)rand, (BlockPos)pos)) {
            return;
        }
        WorldGenAbstractTree gen = new WorldGenQueenPalm();
        boolean flag = false;
        int i = 0;
        int j = 0;
        switch (this.type) {
            case "oasis_palm": {
                gen = new WorldGenQueenPalm(true);
                break;
            }
            case "forest_evil": {
                gen = new WorldGenEvilTreeSapling();
                break;
            }
            case "pine_bluff": {
                gen = new WorldGenBluffPine(true);
                break;
            }
            case "pohutukawa": {
                gen = new WorldGenPohutukawa1(true);
                break;
            }
            case "ocean_palm": {
                gen = new WorldGenOceanPalm(true, 5);
                break;
            }
            case "manuka": {
                gen = new WorldGenManukaTree(true);
                break;
            }
            case "island_palm": {
                gen = new WorldGenIslandPalm(true, 6);
                break;
            }
            case "plum": {
                gen = new WorldGenPlum(true);
                break;
            }
            case "date_palm": {
                gen = new WorldGenDatePalm(true);
            }
        }
        IBlockState iblockstate = Blocks.field_150350_a.func_176223_P();
        if (flag) {
            world.func_180501_a(pos.func_177982_a(i, 0, j), iblockstate, 4);
            world.func_180501_a(pos.func_177982_a(i + 1, 0, j), iblockstate, 4);
            world.func_180501_a(pos.func_177982_a(i, 0, j + 1), iblockstate, 4);
            world.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), iblockstate, 4);
        } else {
            world.func_180501_a(pos, iblockstate, 4);
        }
        if (!gen.func_180709_b(world, rand, pos.func_177982_a(i, 0, j))) {
            if (flag) {
                world.func_180501_a(pos.func_177982_a(i, 0, j), this.func_176223_P(), 4);
                world.func_180501_a(pos.func_177982_a(i + 1, 0, j), iblockstate, 4);
                world.func_180501_a(pos.func_177982_a(i, 0, j + 1), iblockstate, 4);
                world.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), iblockstate, 4);
            } else {
                world.func_180501_a(pos, this.func_176223_P(), 4);
            }
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    protected boolean func_185514_i(IBlockState state) {
        if (this.type == "oasis_palm" || this.type == "pohutukawa" || this.type == "ocean_palm" || this.type == "island_palm" || this.type == "date_palm") {
            return state.func_185904_a() == Material.field_151578_c || state.func_185904_a() == Material.field_151577_b || state.func_185904_a() == Material.field_151585_k || state.func_185904_a() == Material.field_151595_p;
        }
        return state.func_185904_a() == Material.field_151578_c || state.func_185904_a() == Material.field_151577_b || state.func_185904_a() == Material.field_151585_k;
    }
}

