/*
 * Decompiled with CFR 0.152.
 */
package valoeghese.valoeghesesbe;

import api.valoeghese.valoeghesesbe.BushGen;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;
import valoeghese.valoeghesesbe.blocks.BlockSmallBush;
import valoeghese.valoeghesesbe.compat.CompatOreDictionary;
import valoeghese.valoeghesesbe.gui.CreativeTabMisc;
import valoeghese.valoeghesesbe.gui.CreativeTabPlants;
import valoeghese.valoeghesesbe.init.ModBiomes;
import valoeghese.valoeghesesbe.init.ModBlocks;
import valoeghese.valoeghesesbe.init.ModRecipes;
import valoeghese.valoeghesesbe.init.ModStructures;
import valoeghese.valoeghesesbe.proxy.CommonProxy;
import valoeghese.valoeghesesbe.util.TerrainHandler;
import valoeghese.valoeghesesbe.util.handlers.ModelRenderHandler;
import valoeghese.valoeghesesbe.world.ModWorldGeneration;
import valoeghese.valoeghesesbe.world.worldtype.WorldTypeSmooth;

@Mod(modid="valoegheses_be", name="Valoeghese's Biome Expansions", version="1.4.10-public-alpha-ddss", acceptedMinecraftVersions="[1.12.2]")
public class Main {
    public static final boolean newGenerationBoolean = false;
    public static final CreativeTabs tabWorld = new CreativeTabPlants();
    public static final CreativeTabs tabMisc = new CreativeTabMisc();
    @Mod.Instance
    public static Main instance;
    @SidedProxy(clientSide="valoeghese.valoeghesesbe.proxy.ClientProxy", serverSide="valoeghese.valoeghesesbe.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final boolean isDDSSEdition = true;
    public static Logger logger;
    public static BushGen genStandard;
    public static BushGen genBerry;
    public static BushGen genConiferous;
    public static BushGen[] bushes;

    @Mod.EventHandler
    public static void PreInit(FMLPreInitializationEvent event) {
        MinecraftForge.TERRAIN_GEN_BUS.register(TerrainHandler.class);
        ModBiomes.RegisterBiomes();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new ModWorldGeneration(), (int)3);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new ModStructures(), (int)2);
        if (event.getSide() == Side.CLIENT) {
            ModelRenderHandler.preInit(event);
        }
    }

    @Mod.EventHandler
    public static void Init(FMLInitializationEvent event) {
        for (Biome b : BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS)) {
            genStandard.removeBiomeFromSet(b);
        }
        CompatOreDictionary.oreDictionaryMats();
        ModRecipes.init();
    }

    @Mod.EventHandler
    public static void PostInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        WorldTypeSmooth SMOOTH = new WorldTypeSmooth("Smooth");
    }

    public static void announceLoadedModule(String moduleNameIn) {
        System.out.println("Zoesteria has loaded module " + moduleNameIn);
    }

    static {
        genStandard = new BushGen(ModBlocks.SMALL_BUSH.func_176223_P(), BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH).removeBiomeFromSet(ModBiomes.VBE_FEN).removeBiomeFromSet(ModBiomes.VBE_ORCHID_FIELD).removeBiomeFromSet(ModBiomes.VBE_WOODLANDS);
        genBerry = new BushGen(ModBlocks.SMALL_BUSH.func_176223_P().func_177226_a(BlockSmallBush.VARIANT, (Comparable)((Object)BlockSmallBush.EnumBushType.BERRY)), BiomeDictionary.Type.FOREST);
        genConiferous = new BushGen(ModBlocks.SMALL_BUSH.func_176223_P().func_177226_a(BlockSmallBush.VARIANT, (Comparable)((Object)BlockSmallBush.EnumBushType.CONIFEROUS)), BiomeDictionary.Type.CONIFEROUS);
        bushes = new BushGen[]{genStandard, genBerry, genConiferous};
    }
}

