/*
 * Decompiled with CFR 0.152.
 */
package api.valoeghese.valoeghesesbe;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BushGen {
    public Set<Biome> allowedBiomes = new HashSet<Biome>();
    protected Set<Biome> blacklist = new HashSet<Biome>();
    private BiomeDictionary.Type[] types;
    public IBlockState gen;

    public Set<Class> getAllowedBiomeClasses() {
        HashSet<Class> temp = new HashSet<Class>();
        for (Biome b : this.allowedBiomes) {
            temp.add(b.getClass());
        }
        return temp;
    }

    public BushGen(IBlockState bush, BiomeDictionary.Type ... types) {
        this.types = types;
        this.gen = bush;
    }

    public boolean canGenInBiome(Biome b) {
        return this.allowedBiomes.contains(b);
    }

    public BushGen load() {
        return this.loadUnrestricted();
    }

    @Deprecated
    private BushGen loadRestricted() {
        if (this.types.length == 1) {
            return this.loadUnrestricted();
        }
        for (Biome b : BiomeDictionary.getBiomes((BiomeDictionary.Type)this.types[0])) {
            if (this.blacklist.contains(b)) continue;
            boolean allow = true;
            for (BiomeDictionary.Type t : BiomeDictionary.getTypes((Biome)b)) {
                if (BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)t)) continue;
                allow = false;
                break;
            }
            if (!allow) continue;
            this.allowedBiomes.add(b);
        }
        return this;
    }

    private BushGen loadUnrestricted() {
        for (BiomeDictionary.Type t : this.types) {
            for (Biome b : BiomeDictionary.getBiomes((BiomeDictionary.Type)t)) {
                if (this.blacklist.contains(b)) continue;
                this.allowedBiomes.add(b);
            }
        }
        return this;
    }

    public BushGen removeBiomeFromSet(Biome b) {
        this.allowedBiomes.remove(b);
        this.blacklist.add(b);
        return this;
    }
}

