/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.render;

import java.awt.Rectangle;
import mezz.jei.config.Config;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.render.IngredientRenderer;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;

public class ItemStackFastRenderer
extends IngredientRenderer<ItemStack> {
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");

    public ItemStackFastRenderer(IIngredientListElement<ItemStack> itemStackElement) {
        super(itemStackElement);
    }

    public void renderItemAndEffectIntoGUI() {
        try {
            this.uncheckedRenderItemAndEffectIntoGUI();
        }
        catch (LinkageError | RuntimeException e) {
            throw ErrorUtil.createRenderIngredientException(e, this.element.getIngredient());
        }
    }

    private IBakedModel getBakedModel() {
        ItemModelMesher itemModelMesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        ItemStack itemStack = (ItemStack)this.element.getIngredient();
        IBakedModel bakedModel = itemModelMesher.func_178089_a(itemStack);
        return bakedModel.func_188617_f().handleItemState(bakedModel, itemStack, null, null);
    }

    private void uncheckedRenderItemAndEffectIntoGUI() {
        if (Config.isHideModeEnabled()) {
            ItemStackFastRenderer.renderEditMode(this.element, this.area, this.padding);
            GlStateManager.func_179147_l();
        }
        ItemStack itemStack = (ItemStack)this.element.getIngredient();
        IBakedModel bakedModel = this.getBakedModel();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)(this.area.x + this.padding) + 8.0f), (float)((float)(this.area.y + this.padding) + 8.0f), (float)150.0f);
        GlStateManager.func_179152_a((float)16.0f, (float)-16.0f, (float)16.0f);
        bakedModel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedModel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        Minecraft minecraft = Minecraft.func_71410_x();
        RenderItem renderItem = minecraft.func_175599_af();
        renderItem.func_191961_a(bakedModel, itemStack);
        if (itemStack.func_77962_s()) {
            this.renderEffect(bakedModel);
        }
        GlStateManager.func_179121_F();
    }

    protected void renderEffect(IBakedModel model) {
        Minecraft minecraft = Minecraft.func_71410_x();
        TextureManager textureManager = minecraft.func_110434_K();
        RenderItem renderItem = minecraft.func_175599_af();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179112_b((int)768, (int)1);
        textureManager.func_110577_a(RES_ITEM_GLINT);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
        GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        renderItem.func_191965_a(model, -8372020);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f / 8.0f;
        GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        renderItem.func_191965_a(model, -8372020);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        textureManager.func_110577_a(TextureMap.field_110575_b);
    }

    public void renderOverlay() {
        ItemStack itemStack = (ItemStack)this.element.getIngredient();
        try {
            this.renderOverlay(itemStack, this.area, this.padding);
        }
        catch (LinkageError | RuntimeException e) {
            throw ErrorUtil.createRenderIngredientException(e, this.element.getIngredient());
        }
    }

    private void renderOverlay(ItemStack itemStack, Rectangle area, int padding) {
        FontRenderer font = ItemStackFastRenderer.getFontRenderer(itemStack);
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        renderItem.func_180453_a(font, itemStack, area.x + padding, area.y + padding, null);
    }

    public static FontRenderer getFontRenderer(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        FontRenderer fontRenderer = item.getFontRenderer(itemStack);
        if (fontRenderer == null) {
            fontRenderer = Minecraft.func_71410_x().field_71466_p;
        }
        return fontRenderer;
    }
}

