/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.events;

import com.animania.Animania;
import com.animania.common.capabilities.CapabilityPlayerProvider;
import com.animania.common.capabilities.CapabilityRefs;
import com.animania.common.capabilities.ICapabilityPlayer;
import com.animania.network.client.CapSyncPacket;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CapabilityLoadHandler {
    @SubscribeEvent
    public void onEntityConstructing(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(CapabilityRefs.toResource("AnimaniaPlayerCaps"), (ICapabilityProvider)new CapabilityPlayerProvider());
        }
    }

    @SubscribeEvent
    public void onClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        ICapabilityPlayer propsNew = CapabilityRefs.getPlayerCaps(event.getEntityPlayer());
        propsNew.read(event.getOriginal());
    }

    @SubscribeEvent
    public void startTracking(PlayerEvent.StartTracking event) {
        ICapabilityPlayer caps;
        Entity target = event.getTarget();
        EntityPlayer viewer = event.getEntityPlayer();
        if (target instanceof EntityPlayerMP && (caps = CapabilityRefs.getPlayerCaps((EntityPlayer)target)) != null) {
            Animania.network.sendTo((IMessage)new CapSyncPacket(caps, target.func_145782_y()), (EntityPlayerMP)viewer);
        }
    }

    @SubscribeEvent
    public void entityJoinWorld(EntityJoinWorldEvent event) {
        EntityPlayerMP player;
        ICapabilityPlayer caps;
        Entity e = event.getEntity();
        if (e instanceof EntityPlayerMP && (caps = CapabilityRefs.getPlayerCaps((EntityPlayer)(player = (EntityPlayerMP)e))) != null) {
            Animania.network.sendTo((IMessage)new CapSyncPacket(caps, player.func_145782_y()), player);
        }
    }
}

