/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.sheep;

import com.animania.Animania;
import com.animania.common.ModSoundEvents;
import com.animania.common.entities.EntityGender;
import com.animania.common.entities.generic.ai.GenericAIMate;
import com.animania.common.entities.interfaces.IMateable;
import com.animania.common.entities.interfaces.ISterilizable;
import com.animania.common.entities.sheep.EntityAnimaniaSheep;
import com.animania.common.entities.sheep.EntityEweBase;
import com.animania.common.entities.sheep.EntityLambBase;
import com.animania.common.entities.sheep.ai.EntityAIButtHeadsSheep;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.compat.top.providers.entity.TOPInfoProviderMateable;
import com.animania.config.AnimaniaConfig;
import com.google.common.base.Optional;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityRamBase
extends EntityAnimaniaSheep
implements TOPInfoProviderMateable,
IMateable,
ISterilizable {
    protected static final DataParameter<Boolean> FIGHTING = EntityDataManager.func_187226_a(EntityRamBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> STERILIZED = EntityDataManager.func_187226_a(EntityRamBase.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityRamBase(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.2f, 1.0f);
        this.field_70130_N = 1.2f;
        this.field_70131_O = 1.0f;
        this.field_70138_W = 1.1f;
        this.gender = EntityGender.MALE;
        this.headbutting = true;
        this.mateable = true;
        if (!this.getSterilized()) {
            this.field_70714_bg.func_75776_a(5, new GenericAIMate(this, 1.0, EntityEweBase.class, EntityLambBase.class, EntityAnimaniaSheep.class));
        }
        if (AnimaniaConfig.gameRules.animalsCanAttackOthers && !this.getSterilized()) {
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIButtHeadsSheep((EntityAnimal)this, 1.3));
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FIGHTING, (Object)false);
        this.field_70180_af.func_187214_a(STERILIZED, (Object)false);
    }

    public boolean getFighting() {
        try {
            return this.getBoolFromDataManager(FIGHTING);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setFighting(boolean fighting) {
        if (fighting) {
            this.field_70180_af.func_187227_b(FIGHTING, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(FIGHTING, (Object)false);
        }
    }

    @Nullable
    public UUID getRivalUniqueId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(RIVAL_UNIQUE_ID)).orNull();
    }

    public void setRivalUniqueId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(RIVAL_UNIQUE_ID, (Object)Optional.fromNullable((Object)uniqueId));
    }

    protected SoundEvent func_184639_G() {
        int chooser;
        int happy = 0;
        int num = 1;
        if (this.getWatered()) {
            ++happy;
        }
        if (this.getFed()) {
            ++happy;
        }
        if ((chooser = Animania.RANDOM.nextInt(num = happy == 2 ? 10 : (happy == 1 ? 20 : 40))) == 0) {
            return ModSoundEvents.sheepLiving1;
        }
        if (chooser == 1) {
            return ModSoundEvents.sheepLiving2;
        }
        if (chooser == 2) {
            return ModSoundEvents.sheepLiving3;
        }
        if (chooser == 3) {
            return ModSoundEvents.sheepLiving4;
        }
        if (chooser == 4) {
            return ModSoundEvents.sheepLiving5;
        }
        if (chooser == 5) {
            return ModSoundEvents.sheepLiving6;
        }
        if (chooser == 6) {
            return ModSoundEvents.sheepLiving7;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        int chooser = Animania.RANDOM.nextInt(2);
        if (chooser == 0) {
            return ModSoundEvents.sheepHurt1;
        }
        return ModSoundEvents.sheepLiving7;
    }

    protected SoundEvent func_184615_bR() {
        int chooser = Animania.RANDOM.nextInt(3);
        if (chooser == 0) {
            return ModSoundEvents.sheepHurt1;
        }
        return ModSoundEvents.sheepLiving7;
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null && !this.getSleeping()) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i() - 0.21f);
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.1f, 0.8f);
    }

    @Override
    public void func_70636_d() {
        if (this.blinkTimer > -1) {
            --this.blinkTimer;
            if (this.blinkTimer == 0) {
                this.blinkTimer = 200 + this.field_70146_Z.nextInt(200);
                if (this.getMateUniqueId() != null) {
                    UUID mate = this.getMateUniqueId();
                    boolean mateReset = true;
                    List<EntityEweBase> entities = AnimaniaHelper.getEntitiesInRange(EntityEweBase.class, 30.0, this.field_70170_p, (Entity)this);
                    for (int k = 0; k <= entities.size() - 1; ++k) {
                        UUID id;
                        Entity entity = (Entity)entities.get(k);
                        if (entity == null || !(id = entity.getPersistentID()).equals(this.getMateUniqueId()) || entity.field_70128_L) continue;
                        mateReset = false;
                        EntityEweBase ewe = (EntityEweBase)entity;
                        if (!ewe.getPregnant()) break;
                        this.setHandFed(false);
                        break;
                    }
                    if (mateReset) {
                        this.setMateUniqueId(null);
                    }
                }
            }
        }
        super.func_70636_d();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 80;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70894_j(float p_70894_1_) {
        return this.eatTimer <= 0 ? 0.0f : (this.eatTimer >= 4 && this.eatTimer <= 76 ? 1.0f : (this.eatTimer < 4 ? ((float)this.eatTimer - p_70894_1_) / 4.0f : -((float)(this.eatTimer - 80) - p_70894_1_) / 4.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70890_k(float p_70890_1_) {
        if (this.eatTimer > 4 && this.eatTimer <= 76) {
            float f = ((float)(this.eatTimer - 4) - p_70890_1_) / 24.0f;
            return 0.62831855f + 0.14660767f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.eatTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    @Override
    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != ItemStack.field_190927_a && EntityAnimaniaSheep.TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        if (player.func_70093_af()) {
            if (this.func_70892_o()) {
                if (this.getWoolRegrowthTimer() > 0) {
                    int bob = this.getWoolRegrowthTimer();
                    probeInfo.text(I18n.func_74838_a((String)"text.waila.wool1") + " (" + bob + " " + I18n.func_74838_a((String)"text.waila.wool2") + ")");
                }
            } else if (!this.func_70892_o()) {
                probeInfo.text(I18n.func_74838_a((String)"text.waila.wool3"));
            }
        }
        TOPInfoProviderMateable.super.addProbeInfo(mode, probeInfo, player, world, entity, data);
    }

    @Override
    public boolean getSterilized() {
        return this.getBoolFromDataManager(STERILIZED);
    }

    @Override
    public void setSterilized(boolean sterilized) {
        this.field_70180_af.func_187227_b(STERILIZED, (Object)sterilized);
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        compound.func_74757_a("Sterilized", this.getSterilized());
        return super.func_189511_e(compound);
    }

    public void func_70020_e(NBTTagCompound compound) {
        this.setSterilized(compound.func_74767_n("Sterilized"));
        super.func_70020_e(compound);
    }

    @Override
    public void sterilize() {
        Iterator it = this.field_70714_bg.field_75782_a.iterator();
        while (it.hasNext()) {
            EntityAITasks.EntityAITaskEntry entry = (EntityAITasks.EntityAITaskEntry)it.next();
            EntityAIBase ai = entry.field_75733_a;
            if (!(ai instanceof GenericAIMate) && !(ai instanceof EntityAIButtHeadsSheep)) continue;
            entry.field_188524_c = false;
            ai.func_75251_c();
            it.remove();
        }
        this.setSterilized(true);
    }
}

