/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.rodents.rabbits;

import com.animania.Animania;
import com.animania.common.ModSoundEvents;
import com.animania.common.entities.EntityGender;
import com.animania.common.entities.interfaces.IChild;
import com.animania.common.entities.rodents.ai.EntityAIFollowParentRabbits;
import com.animania.common.entities.rodents.rabbits.EntityAnimaniaRabbit;
import com.animania.common.entities.rodents.rabbits.EntityRabbitBuckBase;
import com.animania.common.entities.rodents.rabbits.EntityRabbitDoeBase;
import com.animania.compat.top.providers.entity.TOPInfoProviderChild;
import com.animania.config.AnimaniaConfig;
import com.google.common.base.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityRabbitKitBase
extends EntityAnimaniaRabbit
implements TOPInfoProviderChild,
IChild {
    protected static final DataParameter<Optional<UUID>> PARENT_UNIQUE_ID = EntityDataManager.func_187226_a(EntityRabbitKitBase.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Float> AGE = EntityDataManager.func_187226_a(EntityRabbitKitBase.class, (DataSerializer)DataSerializers.field_187193_c);
    protected int ageTimer;

    public EntityRabbitKitBase(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 0.8f);
        this.field_70130_N = 0.8f;
        this.field_70131_O = 0.8f;
        this.field_70138_W = 1.1f;
        this.ageTimer = 0;
        this.gender = EntityGender.CHILD;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowParentRabbits((EntityAnimal)this, 1.15));
    }

    public boolean func_70631_g_() {
        return true;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.315);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AGE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(PARENT_UNIQUE_ID, (Object)Optional.absent());
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("Age", this.getEntityAge());
        if (this.getParentUniqueId() != null && this.getParentUniqueId() != null) {
            compound.func_74778_a("ParentUUID", this.getParentUniqueId().toString());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        String s;
        super.func_70037_a(compound);
        this.setEntityAge(compound.func_74760_g("Age"));
        if (compound.func_150297_b("ParentUUID", 8)) {
            s = compound.func_74779_i("ParentUUID");
        } else {
            String s1 = compound.func_74779_i("Parent");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            this.setParentUniqueId(UUID.fromString(s));
        }
    }

    @Override
    @Nullable
    public UUID getParentUniqueId() {
        try {
            UUID id = (UUID)((Optional)this.field_70180_af.func_187225_a(PARENT_UNIQUE_ID)).orNull();
            return id;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setParentUniqueId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(PARENT_UNIQUE_ID, (Object)Optional.fromNullable((Object)uniqueId));
    }

    protected SoundEvent func_184639_G() {
        int chooser;
        int happy = 0;
        int num = 1;
        if (this.getWatered()) {
            ++happy;
        }
        if (this.getFed()) {
            ++happy;
        }
        if ((chooser = Animania.RANDOM.nextInt(num = happy == 2 ? 8 : (happy == 1 ? 16 : 32))) == 0) {
            return ModSoundEvents.rabbit1;
        }
        if (chooser == 1) {
            return ModSoundEvents.rabbit2;
        }
        if (chooser == 2) {
            return ModSoundEvents.rabbit3;
        }
        if (chooser == 3) {
            return ModSoundEvents.rabbit4;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return Animania.RANDOM.nextBoolean() ? ModSoundEvents.rabbitHurt1 : ModSoundEvents.rabbitHurt2;
    }

    protected SoundEvent func_184615_bR() {
        return Animania.RANDOM.nextBoolean() ? ModSoundEvents.rabbitHurt1 : ModSoundEvents.rabbitHurt2;
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null && !this.getSleeping()) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i() + 0.2f);
        }
    }

    public float getEntityAge() {
        try {
            return this.getFloatFromDataManager(AGE);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public void setEntityAge(float age) {
        this.field_70180_af.func_187227_b(AGE, (Object)Float.valueOf(age));
    }

    @Override
    public void func_70636_d() {
        boolean fed = this.getFed();
        boolean watered = this.getWatered();
        this.field_175504_a = -24000;
        ++this.ageTimer;
        if (this.ageTimer >= AnimaniaConfig.careAndFeeding.childGrowthTick && fed && watered) {
            this.ageTimer = 0;
            float age = this.getEntityAge();
            this.setEntityAge(age += 0.01f);
            if ((double)age >= 0.36 && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
                if (this.field_70146_Z.nextInt(2) < 1) {
                    EntityRabbitDoeBase entityGoat = this.rabbitType.getFemale(this.field_70170_p);
                    if (entityGoat != null) {
                        entityGoat.func_70107_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
                        String name = this.func_95999_t();
                        if (name != "") {
                            entityGoat.func_96094_a(name);
                        }
                        entityGoat.setAge(1);
                        this.field_70170_p.func_72838_d((Entity)entityGoat);
                        this.func_184185_a(ModSoundEvents.rabbit1, 0.5f, 1.1f);
                    }
                } else {
                    EntityRabbitBuckBase entityGoat = this.rabbitType.getMale(this.field_70170_p);
                    if (entityGoat != null) {
                        entityGoat.func_70107_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
                        String name = this.func_95999_t();
                        if (name != "") {
                            entityGoat.func_96094_a(name);
                        }
                        entityGoat.setAge(1);
                        this.field_70170_p.func_72838_d((Entity)entityGoat);
                        this.func_184185_a(ModSoundEvents.rabbit1, 0.5f, 1.1f);
                    }
                }
            }
        }
        super.func_70636_d();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 80;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        return this.eatTimer <= 0 ? 0.0f : (this.eatTimer >= 4 && this.eatTimer <= 76 ? 1.0f : (this.eatTimer < 4 ? ((float)this.eatTimer - p_70894_1_) / 4.0f : -((float)(this.eatTimer - 80) - p_70894_1_) / 4.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.eatTimer > 4 && this.eatTimer <= 76) {
            float f = ((float)(this.eatTimer - 4) - p_70890_1_) / 24.0f;
            return 0.62831855f + 0.14660767f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.eatTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    @Override
    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != ItemStack.field_190927_a && EntityAnimaniaRabbit.TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    protected void func_70628_a(boolean hit, int lootlevel) {
    }

    protected Item func_146068_u() {
        return null;
    }
}

