/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.horses.ai;

import com.animania.common.entities.horses.EntityAnimaniaHorse;
import com.animania.common.entities.props.EntityCart;
import com.animania.common.entities.props.EntityWagon;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.config.AnimaniaConfig;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityHorseEatGrass
extends EntityAIBase {
    private static final Predicate<IBlockState> IS_TALL_GRASS = BlockStateMatcher.func_177638_a((Block)Blocks.field_150329_H).func_177637_a((IProperty)BlockTallGrass.field_176497_a, Predicates.equalTo((Object)BlockTallGrass.EnumType.GRASS));
    private final EntityAnimaniaHorse grassEaterEntity;
    private final World entityWorld;
    int eatingGrassTimer;

    public EntityHorseEatGrass(EntityLiving grassEaterEntityIn) {
        this.grassEaterEntity = (EntityAnimaniaHorse)grassEaterEntityIn;
        this.entityWorld = grassEaterEntityIn.field_70170_p;
        this.func_75248_a(7);
    }

    public boolean func_75250_a() {
        List<EntityWagon> wagons;
        if (!this.grassEaterEntity.field_70170_p.func_72935_r()) {
            return false;
        }
        if (this.grassEaterEntity.func_184207_aI()) {
            return false;
        }
        if (this.grassEaterEntity.getFed()) {
            return false;
        }
        List<EntityCart> carts = AnimaniaHelper.getCartsInRange(EntityCart.class, 3.0, this.entityWorld, (Entity)this.grassEaterEntity);
        if (!carts.isEmpty()) {
            EntityCart cart = carts.get(0);
            if (cart.pulled && cart.puller == this.grassEaterEntity) {
                return false;
            }
        }
        if (!(wagons = AnimaniaHelper.getWagonsInRange(EntityWagon.class, 3.0, this.entityWorld, (Entity)this.grassEaterEntity)).isEmpty()) {
            EntityWagon wagon = wagons.get(0);
            if (wagon.pulled && wagon.puller == this.grassEaterEntity) {
                return false;
            }
        }
        if (this.grassEaterEntity.func_70681_au().nextInt(this.grassEaterEntity.func_70631_g_() ? 50 : 150) != 0) {
            return false;
        }
        BlockPos blockpos = new BlockPos(this.grassEaterEntity.field_70165_t, this.grassEaterEntity.field_70163_u, this.grassEaterEntity.field_70161_v);
        return IS_TALL_GRASS.apply((Object)this.entityWorld.func_180495_p(blockpos)) ? true : this.entityWorld.func_180495_p(blockpos.func_177977_b()).func_177230_c() == Blocks.field_150349_c;
    }

    public void func_75249_e() {
        this.eatingGrassTimer = 100;
        this.entityWorld.func_72960_a((Entity)this.grassEaterEntity, (byte)10);
        this.grassEaterEntity.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        this.eatingGrassTimer = 0;
    }

    public boolean func_75253_b() {
        return this.eatingGrassTimer > 0;
    }

    public int getEatingGrassTimer() {
        return this.eatingGrassTimer;
    }

    public void func_75246_d() {
        this.eatingGrassTimer = Math.max(0, this.eatingGrassTimer - 1);
        if (this.eatingGrassTimer == 4) {
            BlockPos blockpos = new BlockPos(this.grassEaterEntity.field_70165_t, this.grassEaterEntity.field_70163_u, this.grassEaterEntity.field_70161_v);
            if (IS_TALL_GRASS.apply((Object)this.entityWorld.func_180495_p(blockpos))) {
                this.entityWorld.func_175655_b(blockpos, false);
                if (this.grassEaterEntity instanceof EntityAnimaniaHorse) {
                    EntityAnimaniaHorse ech = this.grassEaterEntity;
                    ech.entityAIEatGrass.func_75249_e();
                    ech.setFed(true);
                }
                this.grassEaterEntity.func_70615_aA();
            } else {
                BlockPos blockpos1 = blockpos.func_177977_b();
                if (this.entityWorld.func_180495_p(blockpos1).func_177230_c() == Blocks.field_150349_c) {
                    this.entityWorld.func_175718_b(2001, blockpos1, Block.func_149682_b((Block)Blocks.field_150349_c));
                    if (AnimaniaConfig.gameRules.plantsRemovedAfterEating) {
                        this.entityWorld.func_180501_a(blockpos1, Blocks.field_150346_d.func_176223_P(), 2);
                    }
                    if (this.grassEaterEntity instanceof EntityAnimaniaHorse) {
                        EntityAnimaniaHorse ech = this.grassEaterEntity;
                        ech.entityAIEatGrass.func_75249_e();
                        ech.setFed(true);
                    }
                    this.grassEaterEntity.func_70615_aA();
                }
            }
        }
    }
}

