/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.generic.ai;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public abstract class GenericAISearchBlock
extends EntityAIBase {
    protected final EntityCreature creature;
    protected final double movementSpeed;
    protected BlockPos destinationBlock = NO_POS;
    private boolean isAtDestination;
    protected final int searchRange;
    protected World world;
    protected List<EnumFacing> destinationOffset;
    protected BlockPos seekingBlockPos = NO_POS;
    protected BlockPos oldBlockPos = NO_POS;
    private boolean hasSecondary;
    private int walkTries = 0;
    private boolean isDone = false;
    private Set<BlockPos> nonValidPositions = new HashSet<BlockPos>();
    public static final BlockPos NO_POS = new BlockPos(-1, -1, -1);

    public GenericAISearchBlock(EntityCreature creature, double speedIn, int range, boolean hasSecondary, EnumFacing ... destinationOffset) {
        this.creature = creature;
        this.movementSpeed = speedIn;
        this.searchRange = range;
        this.destinationOffset = new ArrayList<EnumFacing>();
        for (EnumFacing f : destinationOffset) {
            this.destinationOffset.add(f);
        }
        this.world = creature.field_70170_p;
        this.hasSecondary = hasSecondary;
    }

    public GenericAISearchBlock(EntityCreature creature, double speedIn, int range, EnumFacing ... destinationOffset) {
        this(creature, speedIn, range, false, destinationOffset);
    }

    public boolean func_75250_a() {
        if (this.seekingBlockPos == NO_POS) {
            return this.searchForDestination();
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.destinationBlock != NO_POS && this.seekingBlockPos != NO_POS && !this.isDone && (this.shouldMoveTo(this.creature.field_70170_p, this.seekingBlockPos) || this.hasSecondary && this.shouldMoveToSecondary(this.world, this.seekingBlockPos));
    }

    public void func_75249_e() {
        this.creature.func_70661_as().func_75492_a((double)this.destinationBlock.func_177958_n() + 0.5, (double)this.destinationBlock.func_177956_o(), (double)this.destinationBlock.func_177952_p() + 0.5, this.movementSpeed);
        this.walkTries = 0;
    }

    public void func_75251_c() {
        this.isAtDestination = false;
        this.destinationBlock = NO_POS;
        this.seekingBlockPos = NO_POS;
        this.walkTries = 0;
        this.isDone = false;
    }

    public void func_75246_d() {
        if (!this.func_75253_b()) {
            this.func_75251_c();
        }
        if (!this.destinationBlock.equals((Object)NO_POS)) {
            double distance = this.creature.func_174831_c(this.destinationBlock);
            if (distance > 1.95) {
                boolean isStandingStill;
                this.isAtDestination = false;
                ++this.walkTries;
                boolean bl = isStandingStill = this.creature.field_70169_q == this.creature.field_70165_t && this.creature.field_70167_r == this.creature.field_70163_u && this.creature.field_70166_s == this.creature.field_70161_v;
                if (this.walkTries % 40 == 0 || isStandingStill) {
                    this.creature.func_70661_as().func_75492_a((double)this.destinationBlock.func_177958_n() + 0.5, (double)this.destinationBlock.func_177956_o(), (double)this.destinationBlock.func_177952_p() + 0.5, this.movementSpeed);
                    this.creature.func_70671_ap().func_75650_a((double)this.seekingBlockPos.func_177958_n() + 0.5, (double)this.seekingBlockPos.func_177956_o(), (double)this.seekingBlockPos.func_177952_p() + 0.5, 10.0f, (float)this.creature.func_70646_bf());
                }
                if (isStandingStill && this.walkTries > 100) {
                    this.nonValidPositions.add(this.seekingBlockPos);
                    this.func_75251_c();
                    this.searchForDestination();
                }
            } else {
                this.isAtDestination = true;
                this.walkTries = 0;
            }
            if (this.isAtDestination) {
                this.nonValidPositions.clear();
                this.isDone = true;
            }
        }
    }

    protected boolean isAtDestination() {
        return this.isAtDestination;
    }

    public void onArriveAtDestination() {
        this.nonValidPositions.clear();
    }

    public boolean func_75252_g() {
        return true;
    }

    protected boolean searchForDestination() {
        BlockPos blockpos = new BlockPos((Entity)this.creature);
        if (blockpos.equals((Object)this.oldBlockPos)) {
            return false;
        }
        this.oldBlockPos = blockpos;
        BlockPos secondaryDest = null;
        BlockPos secondarySeek = null;
        int ySearchRange = this.searchRange / 2;
        if (ySearchRange < 1) {
            ySearchRange = 1;
        }
        for (int range = 0; range < this.searchRange; ++range) {
            int y = 0;
            while (y <= ySearchRange) {
                int x = 0;
                while (x <= range) {
                    int z;
                    int n = z = x < range && x > -range ? range : 0;
                    while (z <= range) {
                        boolean shouldMoveToPrimary;
                        BlockPos blockpos1 = blockpos.func_177982_a(x, y - 1, z);
                        if (!this.nonValidPositions.contains(blockpos1) && ((shouldMoveToPrimary = this.shouldMoveTo(this.creature.field_70170_p, blockpos1)) || this.hasSecondary && secondarySeek == null && this.shouldMoveToSecondary(this.creature.field_70170_p, blockpos1))) {
                            if (this.destinationOffset.isEmpty()) {
                                if (this.creature.func_70661_as().func_75488_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o(), (double)blockpos1.func_177952_p() + 0.5) != null) {
                                    if (shouldMoveToPrimary) {
                                        this.destinationBlock = blockpos1;
                                        this.seekingBlockPos = blockpos1;
                                        return true;
                                    }
                                    secondaryDest = blockpos1;
                                    secondarySeek = blockpos1;
                                }
                            } else {
                                Collections.shuffle(this.destinationOffset);
                                for (EnumFacing facing : this.destinationOffset) {
                                    BlockPos offsetPos;
                                    AxisAlignedBB aabb = this.world.func_180495_p(blockpos1).func_185890_d((IBlockAccess)this.world, blockpos1);
                                    BlockPos blockPos = offsetPos = aabb == Block.field_185506_k ? blockpos1 : blockpos1.func_177972_a(facing);
                                    if (this.creature.func_70661_as().func_75488_a((double)offsetPos.func_177958_n() + 0.5, (double)offsetPos.func_177956_o(), (double)offsetPos.func_177952_p() + 0.5) == null) continue;
                                    if (shouldMoveToPrimary) {
                                        this.destinationBlock = offsetPos;
                                        this.seekingBlockPos = blockpos1;
                                        return true;
                                    }
                                    secondaryDest = offsetPos;
                                    secondarySeek = blockpos1;
                                }
                            }
                        }
                        z = z > 0 ? -z : 1 - z;
                    }
                    x = x > 0 ? -x : 1 - x;
                }
                y = y > 0 ? -y : 1 - y;
            }
        }
        if (secondarySeek != null) {
            this.destinationBlock = secondaryDest;
            this.seekingBlockPos = secondarySeek;
            return true;
        }
        return false;
    }

    protected boolean pathExists(BlockPos start, BlockPos end) {
        try {
            PathPoint startPoint = new PathPoint(start.func_177958_n(), start.func_177956_o(), start.func_177952_p());
            PathPoint endPoint = new PathPoint(end.func_177958_n(), end.func_177956_o(), end.func_177952_p());
            PathNavigate navigate = this.creature.func_70661_as();
            Method getPathFinder = ReflectionHelper.findMethod(PathNavigate.class, (String)"getPathFinder", (String)"func_179679_a", (Class[])new Class[0]);
            Method getPath = ReflectionHelper.findMethod(PathFinder.class, (String)"findPath", (String)"func_186336_a", (Class[])new Class[]{PathPoint.class, PathPoint.class, Float.TYPE});
            getPathFinder.setAccessible(true);
            getPath.setAccessible(true);
            PathFinder finder = (PathFinder)getPathFinder.invoke((Object)navigate, new Object[0]);
            Path p = (Path)getPath.invoke((Object)finder, startPoint, endPoint, Float.valueOf(this.searchRange));
            return p != null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected abstract boolean shouldMoveTo(World var1, BlockPos var2);

    protected boolean shouldMoveToSecondary(World worldIn, BlockPos pos) {
        return false;
    }
}

