/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.generic.ai;

import com.animania.Animania;
import com.animania.common.entities.interfaces.IFoodEating;
import com.animania.common.entities.interfaces.IMateable;
import com.animania.common.entities.interfaces.ISleeping;
import com.animania.common.entities.interfaces.ISterilizable;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.config.AnimaniaConfig;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.world.World;

public class GenericAIMate<T extends EntityCreature & IFoodEating, O extends EntityCreature & IFoodEating>
extends EntityAIBase {
    private final T entity;
    World theWorld;
    private O targetMate;
    int courtshipTimer;
    double moveSpeed;
    private int delayCounter;
    private Class female;
    private Class child;
    private Class base;

    public GenericAIMate(T animal, double speedIn, Class other, Class child, Class base) {
        this.entity = animal;
        this.theWorld = ((EntityCreature)animal).field_70170_p;
        this.moveSpeed = speedIn;
        this.func_75248_a(3);
        this.courtshipTimer = 20;
        this.delayCounter = 0;
        this.female = other;
        this.child = child;
        this.base = base;
    }

    public boolean func_75250_a() {
        ++this.delayCounter;
        if (this.delayCounter > AnimaniaConfig.gameRules.ticksBetweenAIFirings) {
            if (this.entity instanceof ISterilizable && ((ISterilizable)this.entity).getSterilized()) {
                this.delayCounter = 0;
                return false;
            }
            if (((ISleeping)this.entity).getSleeping()) {
                this.delayCounter = 0;
                return false;
            }
            if (this.child.isInstance(this.entity) || this.female.isInstance(this.entity) || this.entity.func_70090_H()) {
                this.delayCounter = 0;
                return false;
            }
            List similarAnimalsInRange = AnimaniaHelper.getEntitiesInRange(this.base, 30.0, this.theWorld, this.entity);
            if (similarAnimalsInRange.size() >= AnimaniaConfig.careAndFeeding.entityBreedingLimit) {
                this.delayCounter = 0;
                return false;
            }
            if (AnimaniaConfig.careAndFeeding.manualBreeding && this.entity instanceof IFoodEating && !((IFoodEating)this.entity).getHandFed()) {
                this.delayCounter = 0;
                return false;
            }
            this.targetMate = this.getNearbyMate();
            if (this.targetMate != null && Animania.RANDOM.nextInt(20) == 0) {
                this.delayCounter = 0;
                this.func_75251_c();
                return false;
            }
            return this.targetMate != null;
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.targetMate != null) {
            return this.targetMate.func_70089_S();
        }
        return false;
    }

    public void func_75251_c() {
        this.targetMate = null;
    }

    public void func_75246_d() {
        if (this.targetMate != null) {
            if (!((IMateable)this.targetMate).getPregnant() && ((IMateable)this.targetMate).getFertile()) {
                this.targetMate = this.getNearbyMate();
            } else {
                ((EntityAnimal)this.entity).func_70875_t();
                this.func_75251_c();
                this.entity.func_70661_as().func_75499_g();
                this.delayCounter = 0;
            }
        }
    }

    private O getNearbyMate() {
        T male = this.entity;
        UUID mateID = null;
        if (((IMateable)male).getMateUniqueId() != null) {
            mateID = ((IMateable)male).getMateUniqueId();
        }
        if (mateID != null) {
            List entities = AnimaniaHelper.getEntitiesInRange(this.female, 3.0, ((EntityCreature)this.entity).field_70170_p, this.entity);
            for (int k = 0; k <= entities.size() - 1; ++k) {
                EntityCreature female = (EntityCreature)entities.get(k);
                boolean allowBreeding = true;
                if (AnimaniaConfig.careAndFeeding.manualBreeding && female instanceof IFoodEating && !((IFoodEating)female).getHandFed()) {
                    allowBreeding = false;
                }
                if (!female.getPersistentID().equals(mateID) || !((IMateable)female).getFertile() || !(female instanceof ISleeping) || ((ISleeping)female).getSleeping() || ((IMateable)female).getPregnant() || !allowBreeding || !female.func_70685_l(male)) continue;
                --this.courtshipTimer;
                if (this.courtshipTimer < 0) {
                    ((IMateable)this.entity).setInLove(null);
                    this.courtshipTimer = 20;
                    k = entities.size();
                    ((IMateable)female).setPregnant(true);
                    ((IMateable)female).setFertile(false);
                    ((IFoodEating)female).setHandFed(false);
                    this.delayCounter = 0;
                    return (O)female;
                }
                if (!allowBreeding) continue;
                k = entities.size();
                ((IMateable)this.entity).setInLove(null);
                this.entity.func_70671_ap().func_75651_a((Entity)female, 10.0f, (float)this.entity.func_70646_bf());
                this.entity.func_70661_as().func_75497_a((Entity)female, this.moveSpeed);
                female.func_70671_ap().func_75651_a(this.entity, 10.0f, (float)female.func_70646_bf());
                female.func_70661_as().func_75497_a(this.entity, this.moveSpeed);
                return null;
            }
        } else {
            List entities = AnimaniaHelper.getEntitiesInRange(this.female, 5.0, ((EntityCreature)this.entity).field_70170_p, this.entity);
            for (int k = 0; k <= entities.size() - 1; ++k) {
                EntityCreature female = (EntityCreature)entities.get(k);
                boolean allowBreeding = true;
                if (AnimaniaConfig.careAndFeeding.manualBreeding && !((IFoodEating)female).getHandFed()) {
                    allowBreeding = false;
                }
                --this.courtshipTimer;
                if (((IMateable)female).getMateUniqueId() == null && this.courtshipTimer < 0 && ((IMateable)female).getFertile() && !((ISleeping)female).getSleeping() && !((IMateable)female).getPregnant() && allowBreeding && female.func_70685_l(male)) {
                    ((IMateable)this.entity).setMateUniqueId(female.getPersistentID());
                    ((IMateable)female).setMateUniqueId(this.entity.getPersistentID());
                    ((IMateable)this.entity).setInLove(null);
                    this.courtshipTimer = 20;
                    k = entities.size();
                    ((IMateable)female).setPregnant(true);
                    ((IMateable)female).setFertile(false);
                    ((IFoodEating)female).setHandFed(false);
                    this.delayCounter = 0;
                    return (O)female;
                }
                if (((IMateable)female).getMateUniqueId() != null || ((IMateable)female).getPregnant() || ((ISleeping)female).getSleeping() || !((IMateable)female).getFertile() || !allowBreeding || !female.func_70685_l(male)) continue;
                k = entities.size();
                ((IMateable)this.entity).setInLove(null);
                this.entity.func_70671_ap().func_75651_a((Entity)female, 10.0f, (float)this.entity.func_70646_bf());
                this.entity.func_70661_as().func_75497_a((Entity)female, this.moveSpeed);
                female.func_70671_ap().func_75651_a(this.entity, 10.0f, (float)female.func_70646_bf());
                female.func_70661_as().func_75497_a(this.entity, this.moveSpeed);
                return null;
            }
        }
        this.delayCounter = 0;
        return null;
    }
}

