/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.generic.ai;

import com.animania.common.entities.generic.ai.GenericAISearchBlock;
import com.animania.common.entities.interfaces.IFoodEating;
import com.animania.common.entities.interfaces.ISleeping;
import com.animania.common.handler.BlockHandler;
import com.animania.common.tileentities.TileEntityInvisiblock;
import com.animania.common.tileentities.TileEntityTrough;
import com.animania.config.AnimaniaConfig;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GenericAIFindFood<T extends EntityCreature & ISleeping>
extends GenericAISearchBlock {
    private final T entity;
    private int foodDelay;
    private EntityAIBase eatAI;
    private boolean eatBlocks;

    public GenericAIFindFood(T entity, double speedIn, @Nullable EntityAIBase eatAI, boolean eatBlocks) {
        super((EntityCreature)entity, speedIn, AnimaniaConfig.gameRules.aiBlockSearchRange, eatBlocks, EnumFacing.field_176754_o);
        this.entity = entity;
        this.func_75248_a(3);
        this.foodDelay = 0;
        this.eatAI = eatAI;
        this.eatBlocks = eatBlocks;
    }

    @Override
    public boolean func_75250_a() {
        if (++this.foodDelay <= AnimaniaConfig.gameRules.ticksBetweenAIFirings) {
            return false;
        }
        if (((IFoodEating)this.entity).getFed() || this.entity.func_184207_aI() || ((ISleeping)this.entity).getSleeping()) {
            this.foodDelay = 0;
            return false;
        }
        if (this.entity.func_70681_au().nextInt(3) != 0) {
            return false;
        }
        this.foodDelay = 0;
        return super.func_75250_a();
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b() && !((IFoodEating)this.entity).getFed();
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.isAtDestination()) {
            this.creature.func_70671_ap().func_75650_a((double)this.seekingBlockPos.func_177958_n() + 0.5, (double)this.seekingBlockPos.func_177956_o(), (double)this.seekingBlockPos.func_177952_p() + 0.5, 10.0f, (float)this.creature.func_70646_bf());
            IBlockState state = this.world.func_180495_p(this.seekingBlockPos);
            Block block = state.func_177230_c();
            if (block == BlockHandler.blockTrough || block == BlockHandler.blockInvisiblock) {
                TileEntityTrough trough;
                TileEntityTrough tileEntityTrough = trough = block == BlockHandler.blockTrough ? (TileEntityTrough)this.world.func_175625_s(this.seekingBlockPos) : ((TileEntityInvisiblock)this.world.func_175625_s(this.seekingBlockPos)).getTrough();
                if (trough != null && trough.canConsume(((IFoodEating)this.entity).getFoodItems(), ((IFoodEating)this.entity).getFoodFluid())) {
                    trough.consumeSolidOrLiquid(100, 1);
                    if (this.eatAI != null) {
                        this.eatAI.func_75249_e();
                    }
                    ((IFoodEating)this.entity).setLiquidFed(true);
                    ((IFoodEating)this.entity).setFed(true);
                    ((IFoodEating)this.entity).setHandFed(true);
                    ((EntityCreature)this.entity).field_70170_p.func_175666_e(this.seekingBlockPos, block);
                    this.foodDelay = 0;
                }
            }
            if (this.isBlockFood(block)) {
                if (this.eatAI != null) {
                    this.eatAI.func_75249_e();
                }
                ((IFoodEating)this.entity).setFed(true);
                if (AnimaniaConfig.gameRules.plantsRemovedAfterEating) {
                    ((EntityCreature)this.entity).field_70170_p.func_175655_b(this.seekingBlockPos, false);
                }
            }
            this.foodDelay = 0;
        }
    }

    @Override
    protected boolean shouldMoveTo(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == BlockHandler.blockTrough || block == BlockHandler.blockInvisiblock) {
            TileEntityTrough trough;
            TileEntityTrough tileEntityTrough = trough = block == BlockHandler.blockTrough ? (TileEntityTrough)world.func_175625_s(pos) : ((TileEntityInvisiblock)world.func_175625_s(pos)).getTrough();
            if (trough != null && trough.canConsume(((IFoodEating)this.entity).getFoodItems(), ((IFoodEating)this.entity).getFoodFluid())) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean shouldMoveToSecondary(World worldIn, BlockPos pos) {
        IBlockState state = this.world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return this.eatBlocks && this.isBlockFood(block);
    }

    public boolean isBlockFood(Block block) {
        Class[] foodBlocks;
        for (Class c : foodBlocks = ((IFoodEating)this.entity).getFoodBlocks()) {
            if (!c.isInstance(block)) continue;
            return true;
        }
        return false;
    }
}

