/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.chickens;

import com.animania.common.entities.EntityGender;
import com.animania.common.entities.amphibians.EntityAmphibian;
import com.animania.common.entities.amphibians.EntityFrogs;
import com.animania.common.entities.amphibians.EntityToad;
import com.animania.common.entities.chickens.EntityAnimaniaChicken;
import com.animania.common.entities.chickens.EntityChickBase;
import com.animania.common.entities.chickens.EntityRoosterBase;
import com.animania.common.entities.chickens.ai.EntityAIFindNest;
import com.animania.compat.top.providers.entity.TOPInfoProviderBase;
import com.animania.config.AnimaniaConfig;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityHenBase
extends EntityAnimaniaChicken
implements TOPInfoProviderBase {
    protected static final DataParameter<Boolean> LAID = EntityDataManager.func_187226_a(EntityHenBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> LAID_TIMER = EntityDataManager.func_187226_a(EntityHenBase.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityHenBase(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.7f);
        this.field_70130_N = 0.5f;
        this.field_70131_O = 0.7f;
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFindNest(this, 1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.2f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        if (AnimaniaConfig.gameRules.animalsCanAttackOthers) {
            this.field_70715_bh.func_75776_a(7, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityFrogs.class, false));
            this.field_70715_bh.func_75776_a(8, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityToad.class, false));
        }
        this.gender = EntityGender.FEMALE;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (this.field_70170_p.field_72995_K) {
            return null;
        }
        List list = this.field_70170_p.field_72996_f;
        int currentCount = 0;
        int num = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof EntityAnimaniaChicken)) continue;
            ++num;
        }
        currentCount = num;
        if (currentCount <= AnimaniaConfig.spawn.spawnLimitChickens) {
            int chooser = this.field_70146_Z.nextInt(5);
            if (chooser == 0) {
                EntityRoosterBase entityChicken = this.type.getMale(this.field_70170_p);
                entityChicken.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)entityChicken);
            } else if (chooser == 1 && !AnimaniaConfig.careAndFeeding.manualBreeding) {
                EntityChickBase entityChicken = this.type.getChild(this.field_70170_p);
                entityChicken.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)entityChicken);
            } else if (chooser > 2) {
                EntityRoosterBase entityChicken = this.type.getMale(this.field_70170_p);
                entityChicken.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)entityChicken);
                if (!AnimaniaConfig.careAndFeeding.manualBreeding) {
                    EntityChickBase entityChick = this.type.getChild(this.field_70170_p);
                    entityChick.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)entityChick);
                }
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextGaussian() * 0.05, 1));
        if (this.field_70146_Z.nextFloat() < 0.05f) {
            this.func_184641_n(true);
        } else {
            this.func_184641_n(false);
        }
        return livingdata;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        if (this.getSleeping()) {
            this.setSleeping(false);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 2.0f)) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        if (entityIn instanceof EntityAmphibian) {
            this.setFed(true);
        }
        if (entityIn instanceof EntityPlayer) {
            ((EntityLivingBase)entityIn).func_70653_a((Entity)this, 1.0f, this.field_70165_t - entityIn.field_70165_t, this.field_70161_v - entityIn.field_70161_v);
        }
        return flag;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.5);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LAID, (Object)true);
        this.field_70180_af.func_187214_a(LAID_TIMER, (Object)(AnimaniaConfig.careAndFeeding.laidTimer / 2 + 0 + this.field_70146_Z.nextInt(100)));
        this.field_70887_j = 6000;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Laid", this.getLaid());
        nbttagcompound.func_74768_a("EggLayTime", this.field_70887_j);
        nbttagcompound.func_74768_a("LaidTimer", this.getLaidTimer());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.field_70887_j = nbttagcompound.func_74762_e("EggLayTime");
        this.setLaid(nbttagcompound.func_74767_n("Laid"));
        this.setLaidTimer(nbttagcompound.func_74762_e("LaidTimer"));
    }

    public int getLaidTimer() {
        try {
            return this.getIntFromDataManager(LAID_TIMER);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setLaidTimer(int laidtimer) {
        this.field_70180_af.func_187227_b(LAID_TIMER, (Object)laidtimer);
    }

    @Override
    public void func_70636_d() {
        if (!AnimaniaConfig.gameRules.chickensDropEggs) {
            this.field_70887_j = 1000;
        }
        super.func_70636_d();
        int laidTimer = this.getLaidTimer();
        if (laidTimer > -1) {
            this.setLaidTimer(--laidTimer);
        } else {
            this.setLaid(false);
        }
    }

    public boolean getLaid() {
        try {
            return this.getBoolFromDataManager(LAID);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setLaid(boolean laid) {
        if (laid) {
            this.field_70180_af.func_187227_b(LAID, (Object)true);
            this.setLaidTimer(AnimaniaConfig.careAndFeeding.laidTimer + this.field_70146_Z.nextInt(100));
        } else {
            this.field_70180_af.func_187227_b(LAID, (Object)false);
        }
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP() - 0.3f, this.func_70647_i());
        }
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        if (player.func_70093_af()) {
            EntityHenBase ehb = (EntityHenBase)entity;
            int timer = ehb.getLaidTimer();
            if (timer >= 0) {
                probeInfo.text(I18n.func_74838_a((String)"text.waila.egglay") + ": " + timer);
            } else {
                probeInfo.text(I18n.func_74838_a((String)"text.waila.egglay2"));
            }
        }
        TOPInfoProviderBase.super.addProbeInfo(mode, probeInfo, player, world, entity, data);
    }
}

