/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.chickens;

import com.animania.common.ModSoundEvents;
import com.animania.common.entities.EntityGender;
import com.animania.common.entities.chickens.ChickenType;
import com.animania.common.entities.chickens.EntityAnimaniaChicken;
import com.animania.common.entities.chickens.EntityHenBase;
import com.animania.common.entities.chickens.EntityRoosterBase;
import com.animania.compat.top.providers.entity.TOPInfoProviderBase;
import com.animania.config.AnimaniaConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityChickBase
extends EntityAnimaniaChicken
implements TOPInfoProviderBase {
    protected static final DataParameter<Float> AGE = EntityDataManager.func_187226_a(EntityChickBase.class, (DataSerializer)DataSerializers.field_187193_c);
    protected int ageTimer;

    public EntityChickBase(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 0.8f);
        this.field_70130_N = 0.7f;
        this.field_70131_O = 0.8f;
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.ageTimer = 0;
        this.type = ChickenType.LEGHORN;
        this.gender = EntityGender.CHILD;
    }

    public boolean func_70631_g_() {
        return true;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return null;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AGE, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74776_a("Age", this.getEntityAge());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setEntityAge(nbttagcompound.func_74760_g("Age"));
    }

    @Override
    public void func_70636_d() {
        this.field_70887_j = 1000;
        boolean fed = this.getFed();
        boolean watered = this.getWatered();
        this.field_175504_a = -24000;
        ++this.ageTimer;
        if (this.ageTimer >= AnimaniaConfig.careAndFeeding.childGrowthTick && fed && watered) {
            this.ageTimer = 0;
            float age = this.getEntityAge();
            this.setEntityAge(age += 0.01f);
            if ((double)age >= 0.4 && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
                if (this.field_70146_Z.nextInt(2) < 1) {
                    EntityHenBase entityHen = this.type.getFemale(this.field_70170_p);
                    if (entityHen != null) {
                        entityHen.func_70107_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
                        String name = this.func_95999_t();
                        if (name != "") {
                            entityHen.func_96094_a(name);
                        }
                        entityHen.setAge(1);
                        this.field_70170_p.func_72838_d((Entity)entityHen);
                        this.func_184185_a(ModSoundEvents.chickenHurt1, 0.5f, 1.1f);
                    }
                } else {
                    EntityRoosterBase entityRooster = this.type.getMale(this.field_70170_p);
                    if (entityRooster != null) {
                        entityRooster.func_70107_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
                        String name = this.func_95999_t();
                        if (name != "") {
                            entityRooster.func_96094_a(name);
                        }
                        entityRooster.setAge(1);
                        this.field_70170_p.func_72838_d((Entity)entityRooster);
                        this.func_184185_a(ModSoundEvents.chickenCrow1, 0.5f, 1.1f);
                    }
                }
            }
        }
        super.func_70636_d();
    }

    public float getEntityAge() {
        try {
            return this.getFloatFromDataManager(AGE);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public void setEntityAge(float age) {
        this.field_70180_af.func_187227_b(AGE, (Object)Float.valueOf(age));
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP() - 0.3f, this.func_70647_i() + 0.9f - this.getEntityAge() * 2.0f);
        }
    }

    protected void func_70628_a(boolean hit, int lootlevel) {
    }

    protected Item func_146068_u() {
        return null;
    }
}

