/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.blocks;

import com.animania.Animania;
import com.animania.common.ModSoundEvents;
import com.animania.common.entities.chickens.ChickenType;
import com.animania.common.entities.chickens.EntityAnimaniaChicken;
import com.animania.common.entities.chickens.EntityRoosterBase;
import com.animania.common.entities.peacocks.EntityAnimaniaPeacock;
import com.animania.common.entities.peacocks.EntityPeacockBase;
import com.animania.common.entities.peacocks.PeacockType;
import com.animania.common.handler.BlockHandler;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.tileentities.TileEntityNest;
import com.animania.compat.top.providers.TOPInfoProvider;
import com.animania.compat.top.providers.entity.TOPInfoProviderBase;
import com.animania.config.AnimaniaConfig;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockNest
extends BlockContainer
implements TOPInfoProvider {
    private String name = "block_nest";
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3, 1.0);

    public BlockNest() {
        super(Material.field_151575_d);
        this.setRegistryName(new ResourceLocation("animania", this.name));
        BlockHandler.blocks.add((Block)this);
        this.func_149663_c("animania_" + this.name);
        this.func_149647_a(Animania.TabAnimaniaResources);
        this.func_149675_a(true);
    }

    public int func_149738_a(World worldIn) {
        return 5;
    }

    public String func_149732_F() {
        return I18n.func_74838_a((String)"tile.animania_block_nest.name");
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        TileEntityNest te = (TileEntityNest)worldIn.func_175625_s(pos);
        if (te != null && te.getNestContent() != TileEntityNest.NestContent.EMPTY) {
            List<EntityAnimaniaPeacock> nearbyPeacocks;
            TOPInfoProviderBase chick;
            Enum chickType;
            Enum birdType;
            List<EntityAnimaniaChicken> nearbyChickens;
            List<EntityRoosterBase> roosters = AnimaniaHelper.getEntitiesInRange(EntityRoosterBase.class, 3.0, worldIn, pos);
            List<EntityPeacockBase> peacocks = AnimaniaHelper.getEntitiesInRange(EntityPeacockBase.class, 3.0, worldIn, pos);
            if (te.getBirdType() instanceof ChickenType && (nearbyChickens = AnimaniaHelper.getEntitiesInRange(EntityAnimaniaChicken.class, 15.0, worldIn, pos)).size() < AnimaniaConfig.careAndFeeding.entityBreedingLimit) {
                birdType = (ChickenType)te.getBirdType();
                for (EntityRoosterBase rooster : roosters) {
                    if (rand.nextInt(AnimaniaConfig.careAndFeeding.eggHatchChance) >= 1) continue;
                    chickType = ChickenType.breed(rooster.type, birdType);
                    chick = ((ChickenType)chickType).getChild(worldIn);
                    ((EntityAnimaniaChicken)((Object)chick)).func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.2, (double)pos.func_177952_p() + 0.5);
                    worldIn.func_72838_d((Entity)chick);
                    ((EntityAnimaniaChicken)((Object)chick)).func_184185_a(ModSoundEvents.chickenCluck1, 0.5f, 1.4f);
                    te.removeItem();
                    te.func_70296_d();
                    break;
                }
            }
            if (te.getBirdType() instanceof PeacockType && (nearbyPeacocks = AnimaniaHelper.getEntitiesInRange(EntityAnimaniaPeacock.class, 15.0, worldIn, pos)).size() < AnimaniaConfig.careAndFeeding.entityBreedingLimit) {
                birdType = (PeacockType)te.getBirdType();
                for (EntityPeacockBase peacock : peacocks) {
                    if (rand.nextInt(AnimaniaConfig.careAndFeeding.eggHatchChance) >= 1) continue;
                    chickType = PeacockType.breed(peacock.type, (PeacockType)birdType);
                    chick = ((PeacockType)chickType).getChild(worldIn);
                    ((EntityAnimaniaPeacock)chick).func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.2, (double)pos.func_177952_p() + 0.5);
                    worldIn.func_72838_d((Entity)chick);
                    chick.func_184185_a(ModSoundEvents.peacock1, 0.5f, 1.4f);
                    te.removeItem();
                    te.func_70296_d();
                    break;
                }
            }
        }
    }

    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityNest();
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(BlockHandler.blockNest, 1);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityNest te = (TileEntityNest)worldIn.func_175625_s(pos);
        if (te != null) {
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)te.itemHandler.getStackInSlot(0));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)BlockHandler.blockNest);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        TileEntityNest te = (TileEntityNest)worldIn.func_175625_s(pos);
        if (te != null && heldItem.func_190926_b() && !playerIn.func_70093_af()) {
            ItemStack stack = te.itemHandler.extractItem(0, 1, false);
            AnimaniaHelper.addItem(playerIn, stack);
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof TileEntityNest) {
            TileEntityNest nest = (TileEntityNest)te;
            ItemStack stack = nest.itemHandler.getStackInSlot(0);
            if (mode == ProbeMode.NORMAL && !stack.func_190926_b()) {
                probeInfo.horizontal();
                probeInfo.item(stack);
                if (nest.birdType != null) {
                    probeInfo.text("From: " + nest.birdType.toString().substring(0, 1).toUpperCase() + nest.birdType.toString().substring(1).toLowerCase());
                }
            }
        }
    }
}

