/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.blocks;

import com.animania.Animania;
import com.animania.common.handler.BlockHandler;
import com.animania.config.AnimaniaConfig;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockCheese
extends Block {
    public static final PropertyInteger BITES = PropertyInteger.func_177719_a((String)"bites", (int)0, (int)3);
    private static final AxisAlignedBB[] AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.5, 0.9375), new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.5, 0.9375), new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.5, 0.5), new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.5, 0.5, 0.5)};

    public BlockCheese(String name) {
        super(Material.field_151568_F, MapColor.field_151673_t);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(0)));
        this.setRegistryName("animania:" + name);
        this.func_149663_c("animania_" + name);
        this.func_149647_a(Animania.TabAnimaniaResources);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149711_c(0.6f);
        BlockHandler.blocks.add(this);
        ItemBlock item = new ItemBlock((Block)this);
        item.setRegistryName(new ResourceLocation("animania", name.substring(7) + "_cheese_wheel"));
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        this.func_149675_a(true);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return state == this.func_176223_P() ? 1 : 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB[(Integer)state.func_177229_b((IProperty)BITES)];
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            return this.eatCheese(worldIn, pos, state, playerIn);
        }
        ItemStack itemstack = playerIn.func_184586_b(hand);
        return this.eatCheese(worldIn, pos, state, playerIn) || itemstack.func_190926_b();
    }

    private boolean eatCheese(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!player.func_71043_e(false)) {
            return false;
        }
        if (!worldIn.field_72995_K && AnimaniaConfig.gameRules.foodsGiveBonusEffects) {
            if (this == BlockHandler.blockCheeseFriesian) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76432_h, 6, 2, false, false));
            } else if (this == BlockHandler.blockCheeseGoat) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 1200, 0, false, false));
            } else if (this == BlockHandler.blockCheeseSheep) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76432_h, 10, 0, false, false));
            } else {
                player.func_70690_d(new PotionEffect(MobEffects.field_76432_h, 12, 2, false, false));
            }
        }
        player.func_71024_bL().func_75122_a(2, 1.2f);
        int i = (Integer)state.func_177229_b((IProperty)BITES);
        if (i < 3) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            worldIn.func_175698_g(pos);
        }
        return true;
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BITES);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BITES});
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return 4 - (Integer)blockState.func_177229_b((IProperty)BITES);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) ? this.canBlockStay(worldIn, pos) : false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            worldIn.func_175698_g(pos);
        }
    }

    private boolean canBlockStay(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a();
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(meta));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

