/*
 * Decompiled with CFR 0.152.
 */
package javapower.storagetech.util;

import javapower.storagetech.util.EScreenAnchor;
import javapower.storagetech.util.Vector2;
import javapower.storagetech.util.VectorScreen;

public class VectorDynamic2 {
    public VectorScreen screen;
    EScreenAnchor anchor;
    Vector2 vector;
    public Vector2 pos;

    public VectorDynamic2(VectorScreen _screen, EScreenAnchor _anchor, Vector2 _vector) {
        this.screen = _screen;
        this.anchor = _anchor;
        this.vector = _vector;
        this.reCalculate();
    }

    public void reCalculate() {
        this.pos = this.calculate();
    }

    private Vector2 calculate() {
        switch (this.anchor) {
            case TOP_LEFT: {
                return this.vector.copy();
            }
            case TOP_MIDDLE: {
                return this.vector.copyAndAdd(this.screen.screensize.x / 2, 0);
            }
            case TOP_RIGHT: {
                return this.vector.copyAndAdd(this.screen.screensize.x, 0);
            }
            case MIDDLE_LEFT: {
                return this.vector.copyAndAdd(0, this.screen.screensize.y / 2);
            }
            case MIDDLE: {
                return this.vector.copyAndAdd(this.screen.screensize.x / 2, this.screen.screensize.y / 2);
            }
            case MIDDLE_RIGHT: {
                return this.vector.copyAndAdd(this.screen.screensize.x, this.screen.screensize.y / 2);
            }
            case BOTTOM_LEFT: {
                return this.vector.copyAndAdd(0, this.screen.screensize.y);
            }
            case BOTTOM_MIDDLE: {
                return this.vector.copyAndAdd(this.screen.screensize.x / 2, this.screen.screensize.y);
            }
            case BOTTOM_RIGHT: {
                return this.vector.copyAndAdd(this.screen.screensize.x, this.screen.screensize.y);
            }
        }
        return this.vector.copy();
    }

    public Vector2 getPos() {
        return this.pos;
    }

    public void setAnchor(EScreenAnchor _anchor) {
        this.anchor = _anchor;
        this.reCalculate();
    }

    public void setVector(Vector2 _vector) {
        this.vector = _vector;
        this.reCalculate();
    }

    public void setScreen(VectorScreen _screen) {
        this.screen = _screen;
        this.reCalculate();
    }
}

