/*
 * Decompiled with CFR 0.152.
 */
package javapower.storagetech.tileentity;

import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.UUID;
import javapower.storagetech.core.Config;
import javapower.storagetech.eventio.IEventVoid;
import javapower.storagetech.item.STItems;
import javapower.storagetech.tileentity.TileEntitySynchronized;
import javapower.storagetech.util.DiskUtils;
import javapower.storagetech.util.EnergyBuffer;
import javapower.storagetech.util.Tools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;

public class TileEntityFluidDiskWorkbench
extends TileEntitySynchronized
implements IInventory {
    public long memory = 0L;
    boolean update = true;
    public NonNullList<ItemStack> block_inv_content = NonNullList.func_191197_a((int)7, (Object)ItemStack.field_190927_a);
    public EnergyBuffer energyBuffer = new EnergyBuffer(25600000, 25600000, 0);
    public boolean prosses = false;
    public int time = 0;
    public int createProsses = 0;
    public int diskSize = 0;

    public TileEntityFluidDiskWorkbench() {
        this.energyBuffer.eventchange = new IEventVoid(){

            @Override
            public void event() {
                TileEntityFluidDiskWorkbench.this.update = true;
                TileEntityFluidDiskWorkbench.this.func_70296_d();
            }
        };
    }

    public void update_prosses() {
        if (this.prosses) {
            if (this.createProsses >= this.diskSize || !Config.EnableCostDisk) {
                ItemStack itemstack_diskcustom = new ItemStack(STItems.item_fluiddiskcustom);
                itemstack_diskcustom.func_77973_b().func_77622_d(itemstack_diskcustom, this.field_145850_b, null);
                NBTTagCompound nbtitemdisk = itemstack_diskcustom.func_77978_p();
                if (nbtitemdisk == null) {
                    nbtitemdisk = new NBTTagCompound();
                }
                nbtitemdisk.func_74768_a("st_cap", this.diskSize);
                UUID id = UUID.randomUUID();
                API.instance().getStorageDiskManager(this.field_145850_b).set(id, API.instance().createDefaultFluidDisk(this.field_145850_b, this.diskSize));
                API.instance().getStorageDiskManager(this.field_145850_b).markForSaving();
                nbtitemdisk.func_186854_a("Id", id);
                itemstack_diskcustom.func_77982_d(nbtitemdisk);
                this.block_inv_content.set(2, (Object)itemstack_diskcustom);
                this.prosses = false;
                this.update = true;
                this.func_70296_d();
            } else if (this.time > Config.TimeCostPerSize) {
                if (this.energyBuffer.energy >= Config.EnergyCostPerSize + this.countUpgrade()) {
                    this.time = 0;
                    this.createProsses += Config.ProssesAdvancementSizeFluid * this.countUpgrade();
                    this.energyBuffer.energy -= Config.EnergyCostPerSize + this.countUpgrade();
                    this.update = true;
                    this.func_70296_d();
                }
            } else {
                ++this.time;
            }
        }
    }

    @Override
    public void reciveDataFromClient(NBTTagCompound nbt, EntityPlayer player) {
        if (nbt.func_74764_b("up")) {
            this.update = true;
        }
        if (nbt.func_74764_b("startCreateDisk")) {
            int disksize = nbt.func_74762_e("startCreateDisk");
            ItemStack itemin = (ItemStack)this.block_inv_content.get(1);
            ItemStack itemout = (ItemStack)this.block_inv_content.get(2);
            if (itemout.func_190926_b() && !itemin.func_190926_b() && itemin.func_190916_E() > 0 && disksize > 0 && (long)disksize <= this.memory && !this.prosses) {
                this.time = 0;
                this.createProsses = 0;
                this.diskSize = disksize;
                this.prosses = true;
                this.memory -= (long)disksize;
                this.update = true;
                this.func_70296_d();
                if (itemin.func_190916_E() == 1) {
                    this.block_inv_content.set(1, (Object)ItemStack.field_190927_a);
                } else {
                    itemin.func_190920_e(itemin.func_190916_E() - 1);
                }
            }
        }
    }

    @Override
    public void onPlayerOpenGUISendData(NBTTagCompound nbt, EntityPlayer player) {
        nbt.func_74772_a("memory", this.memory);
        nbt.func_74768_a("max", Math.min(Config.DiskMaxSize, Tools.limiteLTI(this.memory)));
        nbt.func_74757_a("prosses", this.prosses);
        nbt.func_74776_a("prossestime", (float)this.createProsses / (float)this.diskSize);
        nbt.func_74768_a("energy", this.energyBuffer.energy);
        nbt.func_74768_a("capacity", this.energyBuffer.capacity);
        nbt.func_74757_a("encd", Config.EnableCostDisk);
        nbt.func_74768_a("cost", Config.EnergyCostPerSize + this.countUpgrade());
    }

    @Override
    public NBTTagCompound updateData() {
        if (this.update) {
            this.update = false;
            NBTTagCompound nbt_update = new NBTTagCompound();
            nbt_update.func_74772_a("memory", this.memory);
            nbt_update.func_74768_a("max", Math.min(Config.DiskMaxSize, Tools.limiteLTI(this.memory)));
            nbt_update.func_74757_a("prosses", this.prosses);
            nbt_update.func_74776_a("prossestime", (float)this.createProsses / (float)this.diskSize);
            nbt_update.func_74768_a("energy", this.energyBuffer.energy);
            nbt_update.func_74768_a("capacity", this.energyBuffer.capacity);
            nbt_update.func_74757_a("encd", Config.EnableCostDisk);
            nbt_update.func_74768_a("cost", Config.EnergyCostPerSize + this.countUpgrade());
            return nbt_update;
        }
        return null;
    }

    @Override
    public void read(NBTTagCompound tag) {
        if (tag.func_74764_b("memory")) {
            this.memory = tag.func_74763_f("memory");
        }
        if (tag.func_74764_b("inv")) {
            ItemStackHelper.func_191283_b((NBTTagCompound)tag.func_74775_l("inv"), this.block_inv_content);
        }
        this.energyBuffer.ReadFromNBT(tag);
        if (tag.func_74764_b("prosses")) {
            this.prosses = tag.func_74767_n("prosses");
        }
        if (tag.func_74764_b("time")) {
            this.time = tag.func_74762_e("time");
        }
        if (tag.func_74764_b("createprosses")) {
            this.createProsses = tag.func_74762_e("createprosses");
        }
        if (tag.func_74764_b("disksize")) {
            this.diskSize = tag.func_74762_e("disksize");
        }
        this.func_70296_d();
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        tag.func_74772_a("memory", this.memory);
        NBTTagCompound nbt_inv = new NBTTagCompound();
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt_inv, this.block_inv_content);
        tag.func_74782_a("inv", (NBTBase)nbt_inv);
        this.energyBuffer.WriteToNBT(tag);
        tag.func_74757_a("prosses", this.prosses);
        tag.func_74768_a("time", this.time);
        tag.func_74768_a("createprosses", this.createProsses);
        tag.func_74768_a("disksize", this.diskSize);
        return tag;
    }

    @Override
    public void func_73660_a() {
        ItemStack i = (ItemStack)this.block_inv_content.get(0);
        if (!i.func_190926_b() && DiskUtils.validFluidDisk(i)) {
            long memadd = DiskUtils.getMemoryFromFluidDisk(i);
            this.memory += memadd;
            this.update = true;
            this.block_inv_content.set(0, (Object)ItemStack.field_190927_a);
            this.func_70296_d();
        }
        if (!this.field_145850_b.field_72995_K) {
            this.update_prosses();
        }
        super.func_73660_a();
    }

    public int countUpgrade() {
        int u = 1;
        if (!((ItemStack)this.block_inv_content.get(3)).func_190926_b()) {
            u *= 4;
        }
        if (!((ItemStack)this.block_inv_content.get(4)).func_190926_b()) {
            u *= 4;
        }
        if (!((ItemStack)this.block_inv_content.get(5)).func_190926_b()) {
            u *= 4;
        }
        if (!((ItemStack)this.block_inv_content.get(6)).func_190926_b()) {
            u *= 4;
        }
        return u;
    }

    public String func_70005_c_() {
        return "fluiddiskWB";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return this.block_inv_content.size();
    }

    public boolean func_191420_l() {
        for (ItemStack is : this.block_inv_content) {
            if (is.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        if (index < this.block_inv_content.size()) {
            return (ItemStack)this.block_inv_content.get(index);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.block_inv_content, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.block_inv_content, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.block_inv_content.set(index, (Object)stack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index >= 2 && index <= 6) {
            return false;
        }
        if (index == 0) {
            return DiskUtils.validFluidDisk(stack);
        }
        return stack.func_185136_b(new ItemStack((Item)RSItems.STORAGE_HOUSING));
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.block_inv_content.clear();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energyBuffer;
        }
        return (T)super.getCapability(capability, facing);
    }
}

