/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.entity;

import com.google.common.collect.ImmutableMap;
import com.rwtema.careerbees.BeeMod;
import com.rwtema.careerbees.bees.CareerBeeEntry;
import com.rwtema.careerbees.bees.SpecialProperties;
import com.rwtema.careerbees.entity.BeeEntry;
import com.rwtema.careerbees.entity.ChunkDataModuleManager;
import com.rwtema.careerbees.entity.EntityChunkData;
import com.rwtema.careerbees.helpers.NBTHelper;
import com.rwtema.careerbees.helpers.ParticleHelper;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class PlacedBeeManager<B extends BeeEntry>
extends ChunkDataModuleManager<Map<BlockPos, B>> {
    final CareerBeeEntry species;
    IBeeGenome genome;
    private final Set<EntityPlayer> playerServer;
    private final Set<EntityPlayer> playerClient;

    protected PlacedBeeManager(CareerBeeEntry species) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.playerServer = Collections.newSetFromMap(new WeakHashMap());
        this.playerClient = Collections.newSetFromMap(new WeakHashMap());
        this.species = species;
    }

    @SubscribeEvent
    public void onRightClick(@Nonnull PlayerInteractEvent.RightClickBlock event) {
        if (!event.getEntityPlayer().func_70093_af()) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        BlockPos pos = event.getPos();
        IBee bee = BeeManager.beeRoot.getMember(itemStack);
        if (bee == null) {
            return;
        }
        if (!this.isValidBeeType(BeeManager.beeRoot.getType(itemStack), bee.getGenome().getPrimary(), bee.getGenome().getSecondary())) {
            return;
        }
        TileEntity tileEntity = event.getWorld().func_175625_s(pos);
        if (!(tileEntity instanceof IBeeHousing)) {
            return;
        }
        Chunk chunk = event.getWorld().func_175726_f(pos);
        Map chunkData = (Map)EntityChunkData.getChunkData(chunk, this, true);
        if (chunkData.get(pos) != null) {
            return;
        }
        event.setCanceled(true);
        if (this.hasPlayerRightClickedAlready(event)) {
            return;
        }
        if (!event.getWorld().field_72995_K) {
            B value = this.createEntry((IBeeHousing)tileEntity, itemStack.func_77979_a(1).func_77955_b(new NBTTagCompound()));
            chunkData.put(pos, value);
            EntityChunkData.markChunkDirty(chunk);
            this.onPlaced(event.getEntityPlayer());
        }
    }

    protected boolean hasPlayerRightClickedAlready(@Nonnull PlayerInteractEvent.RightClickBlock event) {
        return !(event.getWorld().field_72995_K ? this.playerClient : this.playerServer).add(event.getEntityPlayer());
    }

    protected abstract boolean isValidBeeType(EnumBeeType var1, IAlleleBeeSpecies var2, IAlleleBeeSpecies var3);

    protected abstract void onPlaced(EntityPlayer var1);

    @Nonnull
    protected abstract B createEntry(IBeeHousing var1, NBTTagCompound var2);

    @Override
    public Map<BlockPos, B> getCachedBlank() {
        return ImmutableMap.of();
    }

    @Override
    @Nonnull
    public Map<BlockPos, B> createBlank() {
        return new HashMap();
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound base, @Nonnull Map<BlockPos, B> blockPosBeeEntryMap) {
        NBTTagList list = blockPosBeeEntryMap.entrySet().stream().map(e -> NBTHelper.builder().setLong("pos", ((BlockPos)e.getKey()).func_177986_g()).setTag("genome", (NBTBase)((BeeEntry)e.getValue()).tag).build()).collect(NBTHelper.toNBTTagList());
        base.func_74782_a("list", (NBTBase)list);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientTick(@Nonnull Chunk chunk, @Nonnull Map<BlockPos, B> blockPosStudentBeeEntryMap) {
        this.playerClient.clear();
        Random rand = chunk.func_177412_p().field_73012_v;
        for (Map.Entry<BlockPos, B> entry : blockPosStudentBeeEntryMap.entrySet()) {
            BlockPos pos = entry.getKey();
            TileEntity tileEntity = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
            if (!(tileEntity instanceof IBeeHousing)) continue;
            this.tickClient(chunk, rand, entry, pos, tileEntity, (IBeeHousing)tileEntity);
            if (rand.nextInt(256) != 0) continue;
            if (this.genome == null || !BeeMod.deobf_folder) {
                IAllele[] template = BeeManager.beeRoot.getTemplate((IAlleleSpecies)this.species.get());
                template[EnumBeeChromosome.TERRITORY.ordinal()] = SpecialProperties.AGORAPHOBIC;
                this.genome = BeeManager.beeRoot.templateAsGenome(template);
            }
            ParticleHelper.BEE_HIVE_FX.addBeeHiveFX((IBeeHousing)tileEntity, this.genome, Stream.of(EnumFacing.values()).map(arg_0 -> ((BlockPos)entry.getKey()).func_177972_a(arg_0)).collect(Collectors.toList()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void tickClient(Chunk chunk, Random rand, Map.Entry<BlockPos, B> entry, BlockPos pos, TileEntity tileEntity, IBeeHousing entity) {
    }

    @Override
    @Nonnull
    public Map<BlockPos, B> readFromNBT(@Nonnull NBTTagCompound tag) {
        Object objectObjectHashMap = this.createBlank();
        NBTHelper.wrapList(tag.func_150295_c("list", 10)).stream().filter(Objects::nonNull).forEach(arg_0 -> this.lambda$readFromNBT$1((Map)objectObjectHashMap, arg_0));
        return objectObjectHashMap;
    }

    @Nonnull
    protected abstract B recreateBeeEntry(NBTTagCompound var1);

    @Override
    public void writeData(@Nonnull Map<BlockPos, B> value, @Nonnull PacketBuffer buffer) {
        buffer.func_150787_b(value.size());
        value.entrySet().forEach(t -> {
            buffer.writeLong(((BlockPos)t.getKey()).func_177986_g());
            buffer.writeByte(0);
            ((BeeEntry)t.getValue()).write(buffer);
        });
    }

    @Override
    public boolean onUpdate(@Nonnull Chunk chunk, @Nonnull Map<BlockPos, B> blockPosBeeEntryMap) {
        this.playerServer.clear();
        blockPosBeeEntryMap.entrySet().removeIf(k -> {
            BlockPos pos = (BlockPos)k.getKey();
            TileEntity tileEntity = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
            if (tileEntity instanceof IBeeHousing) {
                return this.updateTile(chunk, (Map.Entry<BlockPos, B>)k, (IBeeHousing)tileEntity, tileEntity);
            }
            NBTTagCompound tag = ((BeeEntry)k.getValue()).tag;
            if (tag != null) {
                World world = chunk.func_177412_p();
                double d0 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
                double d1 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
                double d2 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
                EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, new ItemStack(tag));
                entityitem.func_174869_p();
                world.func_72838_d((Entity)entityitem);
                EntityChunkData.markChunkDirty(chunk);
            }
            return true;
        });
        return blockPosBeeEntryMap.isEmpty();
    }

    protected abstract boolean updateTile(Chunk var1, Map.Entry<BlockPos, B> var2, IBeeHousing var3, TileEntity var4);

    @Override
    public void readData(@Nonnull Map<BlockPos, B> value, @Nonnull PacketBuffer buffer) {
        value.clear();
        try {
            int n = buffer.func_150792_a();
            for (int i = 0; i < n; ++i) {
                BlockPos key = BlockPos.func_177969_a((long)buffer.readLong());
                NBTTagCompound tag = buffer.func_150793_b();
                B beeEntry = this.recreateBeeEntry(tag);
                ((BeeEntry)beeEntry).read(buffer);
                value.put(key, beeEntry);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private /* synthetic */ void lambda$readFromNBT$1(Map objectObjectHashMap, NBTTagCompound e) {
        BeeEntry cfr_ignored_0 = (BeeEntry)objectObjectHashMap.put(BlockPos.func_177969_a((long)e.func_74763_f("pos")), this.recreateBeeEntry(e.func_74775_l("genome")));
    }
}

