/*
 * Decompiled with CFR 0.152.
 */
package fluke.worleycaves.world;

import com.google.common.base.MoreObjects;
import fluke.worleycaves.Main;
import fluke.worleycaves.config.Configs;
import fluke.worleycaves.util.BlockUtil;
import fluke.worleycaves.util.FastNoise;
import fluke.worleycaves.util.WorleyUtil;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.Loader;

public class WorleyCaveGenerator
extends MapGenCaves {
    long[] genTime = new long[300];
    int currentTimeIndex = 0;
    double sum = 0.0;
    private WorleyUtil worleyF1divF3 = new WorleyUtil();
    private FastNoise displacementNoisePerlin = new FastNoise();
    private MapGenBase replacementCaves;
    private MapGenBase moddedCaveGen;
    private static IBlockState lava;
    private static final IBlockState AIR;
    private static int maxCaveHeight;
    private static int minCaveHeight;
    private static float noiseCutoff;
    private static float warpAmplifier;
    private static float easeInDepth;
    private static float yCompression;
    private static float xzCompression;
    private static float surfaceCutoff;
    private static int lavaDepth;
    private static boolean additionalWaterChecks;

    public WorleyCaveGenerator() {
        this.worleyF1divF3.SetFrequency(0.016f);
        this.displacementNoisePerlin.SetNoiseType(FastNoise.NoiseType.Perlin);
        this.displacementNoisePerlin.SetFrequency(0.05f);
        maxCaveHeight = Configs.cavegen.maxCaveHeight;
        minCaveHeight = Configs.cavegen.minCaveHeight;
        noiseCutoff = (float)Configs.cavegen.noiseCutoffValue;
        warpAmplifier = (float)Configs.cavegen.warpAmplifier;
        easeInDepth = Configs.cavegen.easeInDepth;
        yCompression = (float)Configs.cavegen.verticalCompressionMultiplier;
        xzCompression = (float)Configs.cavegen.horizonalCompressionMultiplier;
        surfaceCutoff = (float)Configs.cavegen.surfaceCutoffValue;
        lavaDepth = Configs.cavegen.lavaDepth;
        additionalWaterChecks = Loader.isModLoaded((String)"subterranaenwaters");
        lava = BlockUtil.getStateFromString(Configs.cavegen.lavaBlock);
        if (lava == null) {
            Main.LOGGER.error("Cannont find block " + Configs.cavegen.lavaBlock);
            lava = AIR;
        }
        this.moddedCaveGen = TerrainGen.getModdedMapGen((MapGenBase)this, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.replacementCaves = this.moddedCaveGen != this ? this.moddedCaveGen : new MapGenCaves();
    }

    private void debugValueAdjustments() {
    }

    public void func_186125_a(World worldIn, int x, int z, ChunkPrimer primer) {
        int currentDim = worldIn.field_73011_w.getDimension();
        this.field_75039_c = worldIn;
        for (int blacklistedDim : Configs.cavegen.blackListedDims) {
            if (currentDim != blacklistedDim) continue;
            this.replacementCaves.func_186125_a(worldIn, x, z, primer);
            return;
        }
        this.debugValueAdjustments();
        boolean logTime = false;
        long millis = 0L;
        if (logTime) {
            millis = System.currentTimeMillis();
        }
        this.field_75039_c = worldIn;
        this.generateWorleyCaves(worldIn, x, z, primer);
        if (logTime) {
            this.genTime[this.currentTimeIndex] = System.currentTimeMillis() - millis;
            this.sum += (double)this.genTime[this.currentTimeIndex];
            ++this.currentTimeIndex;
            if (this.currentTimeIndex == this.genTime.length) {
                System.out.printf("300 chunk average: %.2f ms per chunk\n", this.sum / 300.0);
                this.sum = 0.0;
                this.currentTimeIndex = 0;
            }
        }
    }

    protected void generateWorleyCaves(World worldIn, int chunkX, int chunkZ, ChunkPrimer chunkPrimerIn) {
        int chunkMaxHeight = this.getMaxSurfaceHeight(chunkPrimerIn);
        int seaLevel = worldIn.func_181545_F();
        float[][][] samples = this.sampleNoise(chunkX, chunkZ, chunkMaxHeight + 1);
        float oneQuarter = 0.25f;
        float oneHalf = 0.5f;
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                int depth = 0;
                for (int y = maxCaveHeight / 2 - 1; y >= 0; --y) {
                    float x0y0z0 = samples[x][y][z];
                    float x0y0z1 = samples[x][y][z + 1];
                    float x1y0z0 = samples[x + 1][y][z];
                    float x1y0z1 = samples[x + 1][y][z + 1];
                    float x0y1z0 = samples[x][y + 1][z];
                    float x0y1z1 = samples[x][y + 1][z + 1];
                    float x1y1z0 = samples[x + 1][y + 1][z];
                    float x1y1z1 = samples[x + 1][y + 1][z + 1];
                    float noiseStepY00 = (x0y1z0 - x0y0z0) * -oneHalf;
                    float noiseStepY01 = (x0y1z1 - x0y0z1) * -oneHalf;
                    float noiseStepY10 = (x1y1z0 - x1y0z0) * -oneHalf;
                    float noiseStepY11 = (x1y1z1 - x1y0z1) * -oneHalf;
                    float noiseStartX0 = x0y0z0;
                    float noiseStartX1 = x0y0z1;
                    float noiseEndX0 = x1y0z0;
                    float noiseEndX1 = x1y0z1;
                    for (int suby = 1; suby >= 0; --suby) {
                        int localY = suby + y * 2;
                        float noiseStartZ = noiseStartX0;
                        float noiseEndZ = noiseStartX1;
                        float noiseStepX0 = (noiseEndX0 - noiseStartX0) * oneQuarter;
                        float noiseStepX1 = (noiseEndX1 - noiseStartX1) * oneQuarter;
                        for (int subx = 0; subx < 4; ++subx) {
                            int localX = subx + x * 4;
                            int realX = localX + chunkX * 16;
                            float noiseStepZ = (noiseEndZ - noiseStartZ) * oneQuarter;
                            float noiseVal = noiseStartZ;
                            for (int subz = 0; subz < 4; ++subz) {
                                IBlockState aboveBlock;
                                int localZ = subz + z * 4;
                                int realZ = localZ + chunkZ * 16;
                                if (depth == 0) {
                                    if (subx != 0 || subz != 0) continue;
                                    IBlockState currentBlock = chunkPrimerIn.func_177856_a(localX, localY, localZ);
                                    if (this.func_175793_a(currentBlock, AIR) || this.isBiomeBlock(chunkPrimerIn, realX, realZ, currentBlock)) {
                                        ++depth;
                                    }
                                } else if (subx == 0 && subz == 0) {
                                    ++depth;
                                }
                                float adjustedNoiseCutoff = noiseCutoff;
                                if ((float)depth < easeInDepth) {
                                    adjustedNoiseCutoff = (float)MathHelper.func_151238_b((double)noiseCutoff, (double)surfaceCutoff, (double)((easeInDepth - (float)depth) / easeInDepth));
                                }
                                if (localY < minCaveHeight + 5) {
                                    adjustedNoiseCutoff = (float)((double)adjustedNoiseCutoff + (double)(minCaveHeight + 5 - localY) * 0.05);
                                }
                                if (noiseVal > adjustedNoiseCutoff && (aboveBlock = (IBlockState)MoreObjects.firstNonNull((Object)chunkPrimerIn.func_177856_a(localX, localY + 1, localZ), (Object)Blocks.field_150350_a.func_176223_P())).func_185904_a() != Material.field_151586_h) {
                                    if (((float)depth < easeInDepth || localY > seaLevel - 8 || additionalWaterChecks) && localY > lavaDepth && (localX < 15 && chunkPrimerIn.func_177856_a(localX + 1, localY, localZ).func_185904_a() == Material.field_151586_h || localX > 0 && chunkPrimerIn.func_177856_a(localX - 1, localY, localZ).func_185904_a() == Material.field_151586_h || localZ < 15 && chunkPrimerIn.func_177856_a(localX, localY, localZ + 1).func_185904_a() == Material.field_151586_h || localZ > 0 && chunkPrimerIn.func_177856_a(localX, localY, localZ - 1).func_185904_a() == Material.field_151586_h)) continue;
                                    IBlockState currentBlock = chunkPrimerIn.func_177856_a(localX, localY, localZ);
                                    boolean foundTopBlock = false;
                                    if (this.isTopBlock(chunkPrimerIn, localX, localY, localZ, chunkX, chunkZ)) {
                                        foundTopBlock = true;
                                    }
                                    this.digBlock(chunkPrimerIn, localX, localY, localZ, chunkX, chunkZ, foundTopBlock, currentBlock, aboveBlock);
                                }
                                noiseVal += noiseStepZ;
                            }
                            noiseStartZ += noiseStepX0;
                            noiseEndZ += noiseStepX1;
                        }
                        noiseStartX0 += noiseStepY00;
                        noiseStartX1 += noiseStepY01;
                        noiseEndX0 += noiseStepY10;
                        noiseEndX1 += noiseStepY11;
                    }
                }
            }
        }
    }

    public float[][][] sampleNoise(int chunkX, int chunkZ, int maxSurfaceHeight) {
        int originalMaxHeight = 128;
        float[][][] noiseSamples = new float[5][129][5];
        for (int x = 0; x < 5; ++x) {
            int realX = x * 4 + chunkX * 16;
            for (int z = 0; z < 5; ++z) {
                int realZ = z * 4 + chunkZ * 16;
                for (int y = 128; y >= 0; --y) {
                    float noiseTwoAbove;
                    float noise;
                    float realY = y * 2;
                    if (realY > (float)maxSurfaceHeight || realY > (float)maxCaveHeight || realY < (float)minCaveHeight) {
                        noiseSamples[x][y][z] = -1.1f;
                        continue;
                    }
                    float dispAmp = (float)((double)warpAmplifier * ((double)(originalMaxHeight - y) / ((double)originalMaxHeight * 0.85)));
                    float xDisp = 0.0f;
                    float yDisp = 0.0f;
                    float zDisp = 0.0f;
                    xDisp = this.displacementNoisePerlin.GetNoise(realX, realY, realZ) * dispAmp;
                    yDisp = this.displacementNoisePerlin.GetNoise(realX, realY - 256.0f, realZ) * dispAmp;
                    zDisp = this.displacementNoisePerlin.GetNoise(realX, realY - 512.0f, realZ) * dispAmp;
                    noiseSamples[x][y][z] = noise = this.worleyF1divF3.SingleCellular3Edge((float)realX * xzCompression + xDisp, realY * yCompression + yDisp, (float)realZ * xzCompression + zDisp);
                    if (!(noise > noiseCutoff)) continue;
                    if (x > 0) {
                        noiseSamples[x - 1][y][z] = noise * 0.2f + noiseSamples[x - 1][y][z] * 0.8f;
                    }
                    if (z > 0) {
                        noiseSamples[x][y][z - 1] = noise * 0.2f + noiseSamples[x][y][z - 1] * 0.8f;
                    }
                    if (y >= 128) continue;
                    float noiseAbove = noiseSamples[x][y + 1][z];
                    if (noise > noiseAbove) {
                        noiseSamples[x][y + 1][z] = noise * 0.8f + noiseAbove * 0.2f;
                    }
                    if (y >= 127 || !(noise > (noiseTwoAbove = noiseSamples[x][y + 2][z]))) continue;
                    noiseSamples[x][y + 2][z] = noise * 0.35f + noiseTwoAbove * 0.65f;
                }
            }
        }
        return noiseSamples;
    }

    private int getSurfaceHeight(ChunkPrimer chunkPrimerIn, int localX, int localZ) {
        return this.recursiveBinarySurfaceSearch(chunkPrimerIn, localX, localZ, 255, 0);
    }

    private int recursiveBinarySurfaceSearch(ChunkPrimer chunkPrimer, int localX, int localZ, int searchTop, int searchBottom) {
        int top = searchTop;
        if (searchTop > searchBottom) {
            int searchMid = (searchBottom + searchTop) / 2;
            top = this.func_175793_a(chunkPrimer.func_177856_a(localX, searchMid, localZ), AIR) ? this.recursiveBinarySurfaceSearch(chunkPrimer, localX, localZ, searchTop, searchMid + 1) : this.recursiveBinarySurfaceSearch(chunkPrimer, localX, localZ, searchMid, searchBottom);
        }
        return top;
    }

    private int getMaxSurfaceHeight(ChunkPrimer primer) {
        int max = 0;
        int[] testcords = new int[]{0, 7, 15};
        for (int n = 0; n < testcords.length; ++n) {
            for (int m = 0; m < testcords.length; ++m) {
                int testmax = this.getSurfaceHeight(primer, testcords[n], testcords[m]);
                if (testmax <= max) continue;
                max = testmax;
            }
        }
        return max;
    }

    private boolean isBiomeBlock(ChunkPrimer primer, int realX, int realZ, IBlockState state) {
        Biome biome = this.field_75039_c.func_180494_b(new BlockPos(realX, 0, realZ));
        return state == biome.field_76752_A || state == biome.field_76753_B;
    }

    private boolean isTopBlock(ChunkPrimer data, int x, int y, int z, int chunkX, int chunkZ) {
        Biome biome = this.field_75039_c.func_180494_b(new BlockPos(x + chunkX * 16, 0, z + chunkZ * 16));
        IBlockState state = data.func_177856_a(x, y, z);
        return this.isExceptionBiome(biome) ? state.func_177230_c() == Blocks.field_150349_c : state == biome.field_76752_A;
    }

    private boolean isExceptionBiome(Biome biome) {
        if (biome == Biomes.field_76787_r) {
            return true;
        }
        return biome == Biomes.field_76769_d;
    }

    protected void digBlock(ChunkPrimer data, int x, int y, int z, int chunkX, int chunkZ, boolean foundTop, IBlockState state, IBlockState up) {
        Biome biome = this.field_75039_c.func_180494_b(new BlockPos(x + chunkX * 16, 0, z + chunkZ * 16));
        IBlockState top = biome.field_76752_A;
        IBlockState filler = biome.field_76753_B;
        if (this.func_175793_a(state, up) || state.func_177230_c() == top.func_177230_c() || state.func_177230_c() == filler.func_177230_c()) {
            if (y <= lavaDepth) {
                data.func_177855_a(x, y, z, lava);
            } else {
                data.func_177855_a(x, y, z, AIR);
                if (foundTop && data.func_177856_a(x, y - 1, z).func_177230_c() == filler.func_177230_c()) {
                    data.func_177855_a(x, y - 1, z, top);
                }
                if (up == Blocks.field_150354_m.func_176223_P()) {
                    data.func_177855_a(x, y + 1, z, field_186128_c);
                } else if (up == Blocks.field_150354_m.func_176203_a(1)) {
                    data.func_177855_a(x, y + 1, z, field_186129_d);
                }
            }
        }
    }

    static {
        AIR = Blocks.field_150350_a.func_176223_P();
    }
}

