/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.preview.texture;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import pregenerator.impl.client.preview.texture.CompressedTexture;
import pregenerator.impl.client.preview.texture.DisplayTexture;
import pregenerator.impl.client.preview.texture.IRenderTexture;
import pregenerator.impl.client.preview.world.WorldSeed;
import pregenerator.impl.client.preview.world.data.IChunkData;

public class MoveableTexture {
    float xPosition;
    float yPosition;
    int width;
    int height;
    IRenderTexture texture;

    public MoveableTexture(int size) {
        this.width = size;
        this.height = size;
        this.centerTexture();
        this.createTexture();
    }

    public void removeTexture() {
        if (this.texture != null) {
            this.texture.removeTexture();
            this.texture = null;
        }
    }

    public void resizeTexture(int newSize) {
        this.removeTexture();
        this.width = newSize;
        this.height = newSize;
        this.createTexture();
    }

    public void createTexture() {
        this.texture = WorldSeed.isUsingCompression() ? new CompressedTexture(this.width, this.height) : new DisplayTexture(this.width, this.height);
    }

    public void createTextureIfMissing() {
        if (this.texture == null) {
            this.createTexture();
        }
    }

    public void bindTexture() {
        GlStateManager.func_179144_i((int)this.texture.func_110552_b());
    }

    public void translate(float x, float y, float scale) {
        this.texture.translate(x, y, scale);
    }

    public void render(boolean slime, IRenderFunction function) {
        this.bindTexture();
        this.texture.onRender(slime);
        function.render(this.xPosition, this.yPosition, this.width, this.height);
        this.texture.onRenderFinished(Minecraft.func_71410_x());
    }

    public void addChunkData(IChunkData data, int size, int view) {
        if (this.texture == null) {
            return;
        }
        this.texture.addData(data, size, view);
    }

    public void clearTexture() {
        if (this.texture == null) {
            return;
        }
        this.texture.clearTexture();
    }

    public void centerTexture() {
        this.xPosition = -(this.width / 2);
        this.yPosition = -(this.height / 2);
    }

    public void moveTexture(float xMove, float yMove) {
        this.xPosition += xMove;
        this.yPosition += yMove;
    }

    public float getX() {
        return this.xPosition;
    }

    public float getY() {
        return this.yPosition;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static interface IRenderFunction {
        public void render(float var1, float var2, int var3, int var4);
    }
}

