/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import info.u_team.u_team_core.UCoreConstants;
import info.u_team.u_team_core.api.registry.IUEntityEntry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryUtil {
    public static <T extends IForgeRegistryEntry<T>> List<T> getRegistryEntries(Class<T> clazz, Class<?> init) {
        ArrayList<IForgeRegistryEntry> list = new ArrayList<IForgeRegistryEntry>();
        try {
            for (Field field : init.getDeclaredFields()) {
                if (!clazz.isAssignableFrom(field.getType())) continue;
                list.add((IForgeRegistryEntry)field.get(null));
            }
        }
        catch (Exception ex) {
            UCoreConstants.LOGGER.error("Failed fetching registry entries for class {}", init, (Object)ex);
        }
        return list;
    }

    public static List<IUEntityEntry> getEntityRegistryEntries(Class<?> init) {
        ArrayList<IUEntityEntry> list = new ArrayList<IUEntityEntry>();
        try {
            for (Field field : init.getDeclaredFields()) {
                if (!IUEntityEntry.class.isAssignableFrom(field.getType())) continue;
                list.add((IUEntityEntry)field.get(null));
            }
        }
        catch (Exception ex) {
            UCoreConstants.LOGGER.error("Failed fetching entity registry entries for class {}", init, (Object)ex);
        }
        return list;
    }
}

