/*
 * Decompiled with CFR 0.152.
 */
package net.insane96mcp.progressivebosses.events.entities;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.insane96mcp.progressivebosses.events.entities.ai.WitherMinionAIHurtByTarget;
import net.insane96mcp.progressivebosses.item.ModItems;
import net.insane96mcp.progressivebosses.lib.Properties;
import net.insane96mcp.progressivebosses.lib.Reflection;
import net.insane96mcp.progressivebosses.lib.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;

public class Wither {
    private static final Predicate<Entity> NOT_UNDEAD = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity p_apply_1_) {
            return p_apply_1_ instanceof EntityLivingBase && ((EntityLivingBase)p_apply_1_).func_70668_bt() != EnumCreatureAttribute.UNDEAD && ((EntityLivingBase)p_apply_1_).func_190631_cK();
        }
    };

    public static void SetStats(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof EntityWither)) {
            return;
        }
        EntityWither wither = (EntityWither)event.getEntity();
        NBTTagCompound tags = wither.getEntityData();
        boolean alreadySpawned = tags.func_74767_n("progressivebosses:spawned");
        if (alreadySpawned) {
            return;
        }
        tags.func_74757_a("progressivebosses:spawned", true);
        int radius = Properties.config.wither.general.spawnRadiusPlayerCheck;
        BlockPos pos1 = wither.func_180425_c().func_177982_a(-radius, -radius, -radius);
        BlockPos pos2 = wither.func_180425_c().func_177982_a(radius, radius, radius);
        AxisAlignedBB bb = new AxisAlignedBB(pos1, pos2);
        List players = event.getWorld().func_72872_a(EntityPlayerMP.class, bb);
        if (players.size() == 0) {
            return;
        }
        float spawnedCount = 1.0f;
        for (EntityPlayerMP player : players) {
            NBTTagCompound playerTags = player.getEntityData();
            int c = playerTags.func_74762_e("progressivebosses:spawnedwithers");
            spawnedCount += (float)c;
            if (c >= Properties.config.wither.general.maxDifficulty) continue;
            playerTags.func_74768_a("progressivebosses:spawnedwithers", c + 1);
        }
        if (spawnedCount == 1.0f) {
            return;
        }
        if (!Properties.config.wither.general.sumSpawnedWitherDifficulty) {
            spawnedCount /= (float)players.size();
        }
        Wither.SetHealth(wither, spawnedCount);
        Wither.SetArmor(wither, spawnedCount);
        Wither.SetExperience(wither, spawnedCount);
        tags.func_74776_a("progressivebosses:difficulty", spawnedCount);
        int cooldown = MathHelper.func_76136_a((Random)wither.func_70681_au(), (int)Properties.config.wither.minions.minCooldown, (int)Properties.config.wither.minions.maxCooldown);
        tags.func_74768_a("progressivebosses:skeletons_cooldown", Properties.config.wither.minions.minCooldown);
    }

    private static void SetExperience(EntityWither wither, float difficulty) {
        int xp = 50 + (int)(50.0f * (Properties.config.wither.rewards.bonusExperience * difficulty / 100.0f));
        Reflection.Set(Reflection.EntityLiving_experienceValue, wither, xp);
    }

    private static void SetHealth(EntityWither wither, float spawnedCount) {
        IAttributeInstance health = wither.func_110148_a(SharedMonsterAttributes.field_111267_a);
        if (spawnedCount < 0.0f) {
            health.func_111128_a(health.func_111125_b() / (double)(-(spawnedCount - 1.0f)));
        } else {
            health.func_111128_a(health.func_111125_b() + (double)(spawnedCount * Properties.config.wither.health.bonusPerDifficulty));
        }
        wither.func_70606_j(Math.max(1.0f, (float)health.func_111125_b() - 200.0f));
    }

    private static void SetArmor(EntityWither wither, float killedCount) {
        IAttributeInstance attribute = wither.func_110148_a(SharedMonsterAttributes.field_188791_g);
        float armor = killedCount * Properties.config.wither.armor.bonusPerDifficulty;
        if (armor > Properties.config.wither.armor.maximum) {
            armor = Properties.config.wither.armor.maximum;
        }
        attribute.func_111128_a((double)armor);
    }

    public static void Update(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntity() instanceof EntityWither)) {
            return;
        }
        World world = event.getEntity().field_70170_p;
        EntityWither wither = (EntityWither)event.getEntity();
        NBTTagCompound tags = wither.getEntityData();
        if (wither.func_82212_n() > 0) {
            Reflection.Invoke(Reflection.BossInfoServer_setPercent, Reflection.Get(Reflection.EntityWither_bossInfo, wither), Float.valueOf(wither.func_110143_aJ() / wither.func_110138_aP()));
        } else {
            Wither.SpawnSkeletons(wither, world);
            Wither.Heal(wither, tags);
        }
    }

    private static void Heal(EntityWither wither, NBTTagCompound tags) {
        if (Properties.config.wither.health.maximumBonusRegen == 0.0f) {
            return;
        }
        if (wither.field_70173_aa % 20 != 0) {
            return;
        }
        float difficulty = tags.func_74760_g("progressivebosses:difficulty");
        if (difficulty <= 0.0f) {
            return;
        }
        float heal = difficulty * Properties.config.wither.health.bonusRegenPerSpawned;
        float maxHeal = Properties.config.wither.health.maximumBonusRegen;
        if (heal > maxHeal) {
            heal = maxHeal;
        }
        float health = wither.func_110143_aJ();
        if (wither.func_110143_aJ() < wither.func_110138_aP() && wither.func_110143_aJ() > 0.0f) {
            wither.func_70606_j(health + heal);
        }
    }

    private static void SpawnSkeletons(EntityWither wither, World world) {
        BlockPos pos2;
        if (Properties.config.wither.minions.difficultyToSpawn < 0) {
            return;
        }
        int radius = 24;
        BlockPos pos1 = wither.func_180425_c().func_177982_a(-radius, -radius, -radius);
        AxisAlignedBB bb = new AxisAlignedBB(pos1, pos2 = wither.func_180425_c().func_177982_a(radius, radius, radius));
        List players = world.func_72872_a(EntityPlayer.class, bb);
        if (players.isEmpty()) {
            return;
        }
        List minions = world.func_72872_a(EntityWitherSkeleton.class, bb);
        int minionsCount = minions.size();
        if (minionsCount >= Properties.config.wither.minions.maxAround && Properties.config.wither.minions.maxAround > 0) {
            return;
        }
        if (Properties.config.wither.minions.maxSpawned == 0) {
            return;
        }
        NBTTagCompound tags = wither.getEntityData();
        tags.func_74757_a("mobsrandomizzation:preventProcessing", true);
        float difficulty = tags.func_74760_g("progressivebosses:difficulty");
        int cooldown = tags.func_74762_e("progressivebosses:skeletons_cooldown");
        if (cooldown > 0) {
            tags.func_74768_a("progressivebosses:skeletons_cooldown", cooldown - 1);
        } else {
            cooldown = MathHelper.func_76136_a((Random)world.field_73012_v, (int)Properties.config.wither.minions.minCooldown, (int)Properties.config.wither.minions.maxCooldown);
            tags.func_74768_a("progressivebosses:skeletons_cooldown", cooldown);
            int i = Properties.config.wither.minions.difficultyToSpawn;
            while ((float)i <= difficulty) {
                if (minionsCount >= Properties.config.wither.minions.maxAround && Properties.config.wither.minions.maxAround > 0) {
                    return;
                }
                int spawn = i - Properties.config.wither.minions.difficultyToSpawn;
                if (spawn / Properties.config.wither.minions.difficultyToSpawnOneMore >= Properties.config.wither.minions.maxSpawned) break;
                if (spawn % Properties.config.wither.minions.difficultyToSpawnOneMore == 0) {
                    EntityWitherSkeleton witherSkeleton = new EntityWitherSkeleton(world);
                    NBTTagCompound skellyTags = witherSkeleton.getEntityData();
                    skellyTags.func_74777_a("scalinghealth:difficulty", (short)-1);
                    int x = 0;
                    int y = 0;
                    int z = 0;
                    boolean shouldSpawn = false;
                    for (int t = 0; t < 10; ++t) {
                        x = (int)(wither.field_70165_t + (double)MathHelper.func_76136_a((Random)world.field_73012_v, (int)-3, (int)3));
                        y = (int)(wither.field_70163_u - 3.0);
                        z = (int)(wither.field_70161_v + (double)MathHelper.func_76136_a((Random)world.field_73012_v, (int)-3, (int)3));
                        while ((double)y < wither.field_70163_u + 4.0) {
                            if (Wither.canSpawn((Entity)witherSkeleton, new BlockPos(x, y, z), world)) {
                                shouldSpawn = true;
                                break;
                            }
                            ++y;
                        }
                        if (shouldSpawn) break;
                    }
                    if (shouldSpawn) {
                        IAttributeInstance armor = witherSkeleton.func_110148_a(SharedMonsterAttributes.field_188791_g);
                        float minArmor = Properties.config.wither.minions.minArmor;
                        float maxArmor = Properties.config.wither.minions.maxArmor;
                        armor.func_111128_a((double)Utils.Math.getFloat(world.field_73012_v, minArmor, maxArmor));
                        IAttributeInstance speedAttibute = witherSkeleton.func_110148_a(SharedMonsterAttributes.field_111263_d);
                        float maxSpeedMultiplier = 1.25f;
                        float speedMultiplier = difficulty / 100.0f + 1.0f;
                        if (speedMultiplier > maxSpeedMultiplier) {
                            speedMultiplier = maxSpeedMultiplier;
                        }
                        speedAttibute.func_111128_a(speedAttibute.func_111125_b() * (double)speedMultiplier);
                        witherSkeleton.func_70107_b((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f));
                        witherSkeleton.func_96094_a("Wither's Minion");
                        Reflection.Set(Reflection.EntityLiving_deathLootTable, witherSkeleton, new ResourceLocation("minecraft:empty"));
                        Reflection.Set(Reflection.EntityLiving_experienceValue, witherSkeleton, 1);
                        NBTTagList minionsList = tags.func_150295_c("minions", 10);
                        NBTTagCompound uuid = new NBTTagCompound();
                        uuid.func_186854_a("uuid", witherSkeleton.func_110124_au());
                        tags.func_74782_a("minions", (NBTBase)minionsList);
                        minionsList.func_74742_a((NBTBase)uuid);
                        ArrayList<EntityAITasks.EntityAITaskEntry> toRemove = new ArrayList<EntityAITasks.EntityAITaskEntry>();
                        for (EntityAITasks.EntityAITaskEntry task : witherSkeleton.field_70714_bg.field_75782_a) {
                            if (task.field_75733_a instanceof EntityAIFleeSun) {
                                toRemove.add(task);
                            }
                            if (task.field_75733_a instanceof EntityAIRestrictSun) {
                                toRemove.add(task);
                            }
                            if (!(task.field_75733_a instanceof EntityAIAvoidEntity)) continue;
                            toRemove.add(task);
                        }
                        for (EntityAITasks.EntityAITaskEntry entityAITaskEntry : toRemove) {
                            witherSkeleton.field_70714_bg.field_75782_a.remove(entityAITaskEntry);
                        }
                        toRemove.clear();
                        for (EntityAITasks.EntityAITaskEntry targetTask : witherSkeleton.field_70715_bh.field_75782_a) {
                            if (targetTask.field_75733_a instanceof EntityAINearestAttackableTarget) {
                                toRemove.add(targetTask);
                            }
                            if (!(targetTask.field_75733_a instanceof EntityAIHurtByTarget)) continue;
                            toRemove.add(targetTask);
                        }
                        for (EntityAITasks.EntityAITaskEntry entityAITaskEntry : toRemove) {
                            witherSkeleton.field_70715_bh.field_75782_a.remove(entityAITaskEntry);
                        }
                        toRemove.clear();
                        witherSkeleton.field_70715_bh.func_75776_a(1, (EntityAIBase)new WitherMinionAIHurtByTarget((EntityCreature)witherSkeleton, true, new Class[0]));
                        witherSkeleton.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)witherSkeleton, EntityPlayer.class, false));
                        witherSkeleton.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)witherSkeleton, EntityLiving.class, 0, false, false, NOT_UNDEAD));
                        world.func_72838_d((Entity)witherSkeleton);
                        ++minionsCount;
                    }
                }
                ++i;
            }
        }
    }

    private static boolean canSpawn(Entity mob, BlockPos pos, World world) {
        int height = (int)Math.ceil(mob.field_70131_O);
        boolean canSpawn = true;
        for (int i = 0; i < height; ++i) {
            if (!world.func_180495_p(pos.func_177981_b(i)).func_185904_a().func_76230_c()) continue;
            canSpawn = false;
            break;
        }
        if (!world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76230_c()) {
            canSpawn = false;
        }
        return canSpawn;
    }

    public static void OnDeath(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof EntityWither)) {
            return;
        }
        EntityWither wither = (EntityWither)event.getEntity();
        World world = wither.field_70170_p;
        NBTTagCompound tags = wither.getEntityData();
        NBTTagList minionsList = tags.func_150295_c("minions", 10);
        block0: for (int i = 0; i < minionsList.func_74745_c(); ++i) {
            UUID uuid = minionsList.func_150305_b(i).func_186857_a("uuid");
            AxisAlignedBB axisAlignedBB = new AxisAlignedBB(new BlockPos((Vec3i)wither.func_180425_c().func_177982_a(-128, -128, -128)), wither.func_180425_c().func_177982_a(128, 128, 128));
            List witherSkeletons = world.func_72872_a(EntityWitherSkeleton.class, axisAlignedBB);
            for (EntityWitherSkeleton skeleton : witherSkeletons) {
                if (!skeleton.func_110124_au().equals(uuid)) continue;
                skeleton.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"minecraft:wither"), 10000, 10));
                continue block0;
            }
        }
    }

    public static void SetDrops(LivingDropsEvent event) {
        int tries;
        if (!(event.getEntityLiving() instanceof EntityWither)) {
            return;
        }
        EntityWither wither = (EntityWither)event.getEntityLiving();
        NBTTagCompound tags = wither.getEntityData();
        float difficulty = tags.func_74760_g("progressivebosses:difficulty");
        float chance = Properties.config.wither.rewards.shardPerDifficulty * difficulty;
        if (chance > Properties.config.wither.rewards.shardMaxChance) {
            chance = Properties.config.wither.rewards.shardMaxChance;
        }
        if ((tries = (int)(difficulty / (float)Properties.config.wither.rewards.shardDivider) + 1) > Properties.config.wither.rewards.shardMaxCount) {
            tries = Properties.config.wither.rewards.shardMaxCount;
        }
        int count = 0;
        for (int i = 0; i < tries; ++i) {
            if (wither.field_70170_p.field_73012_v.nextFloat() >= chance / 100.0f) continue;
            ++count;
        }
        if (count == 0) {
            return;
        }
        EntityItem shard = new EntityItem(wither.field_70170_p, wither.field_70165_t, wither.field_70163_u, wither.field_70161_v, new ItemStack(ModItems.starShard, count));
        event.getDrops().add(shard);
    }
}

