/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.solarflux.gui;

import com.google.common.collect.Lists;
import com.zeitheron.solarflux.block.tile.TileBaseSolar;
import com.zeitheron.solarflux.gui.ContainerBaseSolar;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiBaseSolar
extends GuiContainer {
    private static final ResourceLocation ELEMENTS = new ResourceLocation("solarflux", "textures/gui/elements.png");
    private static final ResourceLocation TEXTURE = new ResourceLocation("solarflux", "textures/gui/solar.png");
    private static final int GAUGE_WIDTH = 18;
    private static final int GAUGE_HEIGHT = 50;
    private static final int GAUGE_INNER_WIDTH = 16;
    private static final int GAUGE_INNER_HEIGHT = 48;
    private static final int GAUGE_INNER_OFFSET_X = 1;
    private static final int GAUGE_INNER_OFFSET_Y = 1;
    private static final int GAUGE_SRC_X = 64;
    private static final int GAUGE_SRC_Y = 62;
    private static final int GAUGE_INNER_SRC_X = 0;
    private static final int GAUGE_INNER_SRC_Y = 64;
    private static final int BORDER_OFFSET = 8;
    private final TileBaseSolar solar;
    private final InventoryPlayer pinv;
    private List<String> tooltip = Lists.newArrayList();

    public GuiBaseSolar(TileBaseSolar tile, InventoryPlayer playerInv) {
        super((Container)new ContainerBaseSolar(tile, playerInv));
        this.solar = tile;
        this.pinv = playerInv;
        this.field_146999_f = 176;
        this.field_147000_g = 180;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        this.field_146289_q.func_78276_b(this.pinv.func_145818_k_() ? this.pinv.func_70005_c_() : I18n.func_135052_a((String)this.pinv.func_70005_c_(), (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        this.field_146289_q.func_78276_b(this.solar.func_145838_q().func_149732_F(), 8, 4, 0x404040);
        GlStateManager.func_179109_b((float)8.0f, (float)14.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.9f, (float)0.9f, (float)0.9f);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"info.solarflux.energy.stored1", (Object[])new Object[]{this.solar.energy}), 0, 0, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"info.solarflux.energy.capacity", (Object[])new Object[]{this.solar.getVar(1)}), 0, 10, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"info.solarflux.energy.generation", (Object[])new Object[]{this.solar.getVar(4)}), 0, 20, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"info.solarflux.energy.efficiency", (Object[])new Object[]{Math.round(100.0 * (double)this.solar.getVar(4) / (double)this.solar.getVar(2))}), 0, 30, 0x404040);
        GlStateManager.func_179121_F();
        int x = this.field_146999_f - 18 - 8;
        int y = 40;
        boolean hover = this.inBounds(x + this.field_147003_i, y + this.field_147009_r, 18, 50, mouseX, mouseY);
        if (hover) {
            GL11.glDisable((int)3553);
            this.func_73733_a(x + 1, y + 1, x + 18 - 1, y + 50 - 1, -1996488705, -1996488705);
            GL11.glEnable((int)3553);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(ELEMENTS);
            this.func_73729_b(x, y, 82, 62, 18, 50);
            if (this.pinv.func_70445_o().func_190926_b()) {
                this.drawMouseOver(I18n.func_135052_a((String)"info.solarflux.energy.stored2", (Object[])new Object[]{this.solar.energy, this.solar.capacity.getValueL()}));
            }
        }
        if (hover = this.inBounds((x = this.field_146999_f - 36 - 8 - 4) + this.field_147003_i, (y = 40) + this.field_147009_r, 18, 50, mouseX, mouseY)) {
            GL11.glDisable((int)3553);
            this.func_73733_a(x + 1, y + 1, x + 18 - 1, y + 50 - 1, -1996488705, -1996488705);
            GL11.glEnable((int)3553);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(ELEMENTS);
            this.func_73729_b(x, y, 82, 62, 18, 50);
            if (this.pinv.func_70445_o().func_190926_b()) {
                this.drawMouseOver(I18n.func_135052_a((String)"info.solarflux.sun.intensity", (Object[])new Object[]{Math.round(100.0f * this.solar.sunIntensity)}));
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(xStart, yStart, 0, 0, this.field_146999_f, this.field_147000_g);
        this.field_146297_k.func_110434_K().func_110577_a(ELEMENTS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        this.drawPower(xStart + this.field_146999_f - 18 - 8, yStart + 8 + 32, mouseX, mouseY);
        this.drawSun(xStart + this.field_146999_f - 36 - 8 - 4, yStart + 8 + 32, mouseX, mouseY);
        for (int i = 0; i < this.solar.items.func_70302_i_(); ++i) {
            this.func_73729_b(xStart + i * 18 + 8, yStart + 60, 18, 0, 18, 18);
        }
        this.func_73729_b(xStart + 150, yStart + 8, 18, 18, 18, 18);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.solar.setBaseValuesOnGet = false;
        this.func_146276_q_();
        GlStateManager.func_179147_l();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.tooltip.clear();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawHoveringText(this.tooltip, mouseX, mouseY, this.field_146289_q);
        this.func_191948_b(mouseX, mouseY);
        this.solar.setBaseValuesOnGet = true;
    }

    private void drawPower(int x, int y, int mx, int my) {
        this.func_73729_b(x + 1, y + 1, 16, 64, 16, 48);
        double height = (double)this.solar.energy * 48.0 / (double)this.solar.capacity.getValueL();
        double offset = 48.0 - height;
        this.drawTMR(x + 1, (double)(y + 1) + offset, 0.0, 64.0 + offset, 16.0, height);
        this.func_73729_b(x, y, 64, 62, 18, 50);
    }

    private void drawSun(int x, int y, int mouseX, int mouseY) {
        this.func_73729_b(x + 1, y + 1, 48, 64, 16, 48);
        float height = 48.0f * this.solar.sunIntensity;
        float offset = 48.0f - height;
        this.drawTMR(x + 1, (float)(y + 1) + offset, 32.0, 64.0f + offset, 16.0, height);
        this.func_73729_b(x, y, 64, 62, 18, 50);
    }

    public void drawTMR(double x, double y, double textureX, double textureY, double width, double height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x + 0.0, y + height, (double)this.field_73735_i).func_187315_a((double)((float)(textureX + 0.0) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + height, (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + 0.0, (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + 0.0) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b(x + 0.0, y + 0.0, (double)this.field_73735_i).func_187315_a((double)((float)(textureX + 0.0) * 0.00390625f), (double)((float)(textureY + 0.0) * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }

    public boolean inBounds(int x, int y, int w, int h, int mx, int my) {
        return mx >= x && mx < x + w && my >= y && my <= y + h;
    }

    public void drawMouseOver(String line) {
        if (line != null) {
            Collections.addAll(this.tooltip, line.split("\n"));
        }
    }
}

