/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.ritual;

import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.tile.TileBloodTank;
import arcaratus.bloodarsenal.ConfigHandler;
import arcaratus.bloodarsenal.core.RegistrarBloodArsenalBlocks;
import arcaratus.bloodarsenal.core.RegistrarBloodArsenalItems;
import arcaratus.bloodarsenal.item.types.EnumBaseTypes;
import arcaratus.bloodarsenal.ritual.RitualBloodArsenal;
import arcaratus.bloodarsenal.tile.TileStasisPlate;
import arcaratus.bloodarsenal.util.TriFunction;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.block.BlockFire;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

@RitualRegister(value="blood_burner")
public class RitualBloodBurner
extends RitualBloodArsenal {
    private static final Set<BlockPos> FIRE_POS = Sets.newHashSet((Object[])new BlockPos[]{new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, 1), new BlockPos(0, 0, -1), new BlockPos(1, 0, 1), new BlockPos(-1, 0, 1), new BlockPos(1, 0, -1), new BlockPos(-1, 0, -1)});
    private static final Set<BlockPos> GLOWSTONE_POS = Sets.newHashSet((Object[])new BlockPos[]{new BlockPos(2, 1, 0), new BlockPos(-2, 1, 0), new BlockPos(0, 1, 2), new BlockPos(0, 1, -2), new BlockPos(2, 1, 1), new BlockPos(2, 1, -1), new BlockPos(-2, 1, 1), new BlockPos(-2, 1, -1), new BlockPos(1, 1, 2), new BlockPos(1, 1, -2), new BlockPos(-1, 1, 2), new BlockPos(-1, 1, -2), new BlockPos(2, 1, 2), new BlockPos(2, 1, -2), new BlockPos(-2, 1, 2), new BlockPos(-2, 1, -2)});
    private static final Set<BlockPos> LAVA_POS = Sets.newHashSet((Object[])new BlockPos[]{new BlockPos(3, 1, 1), new BlockPos(3, 1, -1), new BlockPos(-3, 1, 1), new BlockPos(-3, 1, -1), new BlockPos(3, 1, 2), new BlockPos(-3, 1, 2), new BlockPos(3, 1, -2), new BlockPos(-3, 1, -2), new BlockPos(1, 1, 3), new BlockPos(-1, 1, 3), new BlockPos(1, 1, -3), new BlockPos(-1, 1, -3), new BlockPos(2, 1, 3), new BlockPos(-2, 1, 3), new BlockPos(2, 1, -3), new BlockPos(-2, 1, -3)});
    private static final Set<BlockPos> LIFE_ESSENCE_POS = Sets.newHashSet((Object[])new BlockPos[]{new BlockPos(4, 1, 0), new BlockPos(-4, 1, 0), new BlockPos(0, 1, 4), new BlockPos(0, 1, -4), new BlockPos(4, 1, 2), new BlockPos(-4, 1, 2), new BlockPos(4, 1, -2), new BlockPos(-4, 1, -2), new BlockPos(2, 1, 4), new BlockPos(-2, 1, 4), new BlockPos(2, 1, -4), new BlockPos(-2, 1, -4), new BlockPos(4, 1, 4), new BlockPos(-4, 1, 4), new BlockPos(4, 1, -4), new BlockPos(-4, 1, -4)});
    private static final Set<Item> IGNITERS = Sets.newHashSet((Object[])new Item[]{Items.field_151033_d, RegistrarBloodArsenalItems.BOUND_IGNITER});
    private static final BiFunction<Integer, Integer, BiFunction<Double, Integer, Integer>> TOTAL_RF = (a, g) -> (u, l) -> (int)(u * ((double)a.intValue() * ((double)g.intValue() + 1.0) - 0.8 * (double)l.intValue()));
    private static final TriFunction<Integer, Integer, Integer, Integer> TIME = (a, g, l) -> (int)(20.0 * (3.0 * (double)a.intValue() * ((double)g.intValue() + 8.0)) / (1322.0 * Math.pow(1.00036, l.intValue()) + 16425.5 - 0.68756 * (double)l.intValue()));
    private boolean active = false;
    private int secondsLeft = 0;
    private int rateRF = 0;

    public RitualBloodBurner() {
        super("blood_burner", 0, ConfigHandler.rituals.bloodBurnerRitualActivationCost, 1, ConfigHandler.rituals.bloodBurnerRitualRefreshCost);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone, World world, SoulNetwork network) {
        BlockPos pos = masterRitualStone.getBlockPos();
        if (this.checkStructure(world, pos)) {
            List<TileBloodTank> lavaTanks = this.getTanks(world, pos, LAVA_POS);
            List<TileBloodTank> lifeEssenceTanks = this.getTanks(world, pos, LIFE_ESSENCE_POS);
            int lavaAmount = this.getFluidNumber(lavaTanks, true);
            int lifeEssenceAmount = this.getFluidNumber(lifeEssenceTanks, false);
            if (this.active) {
                if (this.secondsLeft > 0 && this.rateRF > 0) {
                    TileEntity energyHandler = world.func_175625_s(pos.func_177982_a(0, 2, 0));
                    if (energyHandler != null && energyHandler.hasCapability(CapabilityEnergy.ENERGY, EnumFacing.DOWN)) {
                        world.func_175688_a(EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 4.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[]{0});
                        network.syphon(SoulTicket.block((World)world, (BlockPos)pos, (int)(this.rateRF / 100)));
                        ((IEnergyStorage)energyHandler.getCapability(CapabilityEnergy.ENERGY, EnumFacing.DOWN)).receiveEnergy(this.rateRF, false);
                        --this.secondsLeft;
                        if (world instanceof WorldServer && world.func_72820_D() % 4L == 0L) {
                            WorldServer server = (WorldServer)world;
                            server.func_175739_a(EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, 1, 0.2, 0.0, 0.2, 0.0, new int[0]);
                            server.func_175739_a(EnumParticleTypes.FLAME, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, 1, 0.2, 0.0, 0.2, 0.0, new int[0]);
                        }
                    }
                } else if (this.secondsLeft == 0) {
                    if (lifeEssenceAmount >= 1000) {
                        this.startBurn(world, pos, lavaAmount, lifeEssenceAmount, lavaTanks, lifeEssenceTanks);
                    }
                    this.endRitual(world, pos, masterRitualStone);
                }
            } else if (lifeEssenceAmount >= 1000) {
                this.startBurn(world, pos, lavaAmount, lifeEssenceAmount, lavaTanks, lifeEssenceTanks);
            } else {
                this.endRitual(world, pos, masterRitualStone);
            }
        } else {
            this.endRitual(world, pos, masterRitualStone);
        }
    }

    private void startBurn(World world, BlockPos pos, int lavaAmount, int lifeEssenceAmount, List<TileBloodTank> lavaTanks, List<TileBloodTank> lifeEssenceTanks) {
        TileStasisPlate stasisPlate = (TileStasisPlate)world.func_175625_s(pos.func_177982_a(0, 1, 0));
        ItemStack igniter = stasisPlate.func_70301_a(0);
        double u = igniter.func_77973_b() == RegistrarBloodArsenalItems.BOUND_IGNITER ? 1.0 : 0.5;
        int g = (int)Math.pow((double)this.getTotalDustAmount(this.getStasisPlates(world, pos)) / 2.0, 2.0);
        int time = TIME.apply(lifeEssenceAmount, g, lavaAmount);
        int totalRF = TOTAL_RF.apply(lifeEssenceAmount, g).apply(u, lavaAmount);
        int rate = totalRF / time;
        this.active = true;
        this.secondsLeft = time;
        this.rateRF = rate;
        for (TileBloodTank tank : Iterables.concat(lifeEssenceTanks, lavaTanks)) {
            tank.getTank().drain(1000, true);
        }
        this.shrinkInputs(world, pos);
        world.func_72838_d((Entity)new EntityLightningBolt(world, (double)(pos.func_177958_n() + 6), (double)(pos.func_177956_o() + 5), (double)(pos.func_177952_p() + 6), false));
        world.func_72838_d((Entity)new EntityLightningBolt(world, (double)(pos.func_177958_n() + 6), (double)(pos.func_177956_o() + 5), (double)(pos.func_177952_p() - 6), false));
        world.func_72838_d((Entity)new EntityLightningBolt(world, (double)(pos.func_177958_n() - 6), (double)(pos.func_177956_o() + 5), (double)(pos.func_177952_p() + 6), false));
        world.func_72838_d((Entity)new EntityLightningBolt(world, (double)(pos.func_177958_n() - 6), (double)(pos.func_177956_o() + 5), (double)(pos.func_177952_p() - 6), false));
    }

    private void endRitual(World world, BlockPos pos, IMasterRitualStone mrs) {
        world.func_72876_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, 0.0f, false);
        mrs.setActive(false);
    }

    private boolean checkStructure(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos.func_177982_a(0, 2, 0));
        if (tile == null || !tile.hasCapability(CapabilityEnergy.ENERGY, EnumFacing.DOWN)) {
            return false;
        }
        tile = world.func_175625_s(pos.func_177982_a(0, 1, 0));
        if (!(tile instanceof TileStasisPlate)) {
            return false;
        }
        ItemStack igniter = ((TileStasisPlate)tile).func_70301_a(0);
        if (igniter.func_190926_b() || !IGNITERS.contains(igniter.func_77973_b())) {
            return false;
        }
        for (BlockPos firePos : FIRE_POS) {
            if (world.func_180495_p(pos.func_177971_a((Vec3i)firePos)).func_177230_c() instanceof BlockFire) continue;
            return false;
        }
        return true;
    }

    private List<TileBloodTank> getTanks(World world, BlockPos pos, Collection<BlockPos> tankPositions) {
        ArrayList<TileBloodTank> tanks = new ArrayList<TileBloodTank>();
        for (BlockPos tankPos : tankPositions) {
            BlockPos actualPos = pos.func_177971_a((Vec3i)tankPos);
            TileEntity tank = world.func_175625_s(actualPos);
            if (!(tank instanceof TileBloodTank)) continue;
            world.markAndNotifyBlock(actualPos, world.func_175726_f(actualPos), world.func_180495_p(actualPos), world.func_180495_p(actualPos), 3);
            if (((TileBloodTank)tank).getTank().getFluidAmount() < 1000) continue;
            tanks.add((TileBloodTank)tank);
        }
        return tanks;
    }

    private int getFluidNumber(List<TileBloodTank> tanks, boolean lava) {
        if (lava) {
            return 1000 * tanks.stream().mapToInt(t -> Math.min(t.getTank().getFluidAmount(), 1000) / 1000).sum();
        }
        return 1000 * tanks.stream().mapToInt(t -> (t.getTank().getFluid().getFluid() == RegistrarBloodArsenalBlocks.FLUID_REFINED_LIFE_ESSENCE ? 2 : 1) * (Math.min(t.getTank().getFluidAmount(), 1000) / 1000)).sum() / 2;
    }

    private List<TileStasisPlate> getStasisPlates(World world, BlockPos pos) {
        ArrayList<TileStasisPlate> plates = new ArrayList<TileStasisPlate>();
        for (BlockPos platePos : GLOWSTONE_POS) {
            if (!(world.func_175625_s(pos.func_177971_a((Vec3i)platePos)) instanceof TileStasisPlate)) continue;
            plates.add((TileStasisPlate)world.func_175625_s(pos.func_177971_a((Vec3i)platePos)));
        }
        return plates;
    }

    private int getTotalDustAmount(List<TileStasisPlate> stasisPlates) {
        int amount = 0;
        for (TileStasisPlate stasisPlate : stasisPlates) {
            if (stasisPlate.func_70301_a(0).func_190926_b()) continue;
            if (stasisPlate.func_70301_a(0).func_77973_b() == Items.field_151114_aO) {
                ++amount;
                continue;
            }
            if (stasisPlate.func_70301_a(0).func_77973_b() != EnumBaseTypes.BLOOD_INFUSED_GLOWSTONE_DUST.getItem()) continue;
            amount += 2;
        }
        return amount;
    }

    private void shrinkInputs(World world, BlockPos pos) {
        for (BlockPos stasisPos : GLOWSTONE_POS) {
            TileStasisPlate stasisPlate;
            ItemStack plateStack;
            if (!(world.func_175625_s(pos.func_177971_a((Vec3i)stasisPos)) instanceof TileStasisPlate) || (plateStack = (stasisPlate = (TileStasisPlate)world.func_175625_s(pos.func_177971_a((Vec3i)stasisPos))).func_70301_a(0)).func_190926_b() || !ItemStack.func_179545_c((ItemStack)plateStack, (ItemStack)new ItemStack(Items.field_151114_aO)) && !ItemStack.func_179545_c((ItemStack)plateStack, (ItemStack)EnumBaseTypes.BLOOD_INFUSED_GLOWSTONE_DUST.getStack())) continue;
            plateStack.func_190918_g(1);
            stasisPlate.func_70299_a(0, plateStack);
        }
    }

    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addRune(components, 0, -1, 0, EnumRuneType.FIRE);
        this.addParallelRunes(components, 2, -1, EnumRuneType.FIRE);
        this.addOffsetRunes(components, 1, 2, -1, EnumRuneType.FIRE);
        this.addCornerRunes(components, 2, -1, EnumRuneType.BLANK);
        this.addParallelRunes(components, 2, 0, EnumRuneType.AIR);
        this.addOffsetRunes(components, 1, 2, 0, EnumRuneType.AIR);
        this.addCornerRunes(components, 2, 0, EnumRuneType.AIR);
        this.addParallelRunes(components, 3, 0, EnumRuneType.DUSK);
        this.addOffsetRunes(components, 3, 1, 0, EnumRuneType.FIRE);
        this.addOffsetRunes(components, 3, 2, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 3, 0, EnumRuneType.BLANK);
        this.addParallelRunes(components, 4, 0, EnumRuneType.WATER);
        this.addOffsetRunes(components, 4, 1, 0, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 4, 2, 0, EnumRuneType.WATER);
        this.addOffsetRunes(components, 4, 3, 0, EnumRuneType.EARTH);
        this.addCornerRunes(components, 4, 0, EnumRuneType.WATER);
        this.addOffsetRunes(components, 6, 5, -1, EnumRuneType.DUSK);
        this.addCornerRunes(components, 6, -1, EnumRuneType.DUSK);
        this.addCornerRunes(components, 5, -1, EnumRuneType.DUSK);
        for (int y = 0; y < 6; ++y) {
            if (y % 2 == 0) {
                this.addOffsetRunes(components, 6, 5, y, EnumRuneType.FIRE);
            }
            this.addCornerRunes(components, 6, y, EnumRuneType.FIRE);
        }
    }

    public Ritual getNewCopy() {
        return new RitualBloodBurner();
    }
}

