/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.modifier.modifiers;

import arcaratus.bloodarsenal.modifier.EnumModifierType;
import arcaratus.bloodarsenal.modifier.Modifier;
import arcaratus.bloodarsenal.modifier.StasisModifiable;
import arcaratus.bloodarsenal.registry.Constants;
import arcaratus.bloodarsenal.util.BloodArsenalUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.ItemHandlerHelper;

public class ModifierSmelting
extends Modifier {
    public ModifierSmelting() {
        super("smelting", Constants.Modifiers.SMELTING_COUNTER.length, EnumModifierType.CORE);
    }

    @Override
    public void onBlockDestroyed(ItemStack itemStack, World world, IBlockState state, BlockPos pos, EntityPlayer player, int level) {
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, player);
        if (MinecraftForge.EVENT_BUS.post((Event)event) || event.getResult() == Event.Result.DENY) {
            return;
        }
        ItemStack blockStack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        ItemStack resultStack = FurnaceRecipes.func_77602_a().func_151395_a(blockStack);
        world.func_175698_g(pos);
        if (!resultStack.func_190926_b()) {
            boolean hasFortune = StasisModifiable.getModifiableFromStack(itemStack).hasModifier("fortunate");
            if (level > 0 && hasFortune) {
                int i = random.nextInt(EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemStack) + 2) - 1;
                NonNullList drops = NonNullList.func_191196_a();
                drops.add((Object)ItemHandlerHelper.copyStackWithSize((ItemStack)resultStack, (int)(resultStack.func_190916_E() * (i + 1))));
                BloodArsenalUtils.dropStacks((NonNullList<ItemStack>)drops, world, pos);
                StasisModifiable.incrementModifierTracker(itemStack, this);
            } else if (level == 0 && !(resultStack.func_77973_b() instanceof ItemBlock)) {
                state.func_177230_c().func_176226_b(world, pos, state, 0);
            } else {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)resultStack);
                StasisModifiable.incrementModifierTracker(itemStack, this);
            }
        } else {
            state.func_177230_c().func_176226_b(world, pos, state, 0);
        }
    }
}

