/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.modifier;

import WayofTime.bloodmagic.util.Utils;
import arcaratus.bloodarsenal.modifier.IModifiableItem;
import arcaratus.bloodarsenal.modifier.ModifierTracker;
import arcaratus.bloodarsenal.modifier.StasisModifiable;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="bloodarsenal")
public class TrackerHandler {
    private static Random rand = new Random();

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        EntityPlayer player;
        ItemStack modifiableStack;
        DamageSource source = event.getSource();
        Entity sourceEntity = source.func_76364_f();
        EntityLivingBase attackedEntity = event.getEntityLiving();
        if (attackedEntity.func_94060_bK() instanceof EntityPlayer && !(modifiableStack = (player = (EntityPlayer)attackedEntity.func_94060_bK()).func_184614_ca()).func_190926_b() && modifiableStack.func_77973_b() instanceof IModifiableItem) {
            StasisModifiable modifiable = StasisModifiable.getModifiableFromStack(modifiableStack);
            float amount = Math.min(Utils.getModifiedDamage((EntityLivingBase)attackedEntity, (DamageSource)event.getSource(), (float)event.getAmount()), attackedEntity.func_110143_aJ());
            if (modifiable.hasModifier("flame") && source.func_76347_k()) {
                StasisModifiable.incrementModifierTracker(modifiableStack, "flame");
            }
            float reducedAmount = amount / 4.0f;
            if (modifiable.hasModifier("bloodlust")) {
                StasisModifiable.incrementModifierTracker(modifiableStack, "bloodlust", (double)reducedAmount);
            } else if (modifiable.hasModifier("sharpness")) {
                StasisModifiable.incrementModifierTracker(modifiableStack, "sharpness", (double)reducedAmount);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        StasisModifiable modifiable;
        EntityPlayer player;
        ItemStack modifiableStack;
        EntityLivingBase attackedEntity = event.getEntityLiving();
        if (event.getLootingLevel() >= 1 && attackedEntity.func_94060_bK() instanceof EntityPlayer && !(modifiableStack = (player = (EntityPlayer)attackedEntity.func_94060_bK()).func_184614_ca()).func_190926_b() && modifiableStack.func_77973_b() instanceof IModifiableItem && (modifiable = StasisModifiable.getModifiableFromStack(modifiableStack)).hasModifier("looting")) {
            StasisModifiable.incrementModifierTracker(modifiableStack, "looting");
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLivingXPDrop(LivingExperienceDropEvent event) {
        StasisModifiable modifiable;
        EntityPlayer player;
        ItemStack itemStack;
        if (event.getAttackingPlayer() != null && !(itemStack = (player = event.getAttackingPlayer()).func_184614_ca()).func_190926_b() && itemStack.func_77973_b() instanceof IModifiableItem && (modifiable = StasisModifiable.getModifiableFromStack(itemStack)).hasModifier("xperienced")) {
            ModifierTracker xpTracker = modifiable.getTrackerForModifier("xperienced");
            event.setDroppedExperience(event.getOriginalExperience() * (rand.nextInt(xpTracker.getLevel() + 2) + 1));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onXPPickup(PlayerPickupXpEvent event) {
        StasisModifiable modifiable;
        EntityPlayer player;
        ItemStack itemStack;
        if (event.getEntityPlayer() != null && !(itemStack = (player = event.getEntityPlayer()).func_184614_ca()).func_190926_b() && itemStack.func_77973_b() instanceof IModifiableItem && (modifiable = StasisModifiable.getModifiableFromStack(itemStack)).hasModifier("xperienced")) {
            StasisModifiable.incrementModifierTracker(itemStack, "xperienced", (double)event.getOrb().func_70526_d() / 4.0);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        StasisModifiable modifiable;
        EntityPlayer player;
        ItemStack itemStack;
        if (event.getPlayer() != null && !(itemStack = (player = event.getPlayer()).func_184614_ca()).func_190926_b() && itemStack.func_77973_b() instanceof IModifiableItem && (modifiable = StasisModifiable.getModifiableFromStack(itemStack)).hasModifier("xperienced") && event.getExpToDrop() > 0) {
            ModifierTracker xpTracker = modifiable.getTrackerForModifier("xperienced");
            event.setExpToDrop(event.getExpToDrop() * (rand.nextInt(xpTracker.getLevel() + 2) + 1));
        }
    }
}

