/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.modifier;

import WayofTime.bloodmagic.util.helper.TextHelper;
import arcaratus.bloodarsenal.modifier.EnumModifierType;
import arcaratus.bloodarsenal.modifier.IModifiable;
import arcaratus.bloodarsenal.modifier.Modifier;
import arcaratus.bloodarsenal.modifier.ModifierHandler;
import arcaratus.bloodarsenal.modifier.ModifierTracker;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import joptsimple.internal.Strings;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class StasisModifiable
implements IModifiable {
    private Map<String, Pair<Modifier, ModifierTracker>> modifierMap = new HashMap<String, Pair<Modifier, ModifierTracker>>();

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers() {
        HashMultimap attributeMap = HashMultimap.create();
        for (Map.Entry<String, Pair<Modifier, ModifierTracker>> entry : this.modifierMap.entrySet()) {
            Modifier modifier = (Modifier)entry.getValue().getLeft();
            ModifierTracker tracker = (ModifierTracker)entry.getValue().getRight();
            if (modifier == Modifier.EMPTY_MODIFIER) continue;
            attributeMap.putAll(modifier.getAttributeModifiers(tracker.getLevel()));
        }
        return attributeMap;
    }

    @Override
    public boolean hasModifier(String modifierKey) {
        return !Strings.isNullOrEmpty((String)modifierKey) && this.modifierMap.containsKey(modifierKey);
    }

    @Override
    public boolean canApplyModifier(Modifier modifier) {
        if (!ModifierHandler.isModifierCompatible(this.modifierMap.keySet(), modifier)) {
            return false;
        }
        for (EnumModifierType modType : EnumModifierType.values()) {
            int count = 0;
            for (Pair<Modifier, ModifierTracker> pair : this.modifierMap.values()) {
                if (((Modifier)pair.getLeft()).getType() != modType) continue;
                ++count;
            }
            if (count <= modType.getMax()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean markModifierReady(ItemStack itemStack, EntityPlayer player, Modifier modifier) {
        ModifierTracker tracker;
        if (modifier == Modifier.EMPTY_MODIFIER) {
            return false;
        }
        String key = modifier.getUniqueIdentifier();
        if (this.hasModifier(key) && !(tracker = (ModifierTracker)this.modifierMap.get(key).getRight()).isReadyToUpgrade()) {
            String name = ((Modifier)this.modifierMap.get(key).getLeft()).hasAltName() ? TextHelper.localize((String)modifier.getAlternateName(itemStack), (Object[])new Object[0]) : TextHelper.localize((String)modifier.getUnlocalizedName(), (Object[])new Object[0]);
            player.func_146105_b((ITextComponent)new TextComponentString(TextHelper.localizeEffect((String)"chat.bloodarsenal.modifier_ready", (Object[])new Object[]{name, tracker.getLevel() + 1})), true);
            return true;
        }
        return false;
    }

    @Override
    public boolean applyModifier(Pair<Modifier, ModifierTracker> modifierPair) {
        String key = ((Modifier)modifierPair.getLeft()).getUniqueIdentifier();
        if (!this.hasModifier(key)) {
            this.modifierMap.put(key, modifierPair);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeModifier(Modifier modifier) {
        String key = modifier.getUniqueIdentifier();
        if (this.hasModifier(key)) {
            this.modifierMap.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public boolean upgradeModifier(Modifier modifier) {
        ModifierTracker tracker;
        String key = modifier.getUniqueIdentifier();
        if (this.hasModifier(key) && (tracker = (ModifierTracker)this.modifierMap.get(key).getRight()).isReadyToUpgrade()) {
            tracker.onModifierUpgraded();
        }
        return false;
    }

    @Override
    public void onUpdate(ItemStack itemStack, World world, Entity entity, int itemSlot) {
        if (world.field_72995_K) {
            return;
        }
        for (Map.Entry<String, Pair<Modifier, ModifierTracker>> entry : this.modifierMap.entrySet()) {
            Modifier modifier = (Modifier)entry.getValue().getLeft();
            ModifierTracker tracker = (ModifierTracker)entry.getValue().getRight();
            if (modifier == Modifier.EMPTY_MODIFIER) continue;
            modifier.onUpdate(itemStack, world, entity, itemSlot, tracker.getLevel());
            if (!tracker.onTick() || !(entity instanceof EntityPlayer)) continue;
            this.markModifierReady(itemStack, (EntityPlayer)entity, modifier);
        }
    }

    @Override
    public void hitEntity(ItemStack itemStack, EntityLivingBase target, EntityLivingBase attacker) {
        for (Map.Entry<String, Pair<Modifier, ModifierTracker>> entry : this.modifierMap.entrySet()) {
            Modifier modifier = (Modifier)entry.getValue().getLeft();
            ModifierTracker tracker = (ModifierTracker)entry.getValue().getRight();
            if (modifier == Modifier.EMPTY_MODIFIER) continue;
            modifier.hitEntity(itemStack, target, attacker, tracker.getLevel());
        }
    }

    @Override
    public void onBlockDestroyed(ItemStack itemStack, World world, IBlockState state, BlockPos pos, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        for (Map.Entry<String, Pair<Modifier, ModifierTracker>> entry : this.modifierMap.entrySet()) {
            Modifier modifier = (Modifier)entry.getValue().getLeft();
            ModifierTracker tracker = (ModifierTracker)entry.getValue().getRight();
            if (modifier == Modifier.EMPTY_MODIFIER) continue;
            modifier.onBlockDestroyed(itemStack, world, state, pos, player, tracker.getLevel());
        }
    }

    @Override
    public void onRelease(ItemStack itemStack, World world, EntityPlayer player, int charge) {
        for (Map.Entry<String, Pair<Modifier, ModifierTracker>> entry : this.modifierMap.entrySet()) {
            Modifier modifier = (Modifier)entry.getValue().getLeft();
            ModifierTracker tracker = (ModifierTracker)entry.getValue().getRight();
            if (modifier == Modifier.EMPTY_MODIFIER || modifier.getType() != EnumModifierType.ABILITY) continue;
            modifier.onRelease(itemStack, world, player, charge, tracker.getLevel());
        }
    }

    @Override
    public void onRightClick(ItemStack itemStack, World world, EntityPlayer player) {
        for (Map.Entry<String, Pair<Modifier, ModifierTracker>> entry : this.modifierMap.entrySet()) {
            Modifier modifier = (Modifier)entry.getValue().getLeft();
            ModifierTracker tracker = (ModifierTracker)entry.getValue().getRight();
            if (modifier == Modifier.EMPTY_MODIFIER || modifier.getType() != EnumModifierType.ABILITY) continue;
            modifier.onRightClick(itemStack, world, player, tracker.getLevel());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList modTags = tag.func_150295_c("modifiers", 10);
        if (modTags != null) {
            for (int i = 0; i < modTags.func_74745_c(); ++i) {
                NBTTagCompound modTag = modTags.func_150305_b(i);
                String key = modTag.func_74779_i("Key");
                NBTTagCompound nbtTag = modTag.func_74775_l("modifier");
                Modifier modifier = ModifierHandler.getModifierFromKey(key, nbtTag);
                int level = modTag.func_74762_e("Level");
                ModifierTracker tracker = ModifierHandler.getTrackerFromKey(key, level);
                String trackerKey = tracker.getUniqueIdentifier();
                NBTTagCompound trackerTag = tag.func_74775_l(trackerKey);
                if (!trackerTag.func_82582_d()) {
                    tracker.readFromNBT(trackerTag);
                }
                if (modifier != Modifier.EMPTY_MODIFIER) {
                    this.modifierMap.put(key, (Pair<Modifier, ModifierTracker>)Pair.of((Object)modifier, (Object)tracker));
                    continue;
                }
                modTags.func_74744_a(i);
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, boolean forceWrite) {
        NBTTagList tags = new NBTTagList();
        for (Map.Entry<String, Pair<Modifier, ModifierTracker>> entry : this.modifierMap.entrySet()) {
            NBTTagCompound modifierTag = new NBTTagCompound();
            Modifier modifier = (Modifier)entry.getValue().getLeft();
            ModifierTracker tracker = (ModifierTracker)entry.getValue().getRight();
            NBTTagCompound nbtTag = new NBTTagCompound();
            modifier.writeToNBT(nbtTag);
            if (forceWrite || tracker.isDirty()) {
                String key = tracker.getUniqueIdentifier();
                NBTTagCompound trackerTag = new NBTTagCompound();
                tracker.writeToNBT(trackerTag);
                tag.func_74782_a(key, (NBTBase)trackerTag);
                tracker.resetDirty();
            }
            modifierTag.func_74778_a("Key", modifier.getUniqueIdentifier());
            modifierTag.func_74768_a("Level", tracker.getLevel());
            modifierTag.func_74782_a("modifier", (NBTBase)nbtTag);
            tags.func_74742_a((NBTBase)modifierTag);
        }
        tag.func_74782_a("modifiers", (NBTBase)tags);
    }

    @Override
    public void writeDirtyToNBT(NBTTagCompound tag) {
        this.writeToNBT(tag, false);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        this.writeToNBT(tag, true);
    }

    public Map<String, Pair<Modifier, ModifierTracker>> getModifierMap() {
        return this.modifierMap;
    }

    public Modifier getModifier(String modifierKey) {
        return (Modifier)this.modifierMap.getOrDefault(modifierKey, (Pair<Modifier, ModifierTracker>)Pair.of((Object)Modifier.EMPTY_MODIFIER, null)).getLeft();
    }

    public ModifierTracker getTrackerForModifier(Modifier modifier) {
        return this.getTrackerForModifier(modifier.getUniqueIdentifier());
    }

    public ModifierTracker getTrackerForModifier(String modifierKey) {
        return (ModifierTracker)this.modifierMap.getOrDefault(modifierKey, (Pair<Modifier, ModifierTracker>)Pair.of((Object)Modifier.EMPTY_MODIFIER, null)).getRight();
    }

    public static StasisModifiable getModifiableFromStack(ItemStack itemStack) {
        NBTTagCompound tag = StasisModifiable.getNBTTag(itemStack);
        StasisModifiable modifiable = new StasisModifiable();
        modifiable.readFromNBT(tag);
        return modifiable;
    }

    public static void setModifiable(ItemStack itemStack, StasisModifiable modifiable, boolean forceWrite) {
        NBTTagCompound tag = new NBTTagCompound();
        if (!forceWrite) {
            tag = StasisModifiable.getNBTTag(itemStack);
            modifiable.writeDirtyToNBT(tag);
        } else {
            modifiable.writeDirtyToNBT(tag);
        }
        StasisModifiable.setNBTTag(itemStack, tag);
    }

    public static NBTTagCompound getNBTTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p().func_74775_l("stasisModifiers");
    }

    public static void setNBTTag(ItemStack stack, NBTTagCompound tag) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74782_a("stasisModifiers", (NBTBase)tag);
    }

    public static void incrementModifierTracker(ItemStack itemStack, Modifier modifier, double increment) {
        StasisModifiable.incrementModifierTracker(itemStack, modifier.getUniqueIdentifier(), increment);
    }

    public static void incrementModifierTracker(ItemStack itemStack, Modifier modifier) {
        StasisModifiable.incrementModifierTracker(itemStack, modifier.getUniqueIdentifier(), 1.0);
    }

    public static void incrementModifierTracker(ItemStack itemStack, String modifierKey, double increment) {
        StasisModifiable modifiable = StasisModifiable.getModifiableFromStack(itemStack);
        modifiable.getTrackerForModifier(modifierKey).incrementCounter(increment);
        StasisModifiable.setModifiable(itemStack, modifiable, false);
    }

    public static void incrementModifierTracker(ItemStack itemStack, String modifierKey) {
        StasisModifiable.incrementModifierTracker(itemStack, modifierKey, 1.0);
    }
}

