/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.modifier;

import WayofTime.bloodmagic.util.Utils;
import net.minecraft.nbt.NBTTagCompound;

public class ModifierTracker {
    private double counter;
    public final int[] COUNTERS_NEEDED;
    private int level;
    private boolean readyToUpgrade;
    private boolean isDirty = false;
    protected String name;
    private final String modifierKey;

    public ModifierTracker(String modifierKey, int[] countersNeeded) {
        this.modifierKey = modifierKey;
        this.COUNTERS_NEEDED = countersNeeded;
        this.counter = 0.0;
        this.level = 0;
        this.readyToUpgrade = false;
    }

    public ModifierTracker copy(int level) {
        ModifierTracker tracker = new ModifierTracker(this.modifierKey, this.COUNTERS_NEEDED);
        tracker.setLevel(level);
        return tracker;
    }

    protected String getName() {
        return this.modifierKey;
    }

    public double getCounter() {
        return this.counter;
    }

    public String getUniqueIdentifier() {
        return "bloodarsenal.tracker." + this.getName();
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public boolean isReadyToUpgrade() {
        return this.readyToUpgrade;
    }

    public void setCounter(double counter) {
        this.counter = counter;
    }

    public void setReadyToUpgrade(boolean upgrade) {
        this.readyToUpgrade = upgrade;
    }

    public void resetCounter() {
        this.counter = 0.0;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.counter = tag.func_74769_h("Counter");
        this.level = tag.func_74762_e("Level");
        this.readyToUpgrade = tag.func_74767_n("ReadyToUpgrade");
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74780_a("Counter", this.counter);
        tag.func_74768_a("Level", this.level);
        tag.func_74757_a("ReadyToUpgrade", this.readyToUpgrade);
    }

    public boolean onTick() {
        if (this.level <= this.COUNTERS_NEEDED.length - 1 && this.readyToUpgrade) {
            this.markDirty();
            return true;
        }
        return false;
    }

    public double getProgress() {
        return Utils.calculateStandardProgress((Number)this.counter, (int[])this.COUNTERS_NEEDED, (int)this.level);
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final void markDirty() {
        this.isDirty = true;
    }

    public final void resetDirty() {
        this.isDirty = false;
    }

    public boolean providesModifier(String key) {
        return key.equals(this.getUniqueIdentifier());
    }

    public void onModifierUpgraded() {
        if (this.level < this.COUNTERS_NEEDED.length) {
            this.level = Math.min(++this.level, this.COUNTERS_NEEDED.length - 1);
            this.counter = Math.max(this.counter, (double)this.COUNTERS_NEEDED[this.level]);
            this.setReadyToUpgrade(false);
            this.markDirty();
        }
    }

    public void incrementCounter(double increment) {
        if (this.readyToUpgrade) {
            return;
        }
        this.counter += increment;
        if (this.level < this.COUNTERS_NEEDED.length - 1 && this.counter >= (double)this.COUNTERS_NEEDED[this.level + 1]) {
            this.setReadyToUpgrade(true);
            this.resetCounter();
        }
        this.markDirty();
    }
}

