/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.item;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.util.helper.TextHelper;
import arcaratus.bloodarsenal.modifier.IModifiableItem;
import arcaratus.bloodarsenal.modifier.Modifier;
import arcaratus.bloodarsenal.modifier.ModifierHandler;
import arcaratus.bloodarsenal.modifier.ModifierHelper;
import arcaratus.bloodarsenal.modifier.ModifierTracker;
import arcaratus.bloodarsenal.modifier.StasisModifiable;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import joptsimple.internal.Strings;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class ItemModifierTome
extends Item
implements IVariantProvider {
    public ItemModifierTome(String name) {
        this.func_77655_b("bloodarsenal." + name);
        this.setRegistryName(name);
        this.func_77637_a(BloodMagic.TAB_TOMES);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs creativeTab, NonNullList<ItemStack> list) {
        if (creativeTab == BloodMagic.TAB_TOMES) {
            List<String> blackListedTomes = Arrays.asList("bad_potion", "beneficial_potion", "sigil");
            for (Map.Entry<String, Integer> entry : ModifierHandler.modifierMaxLevelMap.entrySet()) {
                String key = entry.getKey();
                if (blackListedTomes.contains(key)) continue;
                int maxLevel = entry.getValue();
                for (int i = 0; i < maxLevel; ++i) {
                    ItemStack stack = new ItemStack((Item)this);
                    ModifierHelper.setKey(stack, key);
                    ModifierHelper.setLevel(stack, i);
                    ModifierHelper.setReady(stack, false);
                    list.add((Object)stack);
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        StasisModifiable modifiable;
        ItemStack otherStack;
        if (world.field_72995_K || hand != EnumHand.MAIN_HAND) {
            return super.func_77659_a(world, player, hand);
        }
        ItemStack itemStack = player.func_184586_b(hand);
        Pair<Modifier, ModifierTracker> pair = ModifierHelper.getModifierAndTracker(itemStack);
        Modifier modifier = (Modifier)pair.getLeft();
        ModifierTracker tracker = (ModifierTracker)pair.getRight();
        NBTTagCompound specialNBT = null;
        if (modifier != Modifier.EMPTY_MODIFIER && !(otherStack = player.func_184586_b(EnumHand.OFF_HAND)).func_190926_b() && otherStack.func_77973_b() instanceof IModifiableItem && (modifiable = StasisModifiable.getModifiableFromStack(otherStack)) != null && modifiable.canApplyModifier(modifier) && modifiable.applyModifier(pair)) {
            boolean hasSpecialNBT;
            boolean bl = hasSpecialNBT = modifier.getSpecialNBT(itemStack) != null;
            if (hasSpecialNBT) {
                specialNBT = modifier.getSpecialNBT(itemStack);
            }
            modifier.removeSpecialNBT(otherStack);
            if (hasSpecialNBT) {
                modifier.writeSpecialNBT(otherStack, new ItemStack(specialNBT.func_74775_l("itemStack")), tracker.getLevel());
            } else {
                modifier.writeSpecialNBT(otherStack, tracker.getLevel());
            }
            StasisModifiable.setModifiable(otherStack, modifiable, false);
            String name = modifier.hasAltName() ? TextHelper.localize((String)modifier.getAlternateName(itemStack), (Object[])new Object[0]) : TextHelper.localize((String)modifier.getUnlocalizedName(), (Object[])new Object[0]);
            player.func_146105_b((ITextComponent)new TextComponentString(TextHelper.localizeEffect((String)"chat.bloodarsenal.modifier_added", (Object[])new Object[]{name, tracker.getLevel() + 1, otherStack.func_82833_r()})), true);
            itemStack.func_190918_g(1);
        }
        return super.func_77659_a(world, player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (!itemStack.func_77942_o()) {
            return;
        }
        Pair<Modifier, ModifierTracker> pair = ModifierHelper.getModifierAndTracker(itemStack);
        Modifier modifier = (Modifier)pair.getLeft();
        ModifierTracker tracker = (ModifierTracker)pair.getRight();
        if (modifier != null) {
            String name = modifier.hasAltName() && !Strings.isNullOrEmpty((String)modifier.getAlternateName(itemStack)) ? TextHelper.localize((String)modifier.getAlternateName(itemStack), (Object[])new Object[0]) : TextHelper.localize((String)modifier.getUnlocalizedName(), (Object[])new Object[0]);
            tooltip.add(TextHelper.localizeEffect((String)"tooltip.bloodarsenal.modifier.level", (Object[])new Object[]{name, tracker.getLevel() + 1, tracker.isReadyToUpgrade() ? "+" : ""}));
        }
    }

    public void gatherVariants(@Nonnull Int2ObjectMap<String> variants) {
        variants.put(0, (Object)"type=normal");
    }
}

