/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.compat;

import arcaratus.bloodarsenal.compat.ICompatibilityPlugin;
import arcaratus.bloodarsenal.util.BALog;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface CompatibilityPlugin {
    public String value();

    public static class Gather {
        public static Set<ICompatibilityPlugin> gather(ASMDataTable dataTable) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            HashSet loaders = Sets.newHashSet();
            Set discoveredLoaders = dataTable.getAll(CompatibilityPlugin.class.getName());
            for (ASMDataTable.ASMData data : discoveredLoaders) {
                try {
                    if (!Loader.isModLoaded((String)((String)data.getAnnotationInfo().get("value")))) continue;
                    Class<?> asmClass = Class.forName(data.getClassName());
                    if (!ICompatibilityPlugin.class.isAssignableFrom(asmClass)) {
                        BALog.DEFAULT.error("Class at {} was annotated with @CompatibilityPlugin but is not an ICompatibilityPlugin.", data.getClassName());
                        continue;
                    }
                    BALog.DEBUG.info("Discovered a compatibility plugin at {}", data.getClassName());
                    loaders.add((ICompatibilityPlugin)asmClass.newInstance());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            BALog.DEBUG.info("Discovered {} plugin(s) in {}", loaders.size(), stopwatch.stop());
            return loaders;
        }
    }
}

