/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.ritual.EnumRitualReaderState;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.soul.IDiscreteDemonWill;
import WayofTime.bloodmagic.util.ChatUtil;
import WayofTime.bloodmagic.util.helper.NBTHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ItemRitualReader
extends Item
implements IVariantProvider {
    public static final String tooltipBase = "tooltip.bloodmagic.ritualReader.";

    public ItemRitualReader() {
        this.func_77655_b("bloodmagic.ritualReader");
        this.func_77625_d(1);
        this.func_77637_a(BloodMagic.TAB_BM);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag tooltipFlag) {
        boolean sneaking;
        if (!stack.func_77942_o()) {
            return;
        }
        EnumRitualReaderState state = this.getState(stack);
        tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.ritualReader.currentState", TextHelper.localizeEffect(tooltipBase + state.toString().toLowerCase(), new Object[0])));
        tooltip.add("");
        boolean bl = sneaking = Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42);
        if (sneaking) {
            tooltip.addAll(Arrays.asList(TextHelper.cutLongString(TextHelper.localizeEffect("tooltip.bloodmagic.ritualReader.desc." + state.toString().toLowerCase(), new Object[0]))));
        } else {
            tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.extraInfo", new Object[0]));
        }
        super.func_77624_a(stack, world, tooltip, tooltipFlag);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        RayTraceResult ray = this.func_77621_a(world, player, false);
        if (ray != null && ray.field_72313_a == RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                this.cycleReader(stack, player);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            BlockPos masterPos;
            EnumRitualReaderState state = this.getState(stack);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof IMasterRitualStone) {
                IMasterRitualStone master = (IMasterRitualStone)tile;
                if (master.getCurrentRitual() == null) {
                    super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
                }
                this.setMasterBlockPos(stack, pos);
                this.setBlockPos(stack, BlockPos.field_177992_a);
                switch (state) {
                    case INFORMATION: {
                        master.provideInformationOfRitualToPlayer(player);
                        break;
                    }
                    case SET_AREA: {
                        String range = this.getCurrentBlockRange(stack);
                        if (range == null || player.func_70093_af()) {
                            String newRange;
                            range = newRange = master.getNextBlockRange(range);
                            this.setCurrentBlockRange(stack, newRange);
                        }
                        master.provideInformationOfRangeToPlayer(player, range);
                        break;
                    }
                    case SET_WILL_TYPES: {
                        ArrayList<EnumDemonWillType> typeList = new ArrayList<EnumDemonWillType>();
                        NonNullList inv = player.field_71071_by.field_70462_a;
                        for (int i = 0; i < 9; ++i) {
                            EnumDemonWillType type;
                            ItemStack testStack = (ItemStack)inv.get(i);
                            if (testStack.func_190926_b() || !(testStack.func_77973_b() instanceof IDiscreteDemonWill) || typeList.contains(type = ((IDiscreteDemonWill)testStack.func_77973_b()).getType(testStack))) continue;
                            typeList.add(type);
                        }
                        master.setActiveWillConfig(player, typeList);
                        master.provideInformationOfWillConfigToPlayer(player, typeList);
                    }
                }
                return EnumActionResult.FAIL;
            }
            if (state == EnumRitualReaderState.SET_AREA && !(masterPos = this.getMasterBlockPos(stack)).equals((Object)BlockPos.field_177992_a)) {
                BlockPos containedPos = this.getBlockPos(stack);
                if (containedPos.equals((Object)BlockPos.field_177992_a)) {
                    BlockPos pos1 = pos.func_177973_b((Vec3i)masterPos);
                    this.setBlockPos(stack, pos1);
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("ritual.bloodmagic.blockRange.firstBlock", new Object[0]), true);
                    player.func_145747_a((ITextComponent)new TextComponentString(pos1.toString()));
                } else {
                    tile = world.func_175625_s(masterPos);
                    if (tile instanceof IMasterRitualStone) {
                        IMasterRitualStone master = (IMasterRitualStone)tile;
                        BlockPos pos2 = pos.func_177973_b((Vec3i)masterPos);
                        String range = this.getCurrentBlockRange(stack);
                        Ritual ritual = master.getCurrentRitual();
                        int maxHorizontalRange = ritual.getMaxHorizontalRadiusForRange(range, null, null) - 1;
                        int maxVerticalRange = ritual.getMaxVerticalRadiusForRange(range, null, null) - 1;
                        int maxVolume = ritual.getMaxVolumeForRange(range, null, null);
                        switch (master.setBlockRangeByBounds(player, range, containedPos, pos2)) {
                            case SUCCESS: {
                                player.func_146105_b((ITextComponent)new TextComponentTranslation("ritual.bloodmagic.blockRange.success", new Object[0]), true);
                                break;
                            }
                            case NOT_WITHIN_BOUNDARIES: {
                                player.func_146105_b((ITextComponent)new TextComponentTranslation("ritual.bloodmagic.blockRange.tooFar", new Object[]{maxVerticalRange, maxHorizontalRange}), false);
                                break;
                            }
                            case VOLUME_TOO_LARGE: {
                                player.func_146105_b((ITextComponent)new TextComponentTranslation("ritual.bloodmagic.blockRange.tooBig", new Object[]{maxVolume}), false);
                                break;
                            }
                            default: {
                                player.func_146105_b((ITextComponent)new TextComponentTranslation("ritual.bloodmagic.blockRange.noRange", new Object[0]), false);
                            }
                        }
                    }
                    this.setBlockPos(stack, BlockPos.field_177992_a);
                }
            }
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public BlockPos getBlockPos(ItemStack stack) {
        stack = NBTHelper.checkNBT(stack);
        return new BlockPos(stack.func_77978_p().func_74762_e("xCoord"), stack.func_77978_p().func_74762_e("yCoord"), stack.func_77978_p().func_74762_e("zCoord"));
    }

    public ItemStack setBlockPos(ItemStack stack, BlockPos pos) {
        stack = NBTHelper.checkNBT(stack);
        NBTTagCompound itemTag = stack.func_77978_p();
        itemTag.func_74768_a("xCoord", pos.func_177958_n());
        itemTag.func_74768_a("yCoord", pos.func_177956_o());
        itemTag.func_74768_a("zCoord", pos.func_177952_p());
        return stack;
    }

    public BlockPos getMasterBlockPos(ItemStack stack) {
        stack = NBTHelper.checkNBT(stack);
        return new BlockPos(stack.func_77978_p().func_74762_e("xCoordmaster"), stack.func_77978_p().func_74762_e("yCoordmaster"), stack.func_77978_p().func_74762_e("zCoordmaster"));
    }

    public ItemStack setMasterBlockPos(ItemStack stack, BlockPos pos) {
        stack = NBTHelper.checkNBT(stack);
        NBTTagCompound itemTag = stack.func_77978_p();
        itemTag.func_74768_a("xCoordmaster", pos.func_177958_n());
        itemTag.func_74768_a("yCoordmaster", pos.func_177956_o());
        itemTag.func_74768_a("zCoordmaster", pos.func_177952_p());
        return stack;
    }

    public String getCurrentBlockRange(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74779_i("range");
    }

    public void setCurrentBlockRange(ItemStack stack, String range) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74778_a("range", range);
    }

    public void cycleReader(ItemStack stack, EntityPlayer player) {
        EnumRitualReaderState prevState = this.getState(stack);
        int val = prevState.ordinal();
        int nextVal = val + 1 >= EnumRitualReaderState.values().length ? 0 : val + 1;
        EnumRitualReaderState nextState = EnumRitualReaderState.values()[nextVal];
        this.setState(stack, nextState);
        this.notifyPlayerOfStateChange(nextState, player);
    }

    public void notifyPlayerOfStateChange(EnumRitualReaderState state, EntityPlayer player) {
        ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("tooltip.bloodmagic.ritualReader.currentState", new Object[]{new TextComponentTranslation(tooltipBase + state.toString().toLowerCase(), new Object[0])})});
    }

    public void setState(ItemStack stack, EnumRitualReaderState state) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74768_a("ritualReaderState", state.ordinal());
    }

    public EnumRitualReaderState getState(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            return EnumRitualReaderState.INFORMATION;
        }
        NBTTagCompound tag = stack.func_77978_p();
        return EnumRitualReaderState.values()[tag.func_74762_e("ritualReaderState")];
    }

    @Override
    public void gatherVariants(@Nonnull Int2ObjectMap<String> variants) {
        variants.put(0, (Object)"type=normal");
    }
}

