/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.disk;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskListener;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class StorageDiskFluid
implements IStorageDisk<FluidStack> {
    static final String NBT_VERSION = "Version";
    static final String NBT_CAPACITY = "Capacity";
    static final String NBT_FLUIDS = "Fluids";
    private World world;
    private int capacity;
    private Multimap<Fluid, FluidStack> stacks = ArrayListMultimap.create();
    @Nullable
    private IStorageDiskListener listener;
    private IStorageDiskContainerContext context;

    public StorageDiskFluid(World world, int capacity) {
        if (world == null) {
            throw new IllegalArgumentException("World cannot be null");
        }
        this.world = world;
        this.capacity = capacity;
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (FluidStack stack : this.stacks.values()) {
            list.func_74742_a((NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74778_a(NBT_VERSION, "1.6.14");
        tag.func_74782_a(NBT_FLUIDS, (NBTBase)list);
        tag.func_74768_a(NBT_CAPACITY, this.capacity);
        return tag;
    }

    @Override
    public Collection<FluidStack> getStacks() {
        return this.stacks.values();
    }

    @Override
    @Nullable
    public FluidStack insert(@Nonnull FluidStack stack, int size, Action action) {
        for (FluidStack otherStack : this.stacks.get((Object)stack.getFluid())) {
            if (!otherStack.isFluidEqual(stack)) continue;
            if (this.getCapacity() != -1 && this.getStored() + size > this.getCapacity()) {
                int remainingSpace = this.getCapacity() - this.getStored();
                if (remainingSpace <= 0) {
                    return StackUtils.copy(stack, size);
                }
                if (action == Action.PERFORM) {
                    otherStack.amount += remainingSpace;
                    this.onChanged();
                }
                return StackUtils.copy(otherStack, size - remainingSpace);
            }
            if (action == Action.PERFORM) {
                otherStack.amount += size;
                this.onChanged();
            }
            return null;
        }
        if (this.getCapacity() != -1 && this.getStored() + size > this.getCapacity()) {
            int remainingSpace = this.getCapacity() - this.getStored();
            if (remainingSpace <= 0) {
                return StackUtils.copy(stack, size);
            }
            if (action == Action.PERFORM) {
                this.stacks.put((Object)stack.getFluid(), (Object)StackUtils.copy(stack, remainingSpace));
                this.onChanged();
            }
            return StackUtils.copy(stack, size - remainingSpace);
        }
        if (action == Action.PERFORM) {
            this.stacks.put((Object)stack.getFluid(), (Object)StackUtils.copy(stack, size));
            this.onChanged();
        }
        return null;
    }

    @Override
    @Nullable
    public FluidStack extract(@Nonnull FluidStack stack, int size, int flags, Action action) {
        for (FluidStack otherStack : this.stacks.get((Object)stack.getFluid())) {
            if (!API.instance().getComparer().isEqual(otherStack, stack, flags)) continue;
            if (size > otherStack.amount) {
                size = otherStack.amount;
            }
            if (action == Action.PERFORM) {
                if (otherStack.amount - size == 0) {
                    this.stacks.remove((Object)otherStack.getFluid(), (Object)otherStack);
                } else {
                    otherStack.amount -= size;
                }
                this.onChanged();
            }
            return StackUtils.copy(otherStack, size);
        }
        return null;
    }

    @Override
    public int getStored() {
        return this.stacks.values().stream().mapToInt(s -> s.amount).sum();
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public AccessType getAccessType() {
        return this.context.getAccessType();
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int getCacheDelta(int storedPreInsertion, int size, @Nullable FluidStack remainder) {
        if (this.getAccessType() == AccessType.INSERT) {
            return 0;
        }
        return remainder == null ? size : size - remainder.amount;
    }

    @Override
    public void setSettings(@Nullable IStorageDiskListener listener, IStorageDiskContainerContext context) {
        this.listener = listener;
        this.context = context;
    }

    @Override
    public String getId() {
        return "normal_fluid";
    }

    Multimap<Fluid, FluidStack> getRawStacks() {
        return this.stacks;
    }

    private void onChanged() {
        if (this.listener != null) {
            this.listener.onChanged();
        }
        API.instance().getStorageDiskManager(this.world).markForSaving();
    }
}

