/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.lib.gui;

import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Rectangle4i;
import java.awt.Point;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.covers1624.lib.gui.DrawableGuiElement;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public abstract class GuiAnimBase
extends GuiContainer {
    private Set<DrawableGuiElement> drawableElements = new HashSet<DrawableGuiElement>();
    private ResourceLocation BACKGROUND_TEX;

    public GuiAnimBase(Container container) {
        super(container);
    }

    protected void setBackgroundTexture(ResourceLocation location) {
        this.BACKGROUND_TEX = location;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(-this.field_147003_i), (float)(-this.field_147009_r), (float)0.0f);
        for (DrawableGuiElement drawableGuiElement : this.drawableElements) {
            Point guiPos = this.getGuiPos();
            Rectangle4i bounds = drawableGuiElement.getBounds().offset(guiPos.x, guiPos.y);
            if (!bounds.contains(mouseX, mouseY)) continue;
            drawableGuiElement.renderTooltip(new Point(mouseX, mouseY));
            break;
        }
        GlStateManager.func_179121_F();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        Point guiPos = this.getGuiPos();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)guiPos.x, (float)guiPos.y, (float)0.0f);
        for (DrawableGuiElement drawableElement : this.drawableElements) {
            try {
                drawableElement.draw();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        GlStateManager.func_179121_F();
    }

    protected void addDrawable(DrawableGuiElement element) {
        this.drawableElements.add(element);
    }

    protected DrawableBuilder drawableBuilder() {
        return new DrawableBuilder().setParent((Gui)this).setSpriteLocation(this.BACKGROUND_TEX).setAnimationDirection(DrawableGuiElement.AnimationDirection.STATIC);
    }

    protected Point getGuiPos() {
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        return new Point(x, y);
    }

    protected void drawBackground() {
        Point guiPos = this.getGuiPos();
        TextureUtils.changeTexture((ResourceLocation)this.BACKGROUND_TEX);
        this.func_73729_b(guiPos.x, guiPos.y, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected static class DrawableBuilder {
        private Gui parent;
        private ResourceLocation spriteLocation;
        private Rectangle4i sprite;
        private Point location;
        private BooleanSupplier renderPredicate;
        private Supplier<Pair<Integer, Integer>> animationSupplier;
        private DrawableGuiElement.AnimationDirection animationDirection;
        private Supplier<String> tooltipSupplier;

        public DrawableBuilder setParent(Gui parent) {
            this.parent = parent;
            return this;
        }

        public DrawableBuilder setSpriteLocation(ResourceLocation spriteLocation) {
            this.spriteLocation = spriteLocation;
            return this;
        }

        public DrawableBuilder setSpriteSize(Rectangle4i sprite) {
            this.sprite = sprite;
            return this;
        }

        public DrawableBuilder setGuiLocation(Point location) {
            this.location = location;
            return this;
        }

        public DrawableBuilder setSpriteSize(int x, int y, int w, int h) {
            return this.setSpriteSize(new Rectangle4i(x, y, w, h));
        }

        public DrawableBuilder setGuiLocation(int x, int y) {
            return this.setGuiLocation(new Point(x, y));
        }

        public DrawableBuilder setAnimationSupplier(Supplier<Pair<Integer, Integer>> animationSupplier) {
            this.animationSupplier = animationSupplier;
            return this;
        }

        public DrawableBuilder setAnimationDirection(DrawableGuiElement.AnimationDirection animationDirection) {
            this.animationDirection = animationDirection;
            return this;
        }

        public DrawableBuilder setRenderPredicate(BooleanSupplier renderPredicate) {
            this.renderPredicate = renderPredicate;
            return this;
        }

        public DrawableBuilder setTooltipSupplier(Supplier<String> tooltipSupplier) {
            this.tooltipSupplier = tooltipSupplier;
            return this;
        }

        public DrawableGuiElement build() {
            return new DrawableGuiElement(this.parent, this.spriteLocation, this.sprite, this.location, this.animationDirection, this.animationSupplier, this.renderPredicate, this.tooltipSupplier);
        }
    }
}

