/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.pieces.chests;

import jaredbgreat.dldungeons.ConfigHandler;
import jaredbgreat.dldungeons.api.DLDEvent;
import jaredbgreat.dldungeons.builder.DBlock;
import jaredbgreat.dldungeons.pieces.chests.LootCategory;
import jaredbgreat.dldungeons.pieces.chests.LootType;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BasicChest {
    public int mx;
    public int my;
    public int mz;
    protected int level;
    private static int A1 = 2;
    private static int B1 = 1;
    private static int C1 = 2;
    protected LootCategory category;

    public BasicChest(int x, int y, int z, int level, LootCategory category) {
        this.mx = x;
        this.my = y;
        this.mz = z;
        this.level = level;
        this.category = category;
    }

    public void place(World world, int x, int y, int z, Random random) {
        BlockPos pos = new BlockPos(x, y, z);
        this.level += random.nextInt(2);
        if (this.level >= 7) {
            this.level = 6;
        }
        if (world.func_180495_p(pos).func_177230_c() != DBlock.chest) {
            System.err.println("[DLDUNGEONS] ERROR! Trying to put loot into non-chest at " + x + ", " + y + ", " + z + " (basic chest).");
            return;
        }
        TileEntityChest contents = (TileEntityChest)world.func_175625_s(pos);
        int which = random.nextInt(3);
        switch (which) {
            case 0: {
                this.fillChest(contents, LootType.HEAL, random);
                break;
            }
            case 1: {
                this.fillChest(contents, LootType.GEAR, random);
                break;
            }
            case 2: {
                this.fillChest(contents, LootType.RANDOM, random);
            }
        }
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)new DLDEvent.AfterChestTileEntity(world, contents, which, x, y, z, random, this.level));
    }

    protected void fillChest(TileEntityChest chest, LootType kind, Random random) {
        ItemStack treasure;
        int num = random.nextInt(Math.max(2, A1 + this.level / B1)) + C1;
        for (int i = 0; i < num; ++i) {
            ItemStack treasure2 = this.category.getLoot(kind, this.level, random);
            if (treasure2 == null) continue;
            chest.func_70299_a(random.nextInt(27), treasure2);
        }
        if (!ConfigHandler.vanillaLoot && (treasure = this.category.getLoot(LootType.HEAL, this.level, random)) != null) {
            chest.func_70299_a(random.nextInt(27), treasure);
        }
    }

    public static void setBasicLootNumbers(int a, int b, int c) {
        A1 = a;
        B1 = b;
        C1 = c;
    }
}

