/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.tools.handlers;

import com.codetaylor.mc.artisanworktables.api.recipe.IToolHandler;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GTCEToolHandler
implements IToolHandler {
    private static final Logger LOGGER = LogManager.getLogger(GTCEToolHandler.class);
    private final Class<?> classGTUtility = Class.forName("gregtech.api.util.GTUtility");
    private final Class<?> classIDamagableItem = Class.forName("gregtech.api.items.IToolItem");
    private final Class<?> classGregtechCapabilities = Class.forName("gregtech.api.capability.GregtechCapabilities");
    private final Capability<?> capabilityElectricItem;
    private final Method methodDoDamageItem;

    public GTCEToolHandler() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException, NoSuchMethodException {
        Field field = this.classGregtechCapabilities.getField("CAPABILITY_ELECTRIC_ITEM");
        this.capabilityElectricItem = (Capability)field.get(null);
        this.methodDoDamageItem = this.classGTUtility.getMethod("doDamageItem", ItemStack.class, Integer.TYPE, Boolean.TYPE);
    }

    @Override
    public boolean matches(ItemStack itemStack) {
        return this.classIDamagableItem.isAssignableFrom(itemStack.func_77973_b().getClass()) || itemStack.hasCapability(this.capabilityElectricItem, null);
    }

    @Override
    public boolean canAcceptAllDamage(ItemStack itemStack, int damage) {
        return this.GTUtility_doDamageItem(itemStack, damage, true);
    }

    @Override
    public boolean applyDamage(World world, ItemStack itemStack, int damage, boolean simulate) {
        if (!simulate && world.field_72995_K && itemStack.func_77978_p() != null) {
            itemStack.func_77982_d(itemStack.func_77978_p().func_74737_b());
        }
        return !this.GTUtility_doDamageItem(itemStack, damage, simulate);
    }

    private boolean GTUtility_doDamageItem(ItemStack itemStack, int damage, boolean simulate) {
        try {
            return (Boolean)this.methodDoDamageItem.invoke(null, itemStack, damage, simulate);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.error("Error damaging item: " + itemStack, (Throwable)e);
            return false;
        }
    }

    private static final class Reference {
        private static final String CLASS_GTUTILITY = "gregtech.api.util.GTUtility";
        private static final String CLASS_ITOOLITEM = "gregtech.api.items.IToolItem";
        private static final String CLASS_GREGTECHCAPABILITIES = "gregtech.api.capability.GregtechCapabilities";
        private static final String FIELD_CAPABILITY_ELECTRIC_ITEM = "CAPABILITY_ELECTRIC_ITEM";
        private static final String METHOD_DO_DAMAGE_ITEM = "doDamageItem";

        private Reference() {
        }
    }
}

